/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.time.Instant;
import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class DateTimeUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MINUTE = 60000000000L;
    public static final long NANOS_PER_HOUR = 3600000000000L;
    public static final long NANOS_PER_DAY = 86400000000000L;
    public static final int SHIFT_YEAR = 9;
    public static final int SHIFT_MONTH = 5;
    public static final int EPOCH_DATE_VALUE = 1008673;
    public static final long MIN_DATE_VALUE = -511999999967L;
    public static final long MAX_DATE_VALUE = 512000000415L;
    private static final int[] NORMAL_DAYS_PER_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] FRACTIONAL_SECONDS_TABLE = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static volatile TimeZoneProvider LOCAL;

    private DateTimeUtils() {
    }

    public static void resetCalendar() {
        LOCAL = null;
    }

    public static TimeZoneProvider getTimeZone() {
        TimeZoneProvider local = LOCAL;
        if (local == null) {
            LOCAL = local = TimeZoneProvider.getDefault();
        }
        return local;
    }

    public static ValueTimestampTimeZone currentTimestamp(TimeZoneProvider timeZone) {
        return DateTimeUtils.currentTimestamp(timeZone, Instant.now());
    }

    public static ValueTimestampTimeZone currentTimestamp(TimeZoneProvider timeZone, Instant now) {
        long second = now.getEpochSecond();
        int offset = timeZone.getTimeZoneOffsetUTC(second);
        return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay((second += (long)offset) / 86400L), second % 86400L * 1000000000L + (long)now.getNano(), offset);
    }

    public static long parseDateValue(String s, int start, int end) {
        int dStart;
        int mEnd;
        int mStart;
        int yEnd;
        if (s.charAt(start) == '+') {
            ++start;
        }
        if ((yEnd = s.indexOf(45, start + 1)) > 0) {
            mStart = yEnd + 1;
            mEnd = s.indexOf(45, mStart);
            if (mEnd <= mStart) {
                throw new IllegalArgumentException(s);
            }
            dStart = mEnd + 1;
        } else {
            dStart = end - 2;
            mEnd = dStart;
            mStart = mEnd - 2;
            yEnd = mStart;
            if (yEnd < start + 3) {
                throw new IllegalArgumentException(s);
            }
        }
        int year = Integer.parseInt(s.substring(start, yEnd));
        int month = StringUtils.parseUInt31(s, mStart, mEnd);
        int day = StringUtils.parseUInt31(s, dStart, end);
        if (!DateTimeUtils.isValidDate(year, month, day)) {
            throw new IllegalArgumentException(year + "-" + month + "-" + day);
        }
        return DateTimeUtils.dateValue(year, month, day);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long parseTimeNanos(String s, int start, int end) {
        int nanos;
        int second;
        int sEnd;
        int sStart;
        int mEnd;
        int mStart;
        int hEnd = s.indexOf(58, start);
        if (hEnd > 0) {
            mStart = hEnd + 1;
            mEnd = s.indexOf(58, mStart);
            if (mEnd >= mStart) {
                sStart = mEnd + 1;
                sEnd = s.indexOf(46, sStart);
            } else {
                mEnd = end;
                sEnd = -1;
                sStart = -1;
            }
        } else {
            int t = s.indexOf(46, start);
            if (t < 0) {
                hEnd = mStart = start + 2;
                mEnd = mStart + 2;
                int len = end - start;
                if (len == 6) {
                    sStart = mEnd;
                    sEnd = -1;
                } else {
                    if (len != 4) throw new IllegalArgumentException(s);
                    sEnd = -1;
                    sStart = -1;
                }
            } else if (t >= start + 6) {
                if (t - start != 6) {
                    throw new IllegalArgumentException(s);
                }
                hEnd = mStart = start + 2;
                mEnd = sStart = mStart + 2;
                sEnd = t;
            } else {
                hEnd = t;
                mStart = hEnd + 1;
                mEnd = s.indexOf(46, mStart);
                if (mEnd <= mStart) {
                    throw new IllegalArgumentException(s);
                }
                sStart = mEnd + 1;
                sEnd = s.indexOf(46, sStart);
            }
        }
        int hour = StringUtils.parseUInt31(s, start, hEnd);
        if (hour >= 24) {
            throw new IllegalArgumentException(s);
        }
        int minute = StringUtils.parseUInt31(s, mStart, mEnd);
        if (sStart > 0) {
            if (sEnd < 0) {
                second = StringUtils.parseUInt31(s, sStart, end);
                nanos = 0;
            } else {
                second = StringUtils.parseUInt31(s, sStart, sEnd);
                nanos = DateTimeUtils.parseNanos(s, sEnd + 1, end);
            }
        } else {
            nanos = 0;
            second = 0;
        }
        if (minute < 60 && second < 60) return (((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000000000L + (long)nanos;
        throw new IllegalArgumentException(s);
    }

    static int parseNanos(String s, int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException(s);
        }
        int nanos = 0;
        int mul = 100000000;
        do {
            char c;
            if ((c = s.charAt(start)) < '0' || c > '9') {
                throw new IllegalArgumentException(s);
            }
            nanos += mul * (c - 48);
            mul /= 10;
        } while (++start < end);
        return nanos;
    }

    public static Value parseTimestamp(String s, CastDataProvider provider, boolean withTimeZone) {
        long nanos;
        int timeStart;
        int dateEnd = s.indexOf(32);
        if (dateEnd < 0 && (dateEnd = s.indexOf(84)) < 0 && provider != null && provider.getMode().allowDB2TimestampFormat) {
            dateEnd = s.indexOf(45, s.indexOf(45, s.indexOf(45) + 1) + 1);
        }
        if (dateEnd < 0) {
            dateEnd = s.length();
            timeStart = -1;
        } else {
            timeStart = dateEnd + 1;
        }
        long dateValue = DateTimeUtils.parseDateValue(s, 0, dateEnd);
        TimeZoneProvider tz = null;
        if (timeStart < 0) {
            nanos = 0L;
        } else {
            int timeEnd;
            ++dateEnd;
            if (s.endsWith("Z")) {
                tz = TimeZoneProvider.UTC;
                timeEnd = s.length() - 1;
            } else {
                int timeZoneStart = s.indexOf(43, dateEnd);
                if (timeZoneStart < 0) {
                    timeZoneStart = s.indexOf(45, dateEnd);
                }
                if (timeZoneStart >= 0) {
                    int offsetEnd = s.indexOf(91, timeZoneStart + 1);
                    if (offsetEnd < 0) {
                        offsetEnd = s.length();
                    }
                    tz = TimeZoneProvider.ofId(s.substring(timeZoneStart, offsetEnd));
                    if (s.charAt(timeZoneStart - 1) == ' ') {
                        --timeZoneStart;
                    }
                    timeEnd = timeZoneStart;
                } else {
                    timeZoneStart = s.indexOf(32, dateEnd);
                    if (timeZoneStart > 0) {
                        tz = TimeZoneProvider.ofId(s.substring(timeZoneStart + 1));
                        timeEnd = timeZoneStart;
                    } else {
                        timeEnd = s.length();
                    }
                }
            }
            nanos = DateTimeUtils.parseTimeNanos(s, dateEnd, timeEnd);
        }
        if (withTimeZone) {
            if (tz == null) {
                tz = provider != null ? provider.currentTimeZone() : DateTimeUtils.getTimeZone();
            }
            int tzSeconds = tz != TimeZoneProvider.UTC ? tz.getTimeZoneOffsetUTC(tz.getEpochSecondsFromLocal(dateValue, nanos)) : 0;
            return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, nanos, tzSeconds);
        }
        if (tz != null) {
            long seconds = tz.getEpochSecondsFromLocal(dateValue, nanos);
            seconds += (long)(provider != null ? provider.currentTimeZone() : DateTimeUtils.getTimeZone()).getTimeZoneOffsetUTC(seconds);
            dateValue = DateTimeUtils.dateValueFromLocalSeconds(seconds);
            nanos = nanos % 1000000000L + DateTimeUtils.nanosFromLocalSeconds(seconds);
        }
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
    }

    public static ValueTimeTimeZone parseTimeWithTimeZone(String s, CastDataProvider provider) {
        int timeEnd;
        TimeZoneProvider tz;
        if (s.endsWith("Z")) {
            tz = TimeZoneProvider.UTC;
            timeEnd = s.length() - 1;
        } else {
            int timeZoneStart = s.indexOf(43, 1);
            if (timeZoneStart < 0) {
                timeZoneStart = s.indexOf(45, 1);
            }
            if (timeZoneStart >= 0) {
                tz = TimeZoneProvider.ofId(s.substring(timeZoneStart));
                if (s.charAt(timeZoneStart - 1) == ' ') {
                    --timeZoneStart;
                }
                timeEnd = timeZoneStart;
            } else {
                timeZoneStart = s.indexOf(32, 1);
                if (timeZoneStart > 0) {
                    tz = TimeZoneProvider.ofId(s.substring(timeZoneStart + 1));
                    timeEnd = timeZoneStart;
                } else {
                    throw DbException.get(22007, "TIME WITH TIME ZONE", s);
                }
            }
            if (!tz.hasFixedOffset()) {
                throw DbException.get(22007, "TIME WITH TIME ZONE", s);
            }
        }
        return ValueTimeTimeZone.fromNanos(DateTimeUtils.parseTimeNanos(s, 0, timeEnd), tz.getTimeZoneOffsetUTC(0L));
    }

    public static long getEpochSeconds(long dateValue, long timeNanos, int offsetSeconds) {
        return DateTimeUtils.absoluteDayFromDateValue(dateValue) * 86400L + timeNanos / 1000000000L - (long)offsetSeconds;
    }

    public static long[] dateAndTimeFromValue(Value value, CastDataProvider provider) {
        long dateValue = 1008673L;
        long timeNanos = 0L;
        if (value instanceof ValueTimestamp) {
            ValueTimestamp v = (ValueTimestamp)value;
            dateValue = v.getDateValue();
            timeNanos = v.getTimeNanos();
        } else if (value instanceof ValueDate) {
            dateValue = ((ValueDate)value).getDateValue();
        } else if (value instanceof ValueTime) {
            timeNanos = ((ValueTime)value).getNanos();
        } else if (value instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone v = (ValueTimestampTimeZone)value;
            dateValue = v.getDateValue();
            timeNanos = v.getTimeNanos();
        } else if (value instanceof ValueTimeTimeZone) {
            timeNanos = ((ValueTimeTimeZone)value).getNanos();
        } else {
            ValueTimestamp v = (ValueTimestamp)value.convertTo(TypeInfo.TYPE_TIMESTAMP, provider);
            dateValue = v.getDateValue();
            timeNanos = v.getTimeNanos();
        }
        return new long[]{dateValue, timeNanos};
    }

    public static Value dateTimeToValue(Value original, long dateValue, long timeNanos) {
        switch (original.getValueType()) {
            case 17: {
                return ValueDate.fromDateValue(dateValue);
            }
            case 18: {
                return ValueTime.fromNanos(timeNanos);
            }
            case 19: {
                return ValueTimeTimeZone.fromNanos(timeNanos, ((ValueTimeTimeZone)original).getTimeZoneOffsetSeconds());
            }
            default: {
                return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
            }
            case 21: 
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, ((ValueTimestampTimeZone)original).getTimeZoneOffsetSeconds());
    }

    public static int getDayOfWeek(long dateValue, int firstDayOfWeek) {
        return DateTimeUtils.getDayOfWeekFromAbsolute(DateTimeUtils.absoluteDayFromDateValue(dateValue), firstDayOfWeek);
    }

    public static int getDayOfWeekFromAbsolute(long absoluteValue, int firstDayOfWeek) {
        return absoluteValue >= 0L ? (int)((absoluteValue - (long)firstDayOfWeek + 11L) % 7L) + 1 : (int)((absoluteValue - (long)firstDayOfWeek - 2L) % 7L) + 7;
    }

    public static int getDayOfYear(long dateValue) {
        int m = DateTimeUtils.monthFromDateValue(dateValue);
        int a = (367 * m - 362) / 12 + DateTimeUtils.dayFromDateValue(dateValue);
        if (m > 2) {
            --a;
            long y = DateTimeUtils.yearFromDateValue(dateValue);
            if ((y & 3L) != 0L || y % 100L == 0L && y % 400L != 0L) {
                --a;
            }
        }
        return a;
    }

    public static int getIsoDayOfWeek(long dateValue) {
        return DateTimeUtils.getDayOfWeek(dateValue, 1);
    }

    public static int getIsoWeekOfYear(long dateValue) {
        return DateTimeUtils.getWeekOfYear(dateValue, 1, 4);
    }

    public static int getIsoWeekYear(long dateValue) {
        return DateTimeUtils.getWeekYear(dateValue, 1, 4);
    }

    public static int getSundayDayOfWeek(long dateValue) {
        return DateTimeUtils.getDayOfWeek(dateValue, 0);
    }

    public static int getWeekOfYear(long dateValue, int firstDayOfWeek, int minimalDaysInFirstWeek) {
        int year;
        long base;
        long abs = DateTimeUtils.absoluteDayFromDateValue(dateValue);
        if (abs - (base = DateTimeUtils.getWeekYearAbsoluteStart(year = DateTimeUtils.yearFromDateValue(dateValue), firstDayOfWeek, minimalDaysInFirstWeek)) < 0L) {
            base = DateTimeUtils.getWeekYearAbsoluteStart(year - 1, firstDayOfWeek, minimalDaysInFirstWeek);
        } else if (DateTimeUtils.monthFromDateValue(dateValue) == 12 && 24 + minimalDaysInFirstWeek < DateTimeUtils.dayFromDateValue(dateValue) && abs >= DateTimeUtils.getWeekYearAbsoluteStart(year + 1, firstDayOfWeek, minimalDaysInFirstWeek)) {
            return 1;
        }
        return (int)((abs - base) / 7L) + 1;
    }

    public static long getWeekYearAbsoluteStart(int weekYear, int firstDayOfWeek, int minimalDaysInFirstWeek) {
        long first = DateTimeUtils.absoluteDayFromYear(weekYear);
        int daysInFirstWeek = 8 - DateTimeUtils.getDayOfWeekFromAbsolute(first, firstDayOfWeek);
        long base = first + (long)daysInFirstWeek;
        if (daysInFirstWeek >= minimalDaysInFirstWeek) {
            base -= 7L;
        }
        return base;
    }

    public static int getWeekYear(long dateValue, int firstDayOfWeek, int minimalDaysInFirstWeek) {
        int year;
        long base;
        long abs = DateTimeUtils.absoluteDayFromDateValue(dateValue);
        if (abs < (base = DateTimeUtils.getWeekYearAbsoluteStart(year = DateTimeUtils.yearFromDateValue(dateValue), firstDayOfWeek, minimalDaysInFirstWeek))) {
            return year - 1;
        }
        if (DateTimeUtils.monthFromDateValue(dateValue) == 12 && 24 + minimalDaysInFirstWeek < DateTimeUtils.dayFromDateValue(dateValue) && abs >= DateTimeUtils.getWeekYearAbsoluteStart(year + 1, firstDayOfWeek, minimalDaysInFirstWeek)) {
            return year + 1;
        }
        return year;
    }

    public static int getDaysInMonth(int year, int month) {
        if (month != 2) {
            return NORMAL_DAYS_PER_MONTH[month];
        }
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0) ? 29 : 28;
    }

    public static boolean isValidDate(int year, int month, int day) {
        return month >= 1 && month <= 12 && day >= 1 && day <= DateTimeUtils.getDaysInMonth(year, month);
    }

    public static int yearFromDateValue(long x) {
        return (int)(x >>> 9);
    }

    public static int monthFromDateValue(long x) {
        return (int)(x >>> 5) & 0xF;
    }

    public static int dayFromDateValue(long x) {
        return (int)(x & 0x1FL);
    }

    public static long dateValue(long year, int month, int day) {
        return year << 9 | (long)(month << 5) | (long)day;
    }

    public static long dateValueFromDenormalizedDate(long year, long month, int day) {
        long mm1 = month - 1L;
        long yd = mm1 / 12L;
        if (mm1 < 0L && yd * 12L != mm1) {
            --yd;
        }
        int y = (int)(year + yd);
        int m = (int)(month - yd * 12L);
        if (day < 1) {
            day = 1;
        } else {
            int max = DateTimeUtils.getDaysInMonth(y, m);
            if (day > max) {
                day = max;
            }
        }
        return DateTimeUtils.dateValue(y, m, day);
    }

    public static long dateValueFromLocalSeconds(long localSeconds) {
        long absoluteDay = localSeconds / 86400L;
        if (localSeconds < 0L && absoluteDay * 86400L != localSeconds) {
            --absoluteDay;
        }
        return DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay);
    }

    public static long nanosFromLocalSeconds(long localSeconds) {
        if ((localSeconds %= 86400L) < 0L) {
            localSeconds += 86400L;
        }
        return localSeconds * 1000000000L;
    }

    public static long normalizeNanosOfDay(long nanos) {
        if ((nanos %= 86400000000000L) < 0L) {
            nanos += 86400000000000L;
        }
        return nanos;
    }

    public static long absoluteDayFromYear(long year) {
        long a = 365L * year - 719528L;
        a = year >= 0L ? (a += (year + 3L) / 4L - (year + 99L) / 100L + (year + 399L) / 400L) : (a -= year / -4L - year / -100L + year / -400L);
        return a;
    }

    public static long absoluteDayFromDateValue(long dateValue) {
        return DateTimeUtils.absoluteDay(DateTimeUtils.yearFromDateValue(dateValue), DateTimeUtils.monthFromDateValue(dateValue), DateTimeUtils.dayFromDateValue(dateValue));
    }

    static long absoluteDay(long y, int m, int d) {
        long a = DateTimeUtils.absoluteDayFromYear(y) + (long)((367 * m - 362) / 12) + (long)d - 1L;
        if (m > 2) {
            --a;
            if ((y & 3L) != 0L || y % 100L == 0L && y % 400L != 0L) {
                --a;
            }
        }
        return a;
    }

    public static long dateValueFromAbsoluteDay(long absoluteDay) {
        long y;
        int day;
        long d = absoluteDay + 719468L;
        long a = 0L;
        if (d < 0L) {
            a = (d + 1L) / 146097L - 1L;
            d -= a * 146097L;
            a *= 400L;
        }
        if ((day = (int)(d - (365L * (y = (400L * d + 591L) / 146097L) + y / 4L - y / 100L + y / 400L))) < 0) {
            day = (int)(d - (365L * --y + y / 4L - y / 100L + y / 400L));
        }
        y += a;
        int m = (day * 5 + 2) / 153;
        day -= (m * 306 + 5) / 10 - 1;
        if (m >= 10) {
            ++y;
            m -= 12;
        }
        return DateTimeUtils.dateValue(y, m + 3, day);
    }

    public static long incrementDateValue(long dateValue) {
        int month;
        int day = DateTimeUtils.dayFromDateValue(dateValue);
        if (day < 28) {
            return dateValue + 1L;
        }
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        if (day < DateTimeUtils.getDaysInMonth(year, month = DateTimeUtils.monthFromDateValue(dateValue))) {
            return dateValue + 1L;
        }
        if (month < 12) {
            ++month;
        } else {
            month = 1;
            ++year;
        }
        return DateTimeUtils.dateValue(year, month, 1);
    }

    public static long decrementDateValue(long dateValue) {
        if (DateTimeUtils.dayFromDateValue(dateValue) > 1) {
            return dateValue - 1L;
        }
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        int month = DateTimeUtils.monthFromDateValue(dateValue);
        if (month > 1) {
            --month;
        } else {
            month = 12;
            --year;
        }
        return DateTimeUtils.dateValue(year, month, DateTimeUtils.getDaysInMonth(year, month));
    }

    public static StringBuilder appendDate(StringBuilder builder, long dateValue) {
        int y = DateTimeUtils.yearFromDateValue(dateValue);
        if (y < 1000 && y > -1000) {
            if (y < 0) {
                builder.append('-');
                y = -y;
            }
            StringUtils.appendZeroPadded(builder, 4, y);
        } else {
            builder.append(y);
        }
        StringUtils.appendTwoDigits(builder.append('-'), DateTimeUtils.monthFromDateValue(dateValue)).append('-');
        return StringUtils.appendTwoDigits(builder, DateTimeUtils.dayFromDateValue(dateValue));
    }

    public static StringBuilder appendTime(StringBuilder builder, long nanos) {
        if (nanos < 0L) {
            builder.append('-');
            nanos = -nanos;
        }
        long s = -nanos / -1000000000L;
        nanos -= s * 1000000000L;
        int m = (int)(s / 60L);
        s -= (long)(m * 60);
        int h = m / 60;
        StringUtils.appendTwoDigits(builder, h).append(':');
        StringUtils.appendTwoDigits(builder, m -= h * 60).append(':');
        StringUtils.appendTwoDigits(builder, (int)s);
        return DateTimeUtils.appendNanos(builder, (int)nanos);
    }

    static StringBuilder appendNanos(StringBuilder builder, int nanos) {
        if (nanos > 0) {
            builder.append('.');
            int i = 1;
            while (nanos < FRACTIONAL_SECONDS_TABLE[i]) {
                builder.append('0');
                ++i;
            }
            if (nanos % 1000 == 0 && (nanos /= 1000) % 1000 == 0) {
                nanos /= 1000;
            }
            if (nanos % 10 == 0 && (nanos /= 10) % 10 == 0) {
                nanos /= 10;
            }
            builder.append(nanos);
        }
        return builder;
    }

    public static StringBuilder appendTimeZone(StringBuilder builder, int tz) {
        if (tz < 0) {
            builder.append('-');
            tz = -tz;
        } else {
            builder.append('+');
        }
        int rem = tz / 3600;
        StringUtils.appendTwoDigits(builder, rem);
        if ((tz -= rem * 3600) != 0) {
            rem = tz / 60;
            StringUtils.appendTwoDigits(builder.append(':'), rem);
            if ((tz -= rem * 60) != 0) {
                StringUtils.appendTwoDigits(builder.append(':'), tz);
            }
        }
        return builder;
    }

    public static String timeZoneNameFromOffsetSeconds(int offsetSeconds) {
        if (offsetSeconds == 0) {
            return "UTC";
        }
        StringBuilder b = new StringBuilder(12);
        b.append("GMT");
        if (offsetSeconds < 0) {
            b.append('-');
            offsetSeconds = -offsetSeconds;
        } else {
            b.append('+');
        }
        StringUtils.appendTwoDigits(b, offsetSeconds / 3600).append(':');
        StringUtils.appendTwoDigits(b, (offsetSeconds %= 3600) / 60);
        if ((offsetSeconds %= 60) != 0) {
            b.append(':');
            StringUtils.appendTwoDigits(b, offsetSeconds);
        }
        return b.toString();
    }

    public static long convertScale(long nanosOfDay, int scale, long range) {
        long r;
        if (scale >= 9) {
            return nanosOfDay;
        }
        int m = FRACTIONAL_SECONDS_TABLE[scale];
        long mod = nanosOfDay % (long)m;
        if (mod >= (long)(m >>> 1)) {
            nanosOfDay += (long)m;
        }
        if ((r = nanosOfDay - mod) >= range) {
            r = range - (long)m;
        }
        return r;
    }

    public static ValueTimestampTimeZone timestampTimeZoneAtOffset(long dateValue, long timeNanos, int oldOffset, int newOffset) {
        if ((timeNanos += (long)(newOffset - oldOffset) * 1000000000L) < 0L) {
            dateValue = DateTimeUtils.decrementDateValue(dateValue);
            if ((timeNanos += 86400000000000L) < 0L) {
                timeNanos += 86400000000000L;
                dateValue = DateTimeUtils.decrementDateValue(dateValue);
            }
        } else if (timeNanos >= 86400000000000L) {
            dateValue = DateTimeUtils.incrementDateValue(dateValue);
            if ((timeNanos -= 86400000000000L) >= 86400000000000L) {
                timeNanos -= 86400000000000L;
                dateValue = DateTimeUtils.incrementDateValue(dateValue);
            }
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, newOffset);
    }
}

