/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.UUID;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Bits {
    public static int compareNotNull(char[] data1, char[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            char b = data1[i];
            char b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    public static int compareNotNullSigned(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            byte b = data1[i];
            byte b2 = data2[i];
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    public static int compareNotNullUnsigned(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        for (int i = 0; i < len; ++i) {
            int b = data1[i] & 0xFF;
            int b2 = data2[i] & 0xFF;
            if (b == b2) continue;
            return b > b2 ? 1 : -1;
        }
        return Integer.signum(data1.length - data2.length);
    }

    public static int readInt(byte[] buff, int pos) {
        return (buff[pos++] << 24) + ((buff[pos++] & 0xFF) << 16) + ((buff[pos++] & 0xFF) << 8) + (buff[pos] & 0xFF);
    }

    public static int readIntLE(byte[] buff, int pos) {
        return (buff[pos++] & 0xFF) + ((buff[pos++] & 0xFF) << 8) + ((buff[pos++] & 0xFF) << 16) + (buff[pos] << 24);
    }

    public static long readLong(byte[] buff, int pos) {
        return ((long)Bits.readInt(buff, pos) << 32) + ((long)Bits.readInt(buff, pos + 4) & 0xFFFFFFFFL);
    }

    public static long readLongLE(byte[] buff, int pos) {
        return ((long)Bits.readIntLE(buff, pos) & 0xFFFFFFFFL) + ((long)Bits.readIntLE(buff, pos + 4) << 32);
    }

    public static double readDouble(byte[] buff, int pos) {
        return Double.longBitsToDouble(Bits.readLong(buff, pos));
    }

    public static double readDoubleLE(byte[] buff, int pos) {
        return Double.longBitsToDouble(Bits.readLongLE(buff, pos));
    }

    public static byte[] uuidToBytes(long msb, long lsb) {
        byte[] buff = new byte[16];
        for (int i = 0; i < 8; ++i) {
            buff[i] = (byte)(msb >> 8 * (7 - i) & 0xFFL);
            buff[8 + i] = (byte)(lsb >> 8 * (7 - i) & 0xFFL);
        }
        return buff;
    }

    public static byte[] uuidToBytes(UUID uuid) {
        return Bits.uuidToBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static void writeInt(byte[] buff, int pos, int x) {
        buff[pos++] = (byte)(x >> 24);
        buff[pos++] = (byte)(x >> 16);
        buff[pos++] = (byte)(x >> 8);
        buff[pos] = (byte)x;
    }

    public static void writeIntLE(byte[] buff, int pos, int x) {
        buff[pos++] = (byte)x;
        buff[pos++] = (byte)(x >> 8);
        buff[pos++] = (byte)(x >> 16);
        buff[pos] = (byte)(x >> 24);
    }

    public static void writeLong(byte[] buff, int pos, long x) {
        Bits.writeInt(buff, pos, (int)(x >> 32));
        Bits.writeInt(buff, pos + 4, (int)x);
    }

    public static void writeLongLE(byte[] buff, int pos, long x) {
        Bits.writeIntLE(buff, pos, (int)x);
        Bits.writeIntLE(buff, pos + 4, (int)(x >> 32));
    }

    public static void writeDouble(byte[] buff, int pos, double x) {
        Bits.writeLong(buff, pos, Double.doubleToRawLongBits(x));
    }

    public static void writeDoubleLE(byte[] buff, int pos, double x) {
        Bits.writeLongLE(buff, pos, Double.doubleToRawLongBits(x));
    }

    private Bits() {
    }
}

