/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import org.h2.message.DbException;
import org.h2.tools.SimpleRowSource;
import org.h2.util.Bits;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.SimpleColumnInfo;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueToObjectConverter;

public class SimpleResultSet
implements ResultSet,
ResultSetMetaData {
    private ArrayList<Object[]> rows;
    private Object[] currentRow;
    private int rowId = -1;
    private boolean wasNull;
    private SimpleRowSource source;
    private ArrayList<SimpleColumnInfo> columns = Utils.newSmallArrayList();
    private boolean autoClose = true;

    public SimpleResultSet() {
        this.rows = Utils.newSmallArrayList();
    }

    public SimpleResultSet(SimpleRowSource source) {
        this.source = source;
    }

    public void addColumn(String name, int sqlType, int precision, int scale) {
        int valueType = DataType.convertSQLTypeToValueType(sqlType);
        this.addColumn(name, sqlType, Value.getTypeName(valueType), precision, scale);
    }

    public void addColumn(String name, int sqlType, String sqlTypeName, int precision, int scale) {
        if (this.rows != null && !this.rows.isEmpty()) {
            throw new IllegalStateException("Cannot add a column after adding rows");
        }
        if (name == null) {
            name = "C" + (this.columns.size() + 1);
        }
        this.columns.add(new SimpleColumnInfo(name, sqlType, sqlTypeName, precision, scale));
    }

    public void addRow(Object ... row) {
        if (this.rows == null) {
            throw new IllegalStateException("Cannot add a row when using RowSource");
        }
        this.rows.add(row);
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getRow() {
        return this.currentRow == null ? 0 : this.rowId + 1;
    }

    @Override
    public int getType() {
        if (this.autoClose) {
            return 1003;
        }
        return 1004;
    }

    @Override
    public void close() {
        this.currentRow = null;
        this.rows = null;
        this.columns = null;
        this.rowId = -1;
        if (this.source != null) {
            this.source.close();
            this.source = null;
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.source != null) {
            ++this.rowId;
            this.currentRow = this.source.readRow();
            if (this.currentRow != null) {
                return true;
            }
        } else if (this.rows != null && this.rowId < this.rows.size()) {
            ++this.rowId;
            if (this.rowId < this.rows.size()) {
                this.currentRow = this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        if (this.autoClose) {
            this.close();
        }
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.autoClose) {
            throw DbException.getJdbcSQLException(90128);
        }
        this.rowId = -1;
        if (this.source != null) {
            this.source.reset();
        }
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        if (columnLabel != null && this.columns != null) {
            int size = this.columns.size();
            for (int i = 0; i < size; ++i) {
                if (!columnLabel.equalsIgnoreCase(this.getColumn((int)i).name)) continue;
                return i + 1;
            }
        }
        throw DbException.getJdbcSQLException(42122, columnLabel);
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return this;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public Statement getStatement() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        Object[] o = (Object[])this.get(columnIndex);
        return o == null ? null : new SimpleArray(o);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o != null && !(o instanceof BigDecimal)) {
            o = new BigDecimal(o.toString());
        }
        return (BigDecimal)o;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return SimpleResultSet.asInputStream(this.get(columnIndex));
    }

    private static InputStream asInputStream(Object o) throws SQLException {
        if (o == null) {
            return null;
        }
        if (o instanceof Blob) {
            return ((Blob)o).getBinaryStream();
        }
        return (InputStream)o;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.get(columnIndex);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            if (n instanceof Double || n instanceof Float) {
                return n.doubleValue() != 0.0;
            }
            if (n instanceof BigDecimal) {
                return ((BigDecimal)n).signum() != 0;
            }
            if (n instanceof BigInteger) {
                return ((BigInteger)n).signum() != 0;
            }
            return n.longValue() != 0L;
        }
        return Utils.parseBoolean(o.toString(), false, true);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o != null && !(o instanceof Number)) {
            o = Byte.decode(o.toString());
        }
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o == null || o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof UUID) {
            return Bits.uuidToBytes((UUID)o);
        }
        return JdbcUtils.serialize(o, null);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return SimpleResultSet.asReader(this.get(columnIndex));
    }

    private static Reader asReader(Object o) throws SQLException {
        if (o == null) {
            return null;
        }
        if (o instanceof Clob) {
            return ((Clob)o).getCharacterStream();
        }
        return (Reader)o;
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.get(columnIndex);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.get(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o != null && !(o instanceof Number)) {
            return Double.parseDouble(o.toString());
        }
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o != null && !(o instanceof Number)) {
            return Float.parseFloat(o.toString());
        }
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o != null && !(o instanceof Number)) {
            o = Integer.decode(o.toString());
        }
        return o == null ? 0 : ((Number)o).intValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o != null && !(o instanceof Number)) {
            o = Long.decode(o.toString());
        }
        return o == null ? 0L : ((Number)o).longValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.get(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (this.get(columnIndex) == null) {
            return null;
        }
        if (type == BigDecimal.class) {
            return (T)this.getBigDecimal(columnIndex);
        }
        if (type == BigInteger.class) {
            return (T)this.getBigDecimal(columnIndex).toBigInteger();
        }
        if (type == String.class) {
            return (T)this.getString(columnIndex);
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(this.getBoolean(columnIndex));
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(this.getByte(columnIndex));
        }
        if (type == Short.class) {
            return (T)Short.valueOf(this.getShort(columnIndex));
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(this.getInt(columnIndex));
        }
        if (type == Long.class) {
            return (T)Long.valueOf(this.getLong(columnIndex));
        }
        if (type == Float.class) {
            return (T)Float.valueOf(this.getFloat(columnIndex));
        }
        if (type == Double.class) {
            return (T)Double.valueOf(this.getDouble(columnIndex));
        }
        if (type == Date.class) {
            return (T)this.getDate(columnIndex);
        }
        if (type == Time.class) {
            return (T)this.getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return (T)this.getTimestamp(columnIndex);
        }
        if (type == UUID.class) {
            return (T)this.getObject(columnIndex);
        }
        if (type == byte[].class) {
            return (T)this.getBytes(columnIndex);
        }
        if (type == Array.class) {
            return (T)this.getArray(columnIndex);
        }
        if (type == Blob.class) {
            return (T)this.getBlob(columnIndex);
        }
        if (type == Clob.class) {
            return (T)this.getClob(columnIndex);
        }
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnName), type);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o != null && !(o instanceof Number)) {
            o = Short.decode(o.toString());
        }
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object o = this.get(columnIndex);
        if (o == null) {
            return null;
        }
        switch (this.columns.get((int)(columnIndex - 1)).type) {
            case 2005: {
                Clob c = (Clob)o;
                return c.getSubString(1L, MathUtils.convertLongToInt(c.length()));
            }
        }
        return o.toString();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.get(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.get(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.update(columnIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.update(columnLabel, (Object)Float.valueOf(x));
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.update(columnIndex, null);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.update(columnLabel, null);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.update(columnIndex, x);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.update(columnLabel, x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.update(columnIndex, x);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        this.update(columnLabel, x);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.update(columnIndex, (Object)x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.update(columnLabel, (Object)x);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getColumnDisplaySize(int columnIndex) {
        return 15;
    }

    @Override
    public int getColumnType(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).type;
    }

    @Override
    public int getPrecision(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).precision;
    }

    @Override
    public int getScale(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).scale;
    }

    @Override
    public int isNullable(int columnIndex) {
        return 2;
    }

    @Override
    public boolean isAutoIncrement(int columnIndex) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int columnIndex) {
        return true;
    }

    @Override
    public boolean isCurrency(int columnIndex) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int columnIndex) {
        return false;
    }

    @Override
    public boolean isReadOnly(int columnIndex) {
        return true;
    }

    @Override
    public boolean isSearchable(int columnIndex) {
        return true;
    }

    @Override
    public boolean isSigned(int columnIndex) {
        return true;
    }

    @Override
    public boolean isWritable(int columnIndex) {
        return false;
    }

    @Override
    public String getCatalogName(int columnIndex) {
        return "";
    }

    @Override
    public String getColumnClassName(int columnIndex) throws SQLException {
        int type = DataType.getValueTypeFromResultSet(this, columnIndex);
        return ValueToObjectConverter.getDefaultClass(type, true).getName();
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).name;
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        return this.getColumnLabel(columnIndex);
    }

    @Override
    public String getColumnTypeName(int columnIndex) throws SQLException {
        return this.getColumn((int)(columnIndex - 1)).typeName;
    }

    @Override
    public String getSchemaName(int columnIndex) {
        return "";
    }

    @Override
    public String getTableName(int columnIndex) {
        return "";
    }

    @Override
    public void afterLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean first() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean last() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean previous() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public boolean relative(int offset) throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw SimpleResultSet.getUnsupportedException();
    }

    private void update(int columnIndex, Object obj) throws SQLException {
        this.checkClosed();
        this.checkColumnIndex(columnIndex);
        this.currentRow[columnIndex - 1] = obj;
    }

    private void update(String columnLabel, Object obj) throws SQLException {
        this.currentRow[this.findColumn((String)columnLabel) - 1] = obj;
    }

    static SQLException getUnsupportedException() {
        return DbException.getJdbcSQLException(50100);
    }

    private void checkClosed() throws SQLException {
        if (this.columns == null) {
            throw DbException.getJdbcSQLException(90007);
        }
    }

    private void checkColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columns.size()) {
            throw DbException.getInvalidValueException("columnIndex", columnIndex).getSQLException();
        }
    }

    private Object get(int columnIndex) throws SQLException {
        if (this.currentRow == null) {
            throw DbException.getJdbcSQLException(2000);
        }
        this.checkColumnIndex(columnIndex);
        Object o = --columnIndex < this.currentRow.length ? this.currentRow[columnIndex] : null;
        this.wasNull = o == null;
        return o;
    }

    private SimpleColumnInfo getColumn(int i) throws SQLException {
        this.checkColumnIndex(i + 1);
        return this.columns.get(i);
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.rows == null && this.source == null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    public static class SimpleArray
    implements Array {
        private final Object[] value;

        SimpleArray(Object[] value) {
            this.value = value;
        }

        @Override
        public Object getArray() {
            return this.value;
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public Object getArray(long index, int count) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public int getBaseType() {
            return 0;
        }

        @Override
        public String getBaseTypeName() {
            return "NULL";
        }

        @Override
        public ResultSet getResultSet() throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public ResultSet getResultSet(long index, int count) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
            throw SimpleResultSet.getUnsupportedException();
        }

        @Override
        public void free() {
        }
    }
}

