/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.dml.Help;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintDomain;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.DbObject;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.index.MetaIndex;
import org.h2.message.DbException;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.db.Store;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.schema.UserDefinedFunction;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueToObjectConverter2;

public final class InformationSchemaTableLegacy
extends MetaTable {
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int FUNCTION_COLUMNS = 20;
    private static final int CONSTRAINTS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int DOMAIN_CONSTRAINTS = 31;
    private static final int KEY_COLUMN_USAGE = 32;
    private static final int REFERENTIAL_CONSTRAINTS = 33;
    private static final int CHECK_CONSTRAINTS = 34;
    private static final int CONSTRAINT_COLUMN_USAGE = 35;
    public static final int META_TABLE_TYPE_COUNT = 36;

    public InformationSchemaTableLegacy(Schema schema, int id, int type) {
        super(schema, id, type);
        Column[] cols;
        String indexColumnName = null;
        switch (type) {
            case 0: {
                this.setMetaTableName("TABLES");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("TABLE_TYPE"), this.column("STORAGE_TYPE"), this.column("SQL"), this.column("REMARKS"), this.column("LAST_MODIFICATION", TypeInfo.TYPE_BIGINT), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("TABLE_CLASS"), this.column("ROW_COUNT_ESTIMATE", TypeInfo.TYPE_BIGINT)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setMetaTableName("COLUMNS");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("COLUMN_DEFAULT"), this.column("IS_NULLABLE"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_MAXIMUM_LENGTH", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_OCTET_LENGTH", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("DATETIME_PRECISION", TypeInfo.TYPE_INTEGER), this.column("INTERVAL_TYPE"), this.column("INTERVAL_PRECISION", TypeInfo.TYPE_INTEGER), this.column("CHARACTER_SET_NAME"), this.column("COLLATION_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("IS_GENERATED"), this.column("GENERATION_EXPRESSION"), this.column("TYPE_NAME"), this.column("NULLABLE", TypeInfo.TYPE_INTEGER), this.column("IS_COMPUTED", TypeInfo.TYPE_BOOLEAN), this.column("SELECTIVITY", TypeInfo.TYPE_INTEGER), this.column("SEQUENCE_NAME"), this.column("REMARKS"), this.column("SOURCE_DATA_TYPE", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_TYPE"), this.column("COLUMN_ON_UPDATE"), this.column("IS_VISIBLE"), this.column("CHECK_CONSTRAINT")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("INDEXES");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("NON_UNIQUE", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_NAME"), this.column("CARDINALITY", TypeInfo.TYPE_INTEGER), this.column("PRIMARY_KEY", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_TYPE_NAME"), this.column("IS_GENERATED", TypeInfo.TYPE_BOOLEAN), this.column("INDEX_TYPE", TypeInfo.TYPE_SMALLINT), this.column("ASC_OR_DESC"), this.column("PAGES", TypeInfo.TYPE_INTEGER), this.column("FILTER_CONDITION"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SORT_TYPE", TypeInfo.TYPE_INTEGER), this.column("CONSTRAINT_NAME"), this.column("INDEX_CLASS")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setMetaTableName("TABLE_TYPES");
                cols = new Column[]{this.column("TYPE")};
                break;
            }
            case 4: {
                this.setMetaTableName("TYPE_INFO");
                cols = new Column[]{this.column("TYPE_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("PREFIX"), this.column("SUFFIX"), this.column("PARAMS"), this.column("AUTO_INCREMENT", TypeInfo.TYPE_BOOLEAN), this.column("MINIMUM_SCALE", TypeInfo.TYPE_SMALLINT), this.column("MAXIMUM_SCALE", TypeInfo.TYPE_SMALLINT), this.column("RADIX", TypeInfo.TYPE_INTEGER), this.column("POS", TypeInfo.TYPE_INTEGER), this.column("CASE_SENSITIVE", TypeInfo.TYPE_BOOLEAN), this.column("NULLABLE", TypeInfo.TYPE_SMALLINT), this.column("SEARCHABLE", TypeInfo.TYPE_SMALLINT)};
                break;
            }
            case 5: {
                this.setMetaTableName("CATALOGS");
                cols = new Column[]{this.column("CATALOG_NAME")};
                break;
            }
            case 6: {
                this.setMetaTableName("SETTINGS");
                cols = new Column[]{this.column("NAME"), this.column("VALUE")};
                break;
            }
            case 7: {
                this.setMetaTableName("HELP");
                cols = new Column[]{this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SECTION"), this.column("TOPIC"), this.column("SYNTAX"), this.column("TEXT")};
                break;
            }
            case 8: {
                this.setMetaTableName("SEQUENCES");
                cols = new Column[]{this.column("SEQUENCE_CATALOG"), this.column("SEQUENCE_SCHEMA"), this.column("SEQUENCE_NAME"), this.column("DATA_TYPE"), this.column("NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_PRECISION_RADIX", TypeInfo.TYPE_INTEGER), this.column("NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("START_VALUE", TypeInfo.TYPE_BIGINT), this.column("MINIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("MAXIMUM_VALUE", TypeInfo.TYPE_BIGINT), this.column("INCREMENT", TypeInfo.TYPE_BIGINT), this.column("CYCLE_OPTION"), this.column("DECLARED_DATA_TYPE"), this.column("DECLARED_NUMERIC_PRECISION", TypeInfo.TYPE_INTEGER), this.column("DECLARED_NUMERIC_SCALE", TypeInfo.TYPE_INTEGER), this.column("CURRENT_VALUE", TypeInfo.TYPE_BIGINT), this.column("IS_GENERATED", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("CACHE", TypeInfo.TYPE_BIGINT), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("MIN_VALUE", TypeInfo.TYPE_BIGINT), this.column("MAX_VALUE", TypeInfo.TYPE_BIGINT), this.column("IS_CYCLE", TypeInfo.TYPE_BOOLEAN)};
                break;
            }
            case 9: {
                this.setMetaTableName("USERS");
                cols = new Column[]{this.column("NAME"), this.column("ADMIN"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 10: {
                this.setMetaTableName("ROLES");
                cols = new Column[]{this.column("NAME"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 11: {
                this.setMetaTableName("RIGHTS");
                cols = new Column[]{this.column("GRANTEE"), this.column("GRANTEETYPE"), this.column("GRANTEDROLE"), this.column("RIGHTS"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setMetaTableName("FUNCTION_ALIASES");
                cols = new Column[]{this.column("ALIAS_CATALOG"), this.column("ALIAS_SCHEMA"), this.column("ALIAS_NAME"), this.column("JAVA_CLASS"), this.column("JAVA_METHOD"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("COLUMN_COUNT", TypeInfo.TYPE_INTEGER), this.column("RETURNS_RESULT", TypeInfo.TYPE_SMALLINT), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("SOURCE")};
                break;
            }
            case 20: {
                this.setMetaTableName("FUNCTION_COLUMNS");
                cols = new Column[]{this.column("ALIAS_CATALOG"), this.column("ALIAS_SCHEMA"), this.column("ALIAS_NAME"), this.column("JAVA_CLASS"), this.column("JAVA_METHOD"), this.column("COLUMN_COUNT", TypeInfo.TYPE_INTEGER), this.column("POS", TypeInfo.TYPE_INTEGER), this.column("COLUMN_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("SCALE", TypeInfo.TYPE_SMALLINT), this.column("RADIX", TypeInfo.TYPE_SMALLINT), this.column("NULLABLE", TypeInfo.TYPE_SMALLINT), this.column("COLUMN_TYPE", TypeInfo.TYPE_SMALLINT), this.column("REMARKS"), this.column("COLUMN_DEFAULT")};
                break;
            }
            case 13: {
                this.setMetaTableName("SCHEMATA");
                cols = new Column[]{this.column("CATALOG_NAME"), this.column("SCHEMA_NAME"), this.column("SCHEMA_OWNER"), this.column("DEFAULT_CHARACTER_SET_NAME"), this.column("DEFAULT_COLLATION_NAME"), this.column("IS_DEFAULT", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 14: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                cols = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                cols = new Column[]{this.column("GRANTOR"), this.column("GRANTEE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("PRIVILEGE_TYPE"), this.column("IS_GRANTABLE")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("COLLATIONS");
                cols = new Column[]{this.column("NAME"), this.column("KEY")};
                break;
            }
            case 17: {
                this.setMetaTableName("VIEWS");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("VIEW_DEFINITION"), this.column("CHECK_OPTION"), this.column("IS_UPDATABLE"), this.column("STATUS"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("IN_DOUBT");
                cols = new Column[]{this.column("TRANSACTION"), this.column("STATE")};
                break;
            }
            case 19: {
                this.setMetaTableName("CROSS_REFERENCES");
                cols = new Column[]{this.column("PKTABLE_CATALOG"), this.column("PKTABLE_SCHEMA"), this.column("PKTABLE_NAME"), this.column("PKCOLUMN_NAME"), this.column("FKTABLE_CATALOG"), this.column("FKTABLE_SCHEMA"), this.column("FKTABLE_NAME"), this.column("FKCOLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_SMALLINT), this.column("UPDATE_RULE", TypeInfo.TYPE_SMALLINT), this.column("DELETE_RULE", TypeInfo.TYPE_SMALLINT), this.column("FK_NAME"), this.column("PK_NAME"), this.column("DEFERRABILITY", TypeInfo.TYPE_SMALLINT)};
                indexColumnName = "PKTABLE_NAME";
                break;
            }
            case 21: {
                this.setMetaTableName("CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CONSTRAINT_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("UNIQUE_INDEX_NAME"), this.column("CHECK_EXPRESSION"), this.column("COLUMN_LIST"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setMetaTableName("CONSTANTS");
                cols = new Column[]{this.column("CONSTANT_CATALOG"), this.column("CONSTANT_SCHEMA"), this.column("CONSTANT_NAME"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 23: {
                this.setMetaTableName("DOMAINS");
                cols = new Column[]{this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("DOMAIN_DEFAULT"), this.column("DOMAIN_ON_UPDATE"), this.column("DATA_TYPE", TypeInfo.TYPE_INTEGER), this.column("PRECISION", TypeInfo.TYPE_INTEGER), this.column("SCALE", TypeInfo.TYPE_INTEGER), this.column("TYPE_NAME"), this.column("PARENT_DOMAIN_CATALOG"), this.column("PARENT_DOMAIN_SCHEMA"), this.column("PARENT_DOMAIN_NAME"), this.column("SELECTIVITY", TypeInfo.TYPE_INTEGER), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER), this.column("COLUMN_DEFAULT"), this.column("IS_NULLABLE"), this.column("CHECK_CONSTRAINT")};
                break;
            }
            case 24: {
                this.setMetaTableName("TRIGGERS");
                cols = new Column[]{this.column("TRIGGER_CATALOG"), this.column("TRIGGER_SCHEMA"), this.column("TRIGGER_NAME"), this.column("TRIGGER_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("BEFORE", TypeInfo.TYPE_BOOLEAN), this.column("JAVA_CLASS"), this.column("QUEUE_SIZE", TypeInfo.TYPE_INTEGER), this.column("NO_WAIT", TypeInfo.TYPE_BOOLEAN), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 25: {
                this.setMetaTableName("SESSIONS");
                cols = new Column[]{this.column("ID", TypeInfo.TYPE_INTEGER), this.column("USER_NAME"), this.column("SERVER"), this.column("CLIENT_ADDR"), this.column("CLIENT_INFO"), this.column("SESSION_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("ISOLATION_LEVEL"), this.column("STATEMENT"), this.column("STATEMENT_START", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("CONTAINS_UNCOMMITTED", TypeInfo.TYPE_BOOLEAN), this.column("STATE"), this.column("BLOCKER_ID", TypeInfo.TYPE_INTEGER), this.column("SLEEP_SINCE", TypeInfo.TYPE_TIMESTAMP_TZ)};
                break;
            }
            case 26: {
                this.setMetaTableName("LOCKS");
                cols = new Column[]{this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("SESSION_ID", TypeInfo.TYPE_INTEGER), this.column("LOCK_TYPE")};
                break;
            }
            case 27: {
                this.setMetaTableName("SESSION_STATE");
                cols = new Column[]{this.column("KEY"), this.column("SQL")};
                break;
            }
            case 28: {
                this.setMetaTableName("QUERY_STATISTICS");
                cols = new Column[]{this.column("SQL_STATEMENT"), this.column("EXECUTION_COUNT", TypeInfo.TYPE_INTEGER), this.column("MIN_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MAX_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("CUMULATIVE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("AVERAGE_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_EXECUTION_TIME", TypeInfo.TYPE_DOUBLE), this.column("MIN_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("MAX_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("CUMULATIVE_ROW_COUNT", TypeInfo.TYPE_BIGINT), this.column("AVERAGE_ROW_COUNT", TypeInfo.TYPE_DOUBLE), this.column("STD_DEV_ROW_COUNT", TypeInfo.TYPE_DOUBLE)};
                break;
            }
            case 29: {
                this.setMetaTableName("SYNONYMS");
                cols = new Column[]{this.column("SYNONYM_CATALOG"), this.column("SYNONYM_SCHEMA"), this.column("SYNONYM_NAME"), this.column("SYNONYM_FOR"), this.column("SYNONYM_FOR_SCHEMA"), this.column("TYPE_NAME"), this.column("STATUS"), this.column("REMARKS"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                indexColumnName = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CONSTRAINT_TYPE"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setMetaTableName("DOMAIN_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("DOMAIN_CATALOG"), this.column("DOMAIN_SCHEMA"), this.column("DOMAIN_NAME"), this.column("IS_DEFERRABLE"), this.column("INITIALLY_DEFERRED"), this.column("REMARKS"), this.column("SQL"), this.column("ID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 32: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("ORDINAL_POSITION", TypeInfo.TYPE_INTEGER), this.column("POSITION_IN_UNIQUE_CONSTRAINT", TypeInfo.TYPE_INTEGER), this.column("INDEX_CATALOG"), this.column("INDEX_SCHEMA"), this.column("INDEX_NAME")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            case 33: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("UNIQUE_CONSTRAINT_CATALOG"), this.column("UNIQUE_CONSTRAINT_SCHEMA"), this.column("UNIQUE_CONSTRAINT_NAME"), this.column("MATCH_OPTION"), this.column("UPDATE_RULE"), this.column("DELETE_RULE")};
                break;
            }
            case 34: {
                this.setMetaTableName("CHECK_CONSTRAINTS");
                cols = new Column[]{this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME"), this.column("CHECK_CLAUSE")};
                break;
            }
            case 35: {
                this.setMetaTableName("CONSTRAINT_COLUMN_USAGE");
                cols = new Column[]{this.column("TABLE_CATALOG"), this.column("TABLE_SCHEMA"), this.column("TABLE_NAME"), this.column("COLUMN_NAME"), this.column("CONSTRAINT_CATALOG"), this.column("CONSTRAINT_SCHEMA"), this.column("CONSTRAINT_NAME")};
                indexColumnName = "TABLE_NAME";
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + type);
            }
        }
        this.setColumns(cols);
        if (indexColumnName == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(indexColumnName)).getColumnId();
            IndexColumn[] indexCols = IndexColumn.wrap(new Column[]{cols[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexCols, false);
        }
    }

    private static String replaceNullWithEmpty(String s) {
        return s == null ? "" : s;
    }

    @Override
    public ArrayList<Row> generateRows(SessionLocal session, SearchRow first, SearchRow last) {
        Value indexFrom = null;
        Value indexTo = null;
        if (this.indexColumn >= 0) {
            if (first != null) {
                indexFrom = first.getValue(this.indexColumn);
            }
            if (last != null) {
                indexTo = last.getValue(this.indexColumn);
            }
        }
        ArrayList<Row> rows = Utils.newSmallArrayList();
        String catalog = this.database.getShortName();
        boolean admin = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table table : this.getAllTables(session)) {
                    String tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    String storageType = table.isTemporary() ? (table.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (table.isPersistIndexes() ? "CACHED" : "MEMORY");
                    String sql = table.getCreateSQL();
                    if (!admin && sql != null && sql.contains("--hide--")) {
                        sql = "-";
                    }
                    this.add(session, rows, catalog, table.getSchema().getName(), tableName, table.getTableType().toString(), storageType, sql, InformationSchemaTableLegacy.replaceNullWithEmpty(table.getComment()), ValueBigint.get(table.getMaxDataModificationId()), ValueInteger.get(table.getId()), null, table.getClass().getName(), ValueBigint.get(table.getRowCountApproximation(session)));
                }
                break;
            }
            case 1: {
                ArrayList<Table> tablesToList;
                if (indexFrom != null && indexFrom.equals(indexTo)) {
                    String string = indexFrom.getString();
                    if (string == null) break;
                    tablesToList = this.getTablesByName(session, string);
                } else {
                    tablesToList = this.getAllTables(session);
                }
                for (Table table : tablesToList) {
                    String tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    Column[] cols = table.getColumns();
                    String collation = this.database.getCompareMode().getName();
                    for (int j = 0; j < cols.length; ++j) {
                        boolean hasDateTimePrecision;
                        Column c = cols[j];
                        Domain domain = c.getDomain();
                        TypeInfo typeInfo = c.getType();
                        ValueInteger precision = ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision()));
                        ValueInteger scale = ValueInteger.get(typeInfo.getScale());
                        Sequence sequence = c.getSequence();
                        int type = typeInfo.getValueType();
                        switch (type) {
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 27: 
                            case 31: 
                            case 33: 
                            case 34: {
                                hasDateTimePrecision = true;
                                break;
                            }
                            default: {
                                hasDateTimePrecision = false;
                            }
                        }
                        boolean isGenerated = c.isGenerated();
                        boolean isInterval = DataType.isIntervalType(type);
                        String createSQLWithoutName = c.getCreateSQLWithoutName();
                        this.add(session, rows, catalog, table.getSchema().getName(), tableName, c.getName(), ValueInteger.get(j + 1), isGenerated ? null : c.getDefaultSQL(), c.isNullable() ? "YES" : "NO", ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), precision, precision, precision, ValueInteger.get(10), scale, hasDateTimePrecision ? scale : null, isInterval ? createSQLWithoutName.substring(9) : null, isInterval ? precision : null, CHARACTER_SET_NAME, collation, domain != null ? catalog : null, domain != null ? domain.getSchema().getName() : null, domain != null ? domain.getName() : null, isGenerated ? "ALWAYS" : "NEVER", isGenerated ? c.getDefaultSQL() : null, this.identifier(isInterval ? "INTERVAL" : typeInfo.getDeclaredTypeName()), ValueInteger.get(c.isNullable() ? 1 : 0), ValueBoolean.get(isGenerated), ValueInteger.get(c.getSelectivity()), sequence == null ? null : sequence.getName(), InformationSchemaTableLegacy.replaceNullWithEmpty(c.getComment()), null, createSQLWithoutName, c.getOnUpdateSQL(), ValueBoolean.get(c.getVisible()), null);
                    }
                }
                break;
            }
            case 2: {
                ArrayList<Table> tablesToList;
                if (indexFrom != null && indexFrom.equals(indexTo)) {
                    String string = indexFrom.getString();
                    if (string == null) break;
                    tablesToList = this.getTablesByName(session, string);
                } else {
                    tablesToList = this.getAllTables(session);
                }
                for (Table table : tablesToList) {
                    String tableName = table.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo) || this.hideTable(table, session)) continue;
                    ArrayList<Index> indexes = table.getIndexes();
                    ArrayList<Constraint> constraints = table.getConstraints();
                    for (int j = 0; indexes != null && j < indexes.size(); ++j) {
                        Index index = indexes.get(j);
                        if (index.getCreateSQL() == null) continue;
                        String constraintName = null;
                        for (int k = 0; constraints != null && k < constraints.size(); ++k) {
                            Constraint constraint = constraints.get(k);
                            if (!constraint.usesIndex(index)) continue;
                            if (index.getIndexType().isPrimaryKey()) {
                                if (constraint.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                constraintName = constraint.getName();
                                continue;
                            }
                            constraintName = constraint.getName();
                        }
                        IndexColumn[] cols = index.getIndexColumns();
                        int uniqueColumnCount = index.getUniqueColumnCount();
                        String indexClass = index.getClass().getName();
                        for (int k = 0; k < cols.length; ++k) {
                            IndexColumn idxCol = cols[k];
                            Column column = idxCol.column;
                            this.add(session, rows, catalog, table.getSchema().getName(), tableName, ValueBoolean.get(k >= uniqueColumnCount), index.getName(), ValueSmallint.get((short)(k + 1)), column.getName(), ValueInteger.get(0), ValueBoolean.get(index.getIndexType().isPrimaryKey()), index.getIndexType().getSQL(), ValueBoolean.get(index.getIndexType().getBelongsToConstraint()), ValueSmallint.get((short)3), (idxCol.sortType & 1) != 0 ? "D" : "A", ValueInteger.get(0), "", InformationSchemaTableLegacy.replaceNullWithEmpty(index.getComment()), index.getCreateSQL(), ValueInteger.get(index.getId()), ValueInteger.get(idxCol.sortType), constraintName, indexClass);
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(session, rows, TableType.TABLE.toString());
                this.add(session, rows, TableType.TABLE_LINK.toString());
                this.add(session, rows, TableType.SYSTEM_TABLE.toString());
                this.add(session, rows, TableType.VIEW.toString());
                this.add(session, rows, TableType.EXTERNAL_TABLE_ENGINE.toString());
                break;
            }
            case 4: {
                int n = 42;
                for (int i = 1; i < n; ++i) {
                    DataType t = DataType.getDataType(i);
                    this.add(session, rows, Value.getTypeName(t.type), ValueInteger.get(t.sqlType), ValueInteger.get(MathUtils.convertLongToInt(t.maxPrecision)), t.prefix, t.suffix, t.params, ValueBoolean.FALSE, ValueSmallint.get(MathUtils.convertIntToShort(t.minScale)), ValueSmallint.get(MathUtils.convertIntToShort(t.maxScale)), DataType.isNumericType(i) ? ValueInteger.get(10) : null, ValueInteger.get(t.type), ValueBoolean.get(t.caseSensitive), ValueSmallint.get((short)1), ValueSmallint.get((short)3));
                }
                break;
            }
            case 5: {
                this.add(session, rows, catalog);
                break;
            }
            case 6: {
                for (Setting setting : this.database.getAllSettings()) {
                    String value = setting.getStringValue();
                    if (value == null) {
                        value = Integer.toString(setting.getIntValue());
                    }
                    this.add(session, rows, this.identifier(setting.getName()), value);
                }
                this.add(session, rows, "info.BUILD_ID", "219");
                this.add(session, rows, "info.VERSION_MAJOR", "2");
                this.add(session, rows, "info.VERSION_MINOR", "2");
                this.add(session, rows, "info.VERSION", Constants.FULL_VERSION);
                if (admin) {
                    String[] settings;
                    String[] stringArray = settings = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    int value = stringArray.length;
                    for (int tableName = 0; tableName < value; ++tableName) {
                        String s = stringArray[tableName];
                        this.add(session, rows, "property." + s, Utils.getProperty(s, ""));
                    }
                }
                this.add(session, rows, "DEFAULT_NULL_ORDERING", this.database.getDefaultNullOrdering().name());
                this.add(session, rows, "EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE");
                this.add(session, rows, "MODE", this.database.getMode().getName());
                this.add(session, rows, "QUERY_TIMEOUT", Integer.toString(session.getQueryTimeout()));
                this.add(session, rows, "TIME ZONE", session.currentTimeZone().getId());
                this.add(session, rows, "TRUNCATE_LARGE_LENGTH", session.isTruncateLargeLength() ? "TRUE" : "FALSE");
                this.add(session, rows, "VARIABLE_BINARY", session.isVariableBinary() ? "TRUE" : "FALSE");
                this.add(session, rows, "OLD_INFORMATION_SCHEMA", session.isOldInformationSchema() ? "TRUE" : "FALSE");
                BitSet nonKeywords = session.getNonKeywords();
                if (nonKeywords != null) {
                    this.add(session, rows, "NON_KEYWORDS", Parser.formatNonKeywords(nonKeywords));
                }
                this.add(session, rows, "RETENTION_TIME", Integer.toString(this.database.getRetentionTime()));
                for (Map.Entry<String, String> entry : this.database.getSettings().getSortedSettings()) {
                    this.add(session, rows, entry.getKey(), entry.getValue());
                }
                Store store = this.database.getStore();
                MVStore mvStore = store.getMvStore();
                FileStore fs = mvStore.getFileStore();
                if (fs == null) break;
                this.add(session, rows, "info.FILE_WRITE", Long.toString(fs.getWriteCount()));
                this.add(session, rows, "info.FILE_WRITE_BYTES", Long.toString(fs.getWriteBytes()));
                this.add(session, rows, "info.FILE_READ", Long.toString(fs.getReadCount()));
                this.add(session, rows, "info.FILE_READ_BYTES", Long.toString(fs.getReadBytes()));
                this.add(session, rows, "info.UPDATE_FAILURE_PERCENT", String.format(Locale.ENGLISH, "%.2f%%", 100.0 * mvStore.getUpdateFailureRatio()));
                this.add(session, rows, "info.FILL_RATE", Integer.toString(mvStore.getFillRate()));
                this.add(session, rows, "info.CHUNKS_FILL_RATE", Integer.toString(mvStore.getChunksFillRate()));
                this.add(session, rows, "info.CHUNKS_FILL_RATE_RW", Integer.toString(mvStore.getRewritableChunksFillRate()));
                try {
                    this.add(session, rows, "info.FILE_SIZE", Long.toString(fs.getFile().size()));
                }
                catch (IOException entry) {
                    // empty catch block
                }
                this.add(session, rows, "info.CHUNK_COUNT", Long.toString(mvStore.getChunkCount()));
                this.add(session, rows, "info.PAGE_COUNT", Long.toString(mvStore.getPageCount()));
                this.add(session, rows, "info.PAGE_COUNT_LIVE", Long.toString(mvStore.getLivePageCount()));
                this.add(session, rows, "info.PAGE_SIZE", Integer.toString(mvStore.getPageSplitSize()));
                this.add(session, rows, "info.CACHE_MAX_SIZE", Integer.toString(mvStore.getCacheSize()));
                this.add(session, rows, "info.CACHE_SIZE", Integer.toString(mvStore.getCacheSizeUsed()));
                this.add(session, rows, "info.CACHE_HIT_RATIO", Integer.toString(mvStore.getCacheHitRatio()));
                this.add(session, rows, "info.TOC_CACHE_HIT_RATIO", Integer.toString(mvStore.getTocCacheHitRatio()));
                this.add(session, rows, "info.LEAF_RATIO", Integer.toString(mvStore.getLeafRatio()));
                break;
            }
            case 7: {
                String resource = "/org/h2/res/help.csv";
                try {
                    byte[] byArray = Utils.getResource(resource);
                    InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), StandardCharsets.UTF_8);
                    Csv csv = new Csv();
                    csv.setLineCommentCharacter('#');
                    ResultSet rs = csv.read(reader, null);
                    int columnCount = rs.getMetaData().getColumnCount() - 1;
                    String[] values = new String[5];
                    int i = 0;
                    while (rs.next()) {
                        for (int j = 0; j < columnCount; ++j) {
                            String s = rs.getString(1 + j);
                            switch (j) {
                                case 2: {
                                    s = Help.stripAnnotationsFromSyntax(s);
                                    break;
                                }
                                case 3: {
                                    s = Help.processHelpText(s);
                                }
                            }
                            values[j] = s.trim();
                        }
                        this.add(session, rows, ValueInteger.get(i), values[0], values[1], values[2], values[3]);
                        ++i;
                    }
                    break;
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            case 8: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
                    Sequence s = (Sequence)schemaObject;
                    TypeInfo dataType = s.getDataType();
                    String dataTypeName = Value.getTypeName(dataType.getValueType());
                    ValueInteger declaredScale = ValueInteger.get(dataType.getScale());
                    this.add(session, rows, catalog, s.getSchema().getName(), s.getName(), dataTypeName, ValueInteger.get(s.getEffectivePrecision()), ValueInteger.get(10), declaredScale, ValueBigint.get(s.getStartValue()), ValueBigint.get(s.getMinValue()), ValueBigint.get(s.getMaxValue()), ValueBigint.get(s.getIncrement()), s.getCycle().isCycle() ? "YES" : "NO", dataTypeName, ValueInteger.get((int)dataType.getPrecision()), declaredScale, ValueBigint.get(s.getCurrentValue()), ValueBoolean.get(s.getBelongsToTable()), InformationSchemaTableLegacy.replaceNullWithEmpty(s.getComment()), ValueBigint.get(s.getCacheSize()), ValueInteger.get(s.getId()), ValueBigint.get(s.getMinValue()), ValueBigint.get(s.getMaxValue()), ValueBoolean.get(s.getCycle().isCycle()));
                }
                break;
            }
            case 9: {
                for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof User)) continue;
                    User u = (User)rightOwner;
                    if (!admin && session.getUser() != u) continue;
                    this.add(session, rows, this.identifier(u.getName()), String.valueOf(u.isAdmin()), InformationSchemaTableLegacy.replaceNullWithEmpty(u.getComment()), ValueInteger.get(u.getId()));
                }
                break;
            }
            case 10: {
                for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof Role)) continue;
                    Role r = (Role)rightOwner;
                    if (!admin && !session.getUser().isRoleGranted(r)) continue;
                    this.add(session, rows, this.identifier(r.getName()), InformationSchemaTableLegacy.replaceNullWithEmpty(r.getComment()), ValueInteger.get(r.getId()));
                }
                break;
            }
            case 11: {
                if (!admin) break;
                for (Right right : this.database.getAllRights()) {
                    String rightType;
                    Role role = right.getGrantedRole();
                    DbObject grantee = right.getGrantee();
                    String string = rightType = grantee.getType() == 2 ? "USER" : "ROLE";
                    if (role == null) {
                        String schemaName;
                        DbObject object = right.getGrantedObject();
                        Schema schema = null;
                        DbObject table = null;
                        if (object != null) {
                            if (object instanceof Schema) {
                                schema = (Schema)object;
                            } else if (object instanceof Table) {
                                table = (Table)object;
                                schema = ((SchemaObject)table).getSchema();
                            }
                        }
                        String tableName = table != null ? table.getName() : "";
                        String string2 = schemaName = schema != null ? schema.getName() : "";
                        if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                        this.add(session, rows, this.identifier(grantee.getName()), rightType, "", right.getRights(), schemaName, tableName, ValueInteger.get(right.getId()));
                        continue;
                    }
                    this.add(session, rows, this.identifier(grantee.getName()), rightType, this.identifier(role.getName()), "", "", "", ValueInteger.get(right.getId()));
                }
                break;
            }
            case 12: {
                for (Schema schema : this.database.getAllSchemas()) {
                    for (UserDefinedFunction userDefinedFunction : schema.getAllFunctionsAndAggregates()) {
                        if (userDefinedFunction instanceof FunctionAlias) {
                            FunctionAlias.JavaMethod[] methods;
                            FunctionAlias alias = (FunctionAlias)userDefinedFunction;
                            try {
                                methods = alias.getJavaMethods();
                            }
                            catch (DbException e) {
                                continue;
                            }
                            for (FunctionAlias.JavaMethod method : methods) {
                                TypeInfo typeInfo = method.getDataType();
                                if (typeInfo == null) {
                                    typeInfo = TypeInfo.TYPE_NULL;
                                }
                                this.add(session, rows, catalog, alias.getSchema().getName(), alias.getName(), alias.getJavaClassName(), alias.getJavaMethodName(), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), typeInfo.getDeclaredTypeName(), ValueInteger.get(method.getParameterCount()), ValueSmallint.get(typeInfo.getValueType() == 0 ? (short)1 : 2), InformationSchemaTableLegacy.replaceNullWithEmpty(alias.getComment()), ValueInteger.get(alias.getId()), alias.getSource());
                            }
                            continue;
                        }
                        this.add(session, rows, catalog, this.database.getMainSchema().getName(), userDefinedFunction.getName(), userDefinedFunction.getJavaClassName(), "", ValueInteger.get(0), "NULL", ValueInteger.get(1), ValueSmallint.get((short)2), InformationSchemaTableLegacy.replaceNullWithEmpty(userDefinedFunction.getComment()), ValueInteger.get(userDefinedFunction.getId()), "");
                    }
                }
                break;
            }
            case 20: {
                for (Schema schema : this.database.getAllSchemas()) {
                    for (UserDefinedFunction userDefinedFunction : schema.getAllFunctionsAndAggregates()) {
                        FunctionAlias.JavaMethod[] methods;
                        if (!(userDefinedFunction instanceof FunctionAlias)) continue;
                        FunctionAlias alias = (FunctionAlias)userDefinedFunction;
                        try {
                            methods = alias.getJavaMethods();
                        }
                        catch (DbException e) {
                            continue;
                        }
                        for (FunctionAlias.JavaMethod method : methods) {
                            TypeInfo typeInfo = method.getDataType();
                            if (typeInfo != null && typeInfo.getValueType() != 0) {
                                DataType dt = DataType.getDataType(typeInfo.getValueType());
                                this.add(session, rows, catalog, alias.getSchema().getName(), alias.getName(), alias.getJavaClassName(), alias.getJavaMethodName(), ValueInteger.get(method.getParameterCount()), ValueInteger.get(0), "P0", ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), typeInfo.getDeclaredTypeName(), ValueInteger.get(MathUtils.convertLongToInt(dt.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(dt.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get((short)2), ValueSmallint.get((short)5), "", null);
                            }
                            Class<?>[] columnList = method.getColumnClasses();
                            for (int k = 0; k < columnList.length; ++k) {
                                if (method.hasConnectionParam() && k == 0) continue;
                                Class<?> clazz = columnList[k];
                                TypeInfo columnTypeInfo = ValueToObjectConverter2.classToType(clazz);
                                DataType dt = DataType.getDataType(columnTypeInfo.getValueType());
                                this.add(session, rows, catalog, alias.getSchema().getName(), alias.getName(), alias.getJavaClassName(), alias.getJavaMethodName(), ValueInteger.get(method.getParameterCount()), ValueInteger.get(k + (method.hasConnectionParam() ? 0 : 1)), "P" + (k + 1), ValueInteger.get(DataType.convertTypeToSQLType(columnTypeInfo)), columnTypeInfo.getDeclaredTypeName(), ValueInteger.get(MathUtils.convertLongToInt(dt.defaultPrecision)), ValueSmallint.get(MathUtils.convertIntToShort(dt.defaultScale)), ValueSmallint.get((short)10), ValueSmallint.get(clazz.isPrimitive() ? (short)0 : 1), ValueSmallint.get((short)1), "", null);
                            }
                        }
                    }
                }
                break;
            }
            case 13: {
                String collation = this.database.getCompareMode().getName();
                for (Schema schema : this.database.getAllSchemas()) {
                    this.add(session, rows, catalog, schema.getName(), this.identifier(schema.getOwner().getName()), CHARACTER_SET_NAME, collation, ValueBoolean.get(schema.getId() == 0), InformationSchemaTableLegacy.replaceNullWithEmpty(schema.getComment()), ValueInteger.get(schema.getId()));
                }
                break;
            }
            case 14: {
                for (Right right : this.database.getAllRights()) {
                    String tableName;
                    Table table;
                    DbObject object = right.getGrantedObject();
                    if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    this.addPrivileges(session, rows, right.getGrantee(), catalog, table, null, right.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right right : this.database.getAllRights()) {
                    String tableName;
                    Table table;
                    DbObject object = right.getGrantedObject();
                    if (!(object instanceof Table) || this.hideTable(table = (Table)object, session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    DbObject grantee = right.getGrantee();
                    int mask = right.getRightMask();
                    for (Column column : table.getColumns()) {
                        this.addPrivileges(session, rows, grantee, catalog, table, column.getName(), mask);
                    }
                }
                break;
            }
            case 16: {
                for (Locale l : CompareMode.getCollationLocales(false)) {
                    this.add(session, rows, CompareMode.getName(l), l.toString());
                }
                break;
            }
            case 17: {
                for (Table table : this.getAllTables(session)) {
                    String tableName;
                    if (table.getTableType() != TableType.VIEW || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    TableView view = (TableView)table;
                    this.add(session, rows, catalog, table.getSchema().getName(), tableName, table.getCreateSQL(), "NONE", "NO", view.isInvalid() ? "INVALID" : "VALID", InformationSchemaTableLegacy.replaceNullWithEmpty(view.getComment()), ValueInteger.get(view.getId()));
                }
                break;
            }
            case 18: {
                ArrayList<InDoubtTransaction> prepared = this.database.getInDoubtTransactions();
                if (prepared == null || !admin) break;
                for (InDoubtTransaction prep : prepared) {
                    this.add(session, rows, prep.getTransactionName(), prep.getStateDescription());
                }
                break;
            }
            case 19: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)schemaObject;
                    if (constraint.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                    ConstraintReferential ref = (ConstraintReferential)constraint;
                    IndexColumn[] cols = ref.getColumns();
                    IndexColumn[] refCols = ref.getRefColumns();
                    Table tab = ref.getTable();
                    Table refTab = ref.getRefTable();
                    String tableName = refTab.getName();
                    if (!this.checkIndex(session, tableName, indexFrom, indexTo)) continue;
                    ValueSmallint update = ValueSmallint.get(InformationSchemaTableLegacy.getRefAction(ref.getUpdateAction()));
                    ValueSmallint delete = ValueSmallint.get(InformationSchemaTableLegacy.getRefAction(ref.getDeleteAction()));
                    for (int j = 0; j < cols.length; ++j) {
                        this.add(session, rows, catalog, refTab.getSchema().getName(), refTab.getName(), refCols[j].column.getName(), catalog, tab.getSchema().getName(), tab.getName(), cols[j].column.getName(), ValueSmallint.get((short)(j + 1)), update, delete, ref.getName(), ref.getReferencedConstraint().getName(), ValueSmallint.get((short)7));
                    }
                }
                break;
            }
            case 21: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    String tableName;
                    Constraint constraint = (Constraint)schemaObject;
                    Constraint.Type constraintType = constraint.getConstraintType();
                    String checkExpression = null;
                    IndexColumn[] indexColumns = null;
                    Table table = constraint.getTable();
                    if (this.hideTable(table, session)) continue;
                    Index index = constraint.getIndex();
                    String uniqueIndexName = null;
                    if (index != null) {
                        uniqueIndexName = index.getName();
                    }
                    if (!this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    if (constraintType == Constraint.Type.CHECK) {
                        checkExpression = ((ConstraintCheck)constraint).getExpression().getSQL(0);
                    } else if (constraintType == Constraint.Type.UNIQUE || constraintType == Constraint.Type.PRIMARY_KEY) {
                        indexColumns = ((ConstraintUnique)constraint).getColumns();
                    } else if (constraintType == Constraint.Type.REFERENTIAL) {
                        indexColumns = ((ConstraintReferential)constraint).getColumns();
                    }
                    String columnList = null;
                    if (indexColumns != null) {
                        StringBuilder builder = new StringBuilder();
                        int length = indexColumns.length;
                        for (int i = 0; i < length; ++i) {
                            if (i > 0) {
                                builder.append(',');
                            }
                            builder.append(indexColumns[i].column.getName());
                        }
                        columnList = builder.toString();
                    }
                    this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), constraintType == Constraint.Type.PRIMARY_KEY ? constraintType.getSqlName() : constraintType.name(), catalog, table.getSchema().getName(), tableName, uniqueIndexName, checkExpression, columnList, InformationSchemaTableLegacy.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                }
                break;
            }
            case 22: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(11)) {
                    Constant constant = (Constant)schemaObject;
                    ValueExpression expr = constant.getValue();
                    this.add(session, rows, catalog, constant.getSchema().getName(), constant.getName(), ValueInteger.get(DataType.convertTypeToSQLType(expr.getType())), InformationSchemaTableLegacy.replaceNullWithEmpty(constant.getComment()), expr.getSQL(0), ValueInteger.get(constant.getId()));
                }
                break;
            }
            case 23: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(12)) {
                    Domain domain = (Domain)schemaObject;
                    Domain parentDomain = domain.getDomain();
                    TypeInfo typeInfo = domain.getDataType();
                    this.add(session, rows, catalog, domain.getSchema().getName(), domain.getName(), domain.getDefaultSQL(), domain.getOnUpdateSQL(), ValueInteger.get(DataType.convertTypeToSQLType(typeInfo)), ValueInteger.get(MathUtils.convertLongToInt(typeInfo.getPrecision())), ValueInteger.get(typeInfo.getScale()), typeInfo.getDeclaredTypeName(), parentDomain != null ? catalog : null, parentDomain != null ? parentDomain.getSchema().getName() : null, parentDomain != null ? parentDomain.getName() : null, ValueInteger.get(50), InformationSchemaTableLegacy.replaceNullWithEmpty(domain.getComment()), domain.getCreateSQL(), ValueInteger.get(domain.getId()), domain.getDefaultSQL(), "YES", null);
                }
                break;
            }
            case 24: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(4)) {
                    TriggerObject trigger = (TriggerObject)schemaObject;
                    Table table = trigger.getTable();
                    this.add(session, rows, catalog, trigger.getSchema().getName(), trigger.getName(), trigger.getTypeNameList(new StringBuilder()).toString(), catalog, table.getSchema().getName(), table.getName(), ValueBoolean.get(trigger.isBefore()), trigger.getTriggerClassName(), ValueInteger.get(trigger.getQueueSize()), ValueBoolean.get(trigger.isNoWait()), InformationSchemaTableLegacy.replaceNullWithEmpty(trigger.getComment()), trigger.getCreateSQL(), ValueInteger.get(trigger.getId()));
                }
                break;
            }
            case 25: {
                for (SessionLocal s : this.database.getSessions(false)) {
                    if (!admin && s != session) continue;
                    NetworkConnectionInfo networkConnectionInfo = s.getNetworkConnectionInfo();
                    Command command = s.getCurrentCommand();
                    int blockingSessionId = s.getBlockingSessionId();
                    this.add(session, rows, ValueInteger.get(s.getId()), s.getUser().getName(), networkConnectionInfo == null ? null : networkConnectionInfo.getServer(), networkConnectionInfo == null ? null : networkConnectionInfo.getClient(), networkConnectionInfo == null ? null : networkConnectionInfo.getClientInfo(), s.getSessionStart(), session.getIsolationLevel().getSQL(), command == null ? null : command.toString(), command == null ? null : s.getCommandStartOrEnd(), ValueBoolean.get(s.hasPendingTransaction()), String.valueOf((Object)s.getState()), blockingSessionId == 0 ? null : ValueInteger.get(blockingSessionId), s.getState() == SessionLocal.State.SLEEP ? s.getCommandStartOrEnd() : null);
                }
                break;
            }
            case 26: {
                for (SessionLocal s : this.database.getSessions(false)) {
                    if (!admin && s != session) continue;
                    for (Table table : s.getLocks()) {
                        this.add(session, rows, table.getSchema().getName(), table.getName(), ValueInteger.get(s.getId()), table.isLockedExclusivelyBy(s) ? "WRITE" : "READ");
                    }
                }
                break;
            }
            case 27: {
                TimeZoneProvider currentTimeZone;
                String string;
                for (String name : session.getVariableNames()) {
                    Value v = session.getVariable(name);
                    StringBuilder builder = new StringBuilder().append("SET @").append(name).append(' ');
                    v.getSQL(builder, 0);
                    this.add(session, rows, "@" + name, builder.toString());
                }
                for (Table table : session.getLocalTempTables()) {
                    this.add(session, rows, "TABLE " + table.getName(), table.getCreateSQL());
                }
                String[] path = session.getSchemaSearchPath();
                if (path != null && path.length > 0) {
                    StringBuilder stringBuilder = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
                    int l = path.length;
                    for (int i = 0; i < l; ++i) {
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        StringUtils.quoteIdentifier(stringBuilder, path[i]);
                    }
                    this.add(session, rows, "SCHEMA_SEARCH_PATH", stringBuilder.toString());
                }
                if ((string = session.getCurrentSchemaName()) != null) {
                    this.add(session, rows, "SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), string).toString());
                }
                if ((currentTimeZone = session.currentTimeZone()).equals(DateTimeUtils.getTimeZone())) break;
                this.add(session, rows, "TIME ZONE", StringUtils.quoteStringSQL(new StringBuilder("SET TIME ZONE "), currentTimeZone.getId()).toString());
                break;
            }
            case 28: {
                QueryStatisticsData control = this.database.getQueryStatisticsData();
                if (control == null) break;
                for (QueryStatisticsData.QueryEntry entry : control.getQueries()) {
                    this.add(session, rows, entry.sqlStatement, ValueInteger.get(entry.count), ValueDouble.get((double)entry.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)entry.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)entry.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(entry.executionTimeMeanNanos / 1000000.0), ValueDouble.get(entry.getExecutionTimeStandardDeviation() / 1000000.0), ValueBigint.get(entry.rowCountMin), ValueBigint.get(entry.rowCountMax), ValueBigint.get(entry.rowCountCumulative), ValueDouble.get(entry.rowCountMean), ValueDouble.get(entry.getRowCountStandardDeviation()));
                }
                break;
            }
            case 29: {
                for (TableSynonym tableSynonym : this.database.getAllSynonyms()) {
                    this.add(session, rows, catalog, tableSynonym.getSchema().getName(), tableSynonym.getName(), tableSynonym.getSynonymForName(), tableSynonym.getSynonymForSchema().getName(), "SYNONYM", "VALID", InformationSchemaTableLegacy.replaceNullWithEmpty(tableSynonym.getComment()), ValueInteger.get(tableSynonym.getId()));
                }
                break;
            }
            case 30: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    String tableName;
                    Table table;
                    Constraint constraint = (Constraint)schemaObject;
                    Constraint.Type constraintType = constraint.getConstraintType();
                    if (constraintType == Constraint.Type.DOMAIN || this.hideTable(table = constraint.getTable(), session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), constraintType.getSqlName(), catalog, table.getSchema().getName(), tableName, "NO", "NO", InformationSchemaTableLegacy.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                }
                break;
            }
            case 31: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    if (((Constraint)schemaObject).getConstraintType() != Constraint.Type.DOMAIN) continue;
                    ConstraintDomain constraint = (ConstraintDomain)schemaObject;
                    Domain domain = constraint.getDomain();
                    this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), catalog, domain.getSchema().getName(), domain.getName(), "NO", "NO", InformationSchemaTableLegacy.replaceNullWithEmpty(constraint.getComment()), constraint.getCreateSQL(), ValueInteger.get(constraint.getId()));
                }
                break;
            }
            case 32: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    String tableName;
                    Table table;
                    Constraint constraint = (Constraint)schemaObject;
                    Constraint.Type constraintType = constraint.getConstraintType();
                    IndexColumn[] indexColumns = null;
                    if (constraintType == Constraint.Type.UNIQUE || constraintType == Constraint.Type.PRIMARY_KEY) {
                        indexColumns = ((ConstraintUnique)constraint).getColumns();
                    } else if (constraintType == Constraint.Type.REFERENTIAL) {
                        indexColumns = ((ConstraintReferential)constraint).getColumns();
                    }
                    if (indexColumns == null || this.hideTable(table = constraint.getTable(), session) || !this.checkIndex(session, tableName = table.getName(), indexFrom, indexTo)) continue;
                    ConstraintUnique referenced = constraintType == Constraint.Type.REFERENTIAL ? ((ConstraintReferential)constraint).getReferencedConstraint() : null;
                    Index index = constraint.getIndex();
                    for (int i = 0; i < indexColumns.length; ++i) {
                        IndexColumn indexColumn = indexColumns[i];
                        ValueInteger ordinalPosition = ValueInteger.get(i + 1);
                        ValueInteger positionInUniqueConstraint = null;
                        if (referenced != null) {
                            Column c = ((ConstraintReferential)constraint).getRefColumns()[i].column;
                            IndexColumn[] refColumns = referenced.getColumns();
                            for (int j = 0; j < refColumns.length; ++j) {
                                if (!refColumns[j].column.equals(c)) continue;
                                positionInUniqueConstraint = ValueInteger.get(j + 1);
                                break;
                            }
                        }
                        this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), catalog, table.getSchema().getName(), tableName, indexColumn.columnName, ordinalPosition, positionInUniqueConstraint, index != null ? catalog : null, index != null ? index.getSchema().getName() : null, index != null ? index.getName() : null);
                    }
                }
                break;
            }
            case 33: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    ConstraintReferential constraint;
                    Table table;
                    if (((Constraint)schemaObject).getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(table = (constraint = (ConstraintReferential)schemaObject).getTable(), session)) continue;
                    ConstraintUnique unique = constraint.getReferencedConstraint();
                    this.add(session, rows, catalog, constraint.getSchema().getName(), constraint.getName(), catalog, unique.getSchema().getName(), unique.getName(), "NONE", constraint.getUpdateAction().getSqlName(), constraint.getDeleteAction().getSqlName());
                }
                break;
            }
            case 34: {
                for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    ConstraintCheck check;
                    Table table;
                    Constraint constraint = (Constraint)schemaObject;
                    Constraint.Type constraintType = constraint.getConstraintType();
                    if (constraintType == Constraint.Type.CHECK ? this.hideTable(table = (check = (ConstraintCheck)schemaObject).getTable(), session) : constraintType != Constraint.Type.DOMAIN) continue;
                    this.add(session, rows, catalog, schemaObject.getSchema().getName(), schemaObject.getName(), constraint.getExpression().getSQL(0, 2));
                }
                break;
            }
            case 35: {
                block111: for (SchemaObject schemaObject : this.getAllSchemaObjects(5)) {
                    Constraint constraint = (Constraint)schemaObject;
                    switch (constraint.getConstraintType()) {
                        case CHECK: 
                        case DOMAIN: {
                            HashSet<Column> columns = new HashSet<Column>();
                            constraint.getExpression().isEverything(ExpressionVisitor.getColumnsVisitor(columns, null));
                            for (Column column : columns) {
                                Table table = column.getTable();
                                if (!this.checkIndex(session, table.getName(), indexFrom, indexTo) || this.hideTable(table, session)) continue;
                                this.addConstraintColumnUsage(session, rows, catalog, constraint, column);
                            }
                            continue block111;
                        }
                        case REFERENTIAL: {
                            Table table = constraint.getRefTable();
                            if (this.checkIndex(session, table.getName(), indexFrom, indexTo) && !this.hideTable(table, session)) {
                                for (Column column : constraint.getReferencedColumns(table)) {
                                    this.addConstraintColumnUsage(session, rows, catalog, constraint, column);
                                }
                            }
                        }
                        case PRIMARY_KEY: 
                        case UNIQUE: {
                            Table table = constraint.getTable();
                            if (!this.checkIndex(session, table.getName(), indexFrom, indexTo) || this.hideTable(table, session)) break;
                            for (Column column : constraint.getReferencedColumns(table)) {
                                this.addConstraintColumnUsage(session, rows, catalog, constraint, column);
                            }
                            break;
                        }
                    }
                }
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        return rows;
    }

    private static short getRefAction(ConstraintActionType action) {
        switch (action) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.getInternalError("action=" + (Object)((Object)action));
    }

    private void addConstraintColumnUsage(SessionLocal session, ArrayList<Row> rows, String catalog, Constraint constraint, Column column) {
        Table table = column.getTable();
        this.add(session, rows, catalog, table.getSchema().getName(), table.getName(), column.getName(), catalog, constraint.getSchema().getName(), constraint.getName());
    }

    private void addPrivileges(SessionLocal session, ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, int rightMask) {
        if ((rightMask & 1) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "SELECT");
        }
        if ((rightMask & 4) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "INSERT");
        }
        if ((rightMask & 8) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "UPDATE");
        }
        if ((rightMask & 2) != 0) {
            this.addPrivilege(session, rows, grantee, catalog, table, column, "DELETE");
        }
    }

    private void addPrivilege(SessionLocal session, ArrayList<Row> rows, DbObject grantee, String catalog, Table table, String column, String right) {
        User user;
        String isGrantable = "NO";
        if (grantee.getType() == 2 && (user = (User)grantee).isAdmin()) {
            isGrantable = "YES";
        }
        if (column == null) {
            this.add(session, rows, null, this.identifier(grantee.getName()), catalog, table.getSchema().getName(), table.getName(), right, isGrantable);
        } else {
            this.add(session, rows, null, this.identifier(grantee.getName()), catalog, table.getSchema().getName(), table.getName(), column, right, isGrantable);
        }
    }

    private ArrayList<SchemaObject> getAllSchemaObjects(int type) {
        ArrayList<SchemaObject> list = new ArrayList<SchemaObject>();
        for (Schema schema : this.database.getAllSchemas()) {
            schema.getAll(type, list);
        }
        return list;
    }

    private ArrayList<Table> getAllTables(SessionLocal session) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Schema schema : this.database.getAllSchemas()) {
            tables.addAll(schema.getAllTablesAndViews(session));
        }
        tables.addAll(session.getLocalTempTables());
        return tables;
    }

    private ArrayList<Table> getTablesByName(SessionLocal session, String tableName) {
        ArrayList<Table> tables = new ArrayList<Table>(1);
        for (Schema schema : this.database.getAllSchemas()) {
            Table table = schema.getTableOrViewByName(session, tableName);
            if (table == null) continue;
            tables.add(table);
        }
        Table table = session.findLocalTempTable(tableName);
        if (table != null) {
            tables.add(table);
        }
        return tables;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 8: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }
}

