/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ParserUtil;

public class IndexColumn {
    public static final int SQL_NO_ORDER = Integer.MIN_VALUE;
    public final String columnName;
    public Column column;
    public int sortType = 0;

    public static StringBuilder writeColumns(StringBuilder builder, IndexColumn[] columns, int sqlFlags) {
        return IndexColumn.writeColumns(builder, columns, 0, columns.length, sqlFlags);
    }

    public static StringBuilder writeColumns(StringBuilder builder, IndexColumn[] columns, int startOffset, int endOffset, int sqlFlags) {
        for (int i = startOffset; i < endOffset; ++i) {
            if (i > startOffset) {
                builder.append(", ");
            }
            columns[i].getSQL(builder, sqlFlags);
        }
        return builder;
    }

    public static StringBuilder writeColumns(StringBuilder builder, IndexColumn[] columns, String separator, String suffix, int sqlFlags) {
        int l = columns.length;
        for (int i = 0; i < l; ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            columns[i].getSQL(builder, sqlFlags).append(suffix);
        }
        return builder;
    }

    public IndexColumn(String columnName) {
        this.columnName = columnName;
    }

    public IndexColumn(String columnName, int sortType) {
        this.columnName = columnName;
        this.sortType = sortType;
    }

    public IndexColumn(Column column) {
        this.columnName = null;
        this.column = column;
    }

    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        if (this.column != null) {
            this.column.getSQL(builder, sqlFlags);
        } else {
            ParserUtil.quoteIdentifier(builder, this.columnName, sqlFlags);
        }
        if ((sqlFlags & Integer.MIN_VALUE) == 0) {
            SortOrder.typeToString(builder, this.sortType);
        }
        return builder;
    }

    public static IndexColumn[] wrap(Column[] columns) {
        IndexColumn[] list = new IndexColumn[columns.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new IndexColumn(columns[i]);
        }
        return list;
    }

    public static void mapColumns(IndexColumn[] indexColumns, Table table) {
        for (IndexColumn col : indexColumns) {
            col.column = table.getColumn(col.columnName);
        }
    }

    public String toString() {
        return this.getSQL(new StringBuilder("IndexColumn "), 3).toString();
    }
}

