/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.encrypt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.encrypt.FileEncrypt;

public class FilePathEncrypt
extends FilePathWrapper {
    private static final String SCHEME = "encrypt";

    public static void register() {
        FilePath.register(new FilePathEncrypt());
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        String[] parsed = this.parse(this.name);
        FileChannel file = FileUtils.open(parsed[1], mode);
        byte[] passwordBytes = parsed[0].getBytes(StandardCharsets.UTF_8);
        return new FileEncrypt(this.name, passwordBytes, file);
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    protected String getPrefix() {
        String[] parsed = this.parse(this.name);
        return this.getScheme() + ":" + parsed[0] + ":";
    }

    @Override
    public FilePath unwrap(String fileName) {
        return FilePath.get(this.parse(fileName)[1]);
    }

    @Override
    public long size() {
        long size = this.getBase().size() - 4096L;
        if (((size = Math.max(0L, size)) & 0xFFFL) != 0L) {
            size -= 4096L;
        }
        return size;
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        return FilePathEncrypt.newFileChannelOutputStream(this.open("rw"), append);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return Channels.newInputStream(this.open("r"));
    }

    private String[] parse(String fileName) {
        if (!fileName.startsWith(this.getScheme())) {
            throw new IllegalArgumentException(fileName + " doesn't start with " + this.getScheme());
        }
        int idx = (fileName = fileName.substring(this.getScheme().length() + 1)).indexOf(58);
        if (idx < 0) {
            throw new IllegalArgumentException(fileName + " doesn't contain encryption algorithm and password");
        }
        String password = fileName.substring(0, idx);
        fileName = fileName.substring(idx + 1);
        return new String[]{password, fileName};
    }

    public static byte[] getPasswordBytes(char[] passwordChars) {
        int len = passwordChars.length;
        byte[] password = new byte[len * 2];
        for (int i = 0; i < len; ++i) {
            char c = passwordChars[i];
            password[i + i] = (byte)(c >>> 8);
            password[i + i + 1] = (byte)c;
        }
        return password;
    }
}

