/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs.disk;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

public class FilePathDisk
extends FilePath {
    private static final String CLASSPATH_PREFIX = "classpath:";

    @Override
    public FilePathDisk getPath(String path) {
        FilePathDisk p = new FilePathDisk();
        p.name = FilePathDisk.translateFileName(path);
        return p;
    }

    @Override
    public long size() {
        if (this.name.startsWith(CLASSPATH_PREFIX)) {
            try {
                URL resource;
                String fileName = this.name.substring(CLASSPATH_PREFIX.length());
                if (!fileName.startsWith("/")) {
                    fileName = "/" + fileName;
                }
                if ((resource = this.getClass().getResource(fileName)) != null) {
                    return Files.size(Paths.get(resource.toURI()));
                }
                return 0L;
            }
            catch (Exception e) {
                return 0L;
            }
        }
        try {
            return Files.size(Paths.get(this.name, new String[0]));
        }
        catch (IOException e) {
            return 0L;
        }
    }

    protected static String translateFileName(String fileName) {
        if ((fileName = fileName.replace('\\', '/')).startsWith("file:")) {
            fileName = fileName.substring(5);
        } else if (fileName.startsWith("nio:")) {
            fileName = fileName.substring(4);
        }
        return FilePathDisk.expandUserHomeDirectory(fileName);
    }

    public static String expandUserHomeDirectory(String fileName) {
        if (fileName.startsWith("~") && (fileName.length() == 1 || fileName.startsWith("~/"))) {
            String userDir = SysProperties.USER_HOME;
            fileName = userDir + fileName.substring(1);
        }
        return fileName;
    }

    @Override
    public void moveTo(FilePath newName, boolean atomicReplace) {
        CopyOption[] copyOptionArray;
        Path oldFile = Paths.get(this.name, new String[0]);
        Path newFile = Paths.get(newName.name, new String[0]);
        if (!Files.exists(oldFile, new LinkOption[0])) {
            throw DbException.get(90024, this.name + " (not found)", newName.name);
        }
        if (atomicReplace) {
            try {
                Files.move(oldFile, newFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                return;
            }
            catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
            }
            catch (IOException ex) {
                throw DbException.get(90024, ex, this.name, newName.name);
            }
        }
        if (atomicReplace) {
            CopyOption[] copyOptionArray2 = new CopyOption[1];
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] copyOptions = copyOptionArray;
        try {
            Files.move(oldFile, newFile, copyOptions);
        }
        catch (FileAlreadyExistsException ex) {
            throw DbException.get(90024, this.name, newName + " (exists)");
        }
        catch (IOException ex) {
            IOException cause = ex;
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                IOUtils.trace("rename", this.name + " >" + newName, null);
                try {
                    Files.move(oldFile, newFile, copyOptions);
                    return;
                }
                catch (FileAlreadyExistsException ex2) {
                    throw DbException.get(90024, this.name, newName + " (exists)");
                }
                catch (IOException ex2) {
                    cause = ex;
                    FilePathDisk.wait(i);
                    continue;
                }
            }
            throw DbException.get(90024, cause, this.name, newName.name);
        }
    }

    private static void wait(int i) {
        if (i == 8) {
            System.gc();
        }
        try {
            long sleep = Math.min(256, i * i);
            Thread.sleep(sleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean createFile() {
        Path file = Paths.get(this.name, new String[0]);
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            try {
                Files.createFile(file, new FileAttribute[0]);
                return true;
            }
            catch (FileAlreadyExistsException e) {
                return false;
            }
            catch (IOException e) {
                FilePathDisk.wait(i);
                continue;
            }
        }
        return false;
    }

    @Override
    public boolean exists() {
        return Files.exists(Paths.get(this.name, new String[0]), new LinkOption[0]);
    }

    @Override
    public void delete() {
        Path file = Paths.get(this.name, new String[0]);
        IOException cause = null;
        for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
            IOUtils.trace("delete", this.name, null);
            try {
                Files.deleteIfExists(file);
                return;
            }
            catch (DirectoryNotEmptyException e) {
                throw DbException.get(90025, e, this.name);
            }
            catch (IOException e) {
                cause = e;
                FilePathDisk.wait(i);
                continue;
            }
        }
        throw DbException.get(90025, cause, this.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FilePath> newDirectoryStream() {
        try (Stream<Path> files = Files.list(FilePathDisk.toRealPath(Paths.get(this.name, new String[0])));){
            List list = files.collect(ArrayList::new, (t, u) -> t.add(this.getPath(u.toString())), ArrayList::addAll);
            return list;
        }
        catch (NoSuchFileException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.name);
        }
    }

    @Override
    public boolean canWrite() {
        try {
            return Files.isWritable(Paths.get(this.name, new String[0]));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setReadOnly() {
        Path f = Paths.get(this.name, new String[0]);
        try {
            FileStore fileStore = Files.getFileStore(f);
            if (fileStore.supportsFileAttributeView(PosixFileAttributeView.class)) {
                HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
                block5: for (PosixFilePermission p : Files.getPosixFilePermissions(f, new LinkOption[0])) {
                    switch (p) {
                        case OWNER_WRITE: 
                        case GROUP_WRITE: 
                        case OTHERS_WRITE: {
                            continue block5;
                        }
                    }
                    permissions.add(p);
                }
                Files.setPosixFilePermissions(f, permissions);
            } else if (fileStore.supportsFileAttributeView(DosFileAttributeView.class)) {
                Files.setAttribute(f, "dos:readonly", true, new LinkOption[0]);
            } else {
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public FilePathDisk toRealPath() {
        return this.getPath(FilePathDisk.toRealPath(Paths.get(this.name, new String[0])).toString());
    }

    private static Path toRealPath(Path path) {
        try {
            path = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            path = FilePathDisk.parentToRealPath(path.toAbsolutePath().normalize());
        }
        return path;
    }

    private static Path parentToRealPath(Path path) {
        Path parent = path.getParent();
        if (parent == null) {
            return path;
        }
        try {
            parent = parent.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            parent = FilePathDisk.parentToRealPath(parent);
        }
        return parent.resolve(path.getFileName());
    }

    @Override
    public FilePath getParent() {
        Path p = Paths.get(this.name, new String[0]).getParent();
        return p == null ? null : this.getPath(p.toString());
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(Paths.get(this.name, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean isRegularFile() {
        return Files.isRegularFile(Paths.get(this.name, new String[0]), new LinkOption[0]);
    }

    @Override
    public boolean isAbsolute() {
        return Paths.get(this.name, new String[0]).isAbsolute();
    }

    @Override
    public long lastModified() {
        try {
            return Files.getLastModifiedTime(Paths.get(this.name, new String[0]), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public void createDirectory() {
        Path dir = Paths.get(this.name, new String[0]);
        try {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw DbException.get(90062, this.name + " (a file with this name already exists)");
        }
        catch (IOException e) {
            IOException cause = e;
            for (int i = 0; i < SysProperties.MAX_FILE_RETRY; ++i) {
                if (Files.isDirectory(dir, new LinkOption[0])) {
                    return;
                }
                try {
                    Files.createDirectory(dir, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    throw DbException.get(90062, this.name + " (a file with this name already exists)");
                }
                catch (IOException ex) {
                    cause = ex;
                }
                FilePathDisk.wait(i);
            }
            throw DbException.get(90062, cause, this.name);
        }
    }

    @Override
    public OutputStream newOutputStream(boolean append) throws IOException {
        OpenOption[] openOptionArray;
        Path file = Paths.get(this.name, new String[0]);
        if (append) {
            OpenOption[] openOptionArray2 = new OpenOption[2];
            openOptionArray2[0] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[1] = StandardOpenOption.APPEND;
        } else {
            openOptionArray = new OpenOption[]{};
        }
        OpenOption[] options = openOptionArray;
        try {
            Path parent = file.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            OutputStream out = Files.newOutputStream(file, options);
            IOUtils.trace("openFileOutputStream", this.name, out);
            return out;
        }
        catch (IOException e) {
            FilePathDisk.freeMemoryAndFinalize();
            return Files.newOutputStream(file, options);
        }
    }

    @Override
    public InputStream newInputStream() throws IOException {
        if (this.name.matches("[a-zA-Z]{2,19}:.*")) {
            if (this.name.startsWith(CLASSPATH_PREFIX)) {
                InputStream in;
                String fileName = this.name.substring(CLASSPATH_PREFIX.length());
                if (!fileName.startsWith("/")) {
                    fileName = "/" + fileName;
                }
                if ((in = this.getClass().getResourceAsStream(fileName)) == null) {
                    in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName.substring(1));
                }
                if (in == null) {
                    throw new FileNotFoundException("resource " + fileName);
                }
                return in;
            }
            URL url = new URL(this.name);
            return url.openStream();
        }
        InputStream in = Files.newInputStream(Paths.get(this.name, new String[0]), new OpenOption[0]);
        IOUtils.trace("openFileInputStream", this.name, in);
        return in;
    }

    static void freeMemoryAndFinalize() {
        IOUtils.trace("freeMemoryAndFinalize", null, null);
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        for (int i = 0; i < 16; ++i) {
            rt.gc();
            long now = rt.freeMemory();
            rt.runFinalization();
            if (now == mem) break;
            mem = now;
        }
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        FileChannel f = FileChannel.open(Paths.get(this.name, new String[0]), FileUtils.modeToOptions(mode), FileUtils.NO_ATTRIBUTES);
        IOUtils.trace("open", this.name, f);
        return f;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        Path file = Paths.get(this.name + '.', new String[0]).toAbsolutePath();
        String prefix = file.getFileName().toString();
        if (inTempDir) {
            Path tempDir = Paths.get(System.getProperty("java.io.tmpdir", "."), new String[0]);
            if (!Files.isDirectory(tempDir, new LinkOption[0])) {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            file = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        } else {
            Path dir = file.getParent();
            Files.createDirectories(dir, new FileAttribute[0]);
            file = Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
        }
        return FilePathDisk.get(file.toString());
    }
}

