/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.store.fs.disk.FilePathDisk;
import org.h2.util.MathUtils;

public abstract class FilePath {
    private static final FilePath defaultProvider;
    private static final ConcurrentHashMap<String, FilePath> providers;
    private static String tempRandom;
    private static long tempSequence;
    public String name;

    public static FilePath get(String path) {
        int index = (path = path.replace('\\', '/')).indexOf(58);
        if (index < 2) {
            return defaultProvider.getPath(path);
        }
        String scheme = path.substring(0, index);
        FilePath p = providers.get(scheme);
        if (p == null) {
            p = defaultProvider;
        }
        return p.getPath(path);
    }

    public static void register(FilePath provider) {
        providers.put(provider.getScheme(), provider);
    }

    public static void unregister(FilePath provider) {
        providers.remove(provider.getScheme());
    }

    public abstract long size();

    public abstract void moveTo(FilePath var1, boolean var2);

    public abstract boolean createFile();

    public abstract boolean exists();

    public abstract void delete();

    public abstract List<FilePath> newDirectoryStream();

    public abstract FilePath toRealPath();

    public abstract FilePath getParent();

    public abstract boolean isDirectory();

    public abstract boolean isRegularFile();

    public abstract boolean isAbsolute();

    public abstract long lastModified();

    public abstract boolean canWrite();

    public abstract void createDirectory();

    public String getName() {
        int idx = Math.max(this.name.indexOf(58), this.name.lastIndexOf(47));
        return idx < 0 ? this.name : this.name.substring(idx + 1);
    }

    public OutputStream newOutputStream(boolean append) throws IOException {
        return FilePath.newFileChannelOutputStream(this.open("rw"), append);
    }

    public static final OutputStream newFileChannelOutputStream(FileChannel channel, boolean append) throws IOException {
        if (append) {
            channel.position(channel.size());
        } else {
            channel.position(0L);
            channel.truncate(0L);
        }
        return Channels.newOutputStream(channel);
    }

    public abstract FileChannel open(String var1) throws IOException;

    public InputStream newInputStream() throws IOException {
        return Channels.newInputStream(this.open("r"));
    }

    public abstract boolean setReadOnly();

    public FilePath createTempFile(String suffix, boolean inTempDir) throws IOException {
        FilePath p;
        while ((p = this.getPath(this.name + FilePath.getNextTempFileNamePart(false) + suffix)).exists() || !p.createFile()) {
            FilePath.getNextTempFileNamePart(true);
        }
        p.open("rw").close();
        return p;
    }

    private static synchronized String getNextTempFileNamePart(boolean newRandom) {
        if (newRandom || tempRandom == null) {
            tempRandom = MathUtils.randomInt(Integer.MAX_VALUE) + ".";
        }
        return tempRandom + tempSequence++;
    }

    public String toString() {
        return this.name;
    }

    public abstract String getScheme();

    public abstract FilePath getPath(String var1);

    public FilePath unwrap() {
        return this;
    }

    static {
        FilePath def = null;
        ConcurrentHashMap<String, FilePath> map = new ConcurrentHashMap<String, FilePath>();
        for (String c : new String[]{"org.h2.store.fs.disk.FilePathDisk", "org.h2.store.fs.mem.FilePathMem", "org.h2.store.fs.mem.FilePathMemLZF", "org.h2.store.fs.niomem.FilePathNioMem", "org.h2.store.fs.niomem.FilePathNioMemLZF", "org.h2.store.fs.split.FilePathSplit", "org.h2.store.fs.niomapped.FilePathNioMapped", "org.h2.store.fs.async.FilePathAsync", "org.h2.store.fs.zip.FilePathZip", "org.h2.store.fs.retry.FilePathRetryOnInterrupt"}) {
            try {
                FilePath p = (FilePath)Class.forName(c).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                map.put(p.getScheme(), p);
                if (p.getClass() == FilePathDisk.class) {
                    map.put("nio", p);
                }
                if (def != null) continue;
                def = p;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        defaultProvider = def;
        providers = map;
    }
}

