/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.security.SecureFileStore;
import org.h2.store.DataHandler;
import org.h2.store.fs.FileUtils;

public class FileStore {
    public static final int HEADER_LENGTH = 48;
    private static final String HEADER = "-- H2 0.5/B --      ".substring(0, 15) + "\n";
    private static final boolean ASSERT;
    protected String name;
    private final DataHandler handler;
    private FileChannel file;
    private long filePos;
    private long fileLength;
    private Reference<?> autoDeleteReference;
    private boolean checkedWriting = true;
    private final String mode;
    private FileLock lock;

    protected FileStore(DataHandler handler, String name, String mode) {
        this.handler = handler;
        this.name = name;
        try {
            boolean exists = FileUtils.exists(name);
            if (exists && !FileUtils.canWrite(name)) {
                mode = "r";
            } else {
                FileUtils.createDirectories(FileUtils.getParent(name));
            }
            this.file = FileUtils.open(name, mode);
            if (exists) {
                this.fileLength = this.file.size();
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "name: " + name + " mode: " + mode);
        }
        this.mode = mode;
    }

    public static FileStore open(DataHandler handler, String name, String mode) {
        return FileStore.open(handler, name, mode, null, null, 0);
    }

    public static FileStore open(DataHandler handler, String name, String mode, String cipher, byte[] key) {
        return FileStore.open(handler, name, mode, cipher, key, 1024);
    }

    public static FileStore open(DataHandler handler, String name, String mode, String cipher, byte[] key, int keyIterations) {
        FileStore store = cipher == null ? new FileStore(handler, name, mode) : new SecureFileStore(handler, name, mode, cipher, key, keyIterations);
        return store;
    }

    protected byte[] generateSalt() {
        return HEADER.getBytes(StandardCharsets.UTF_8);
    }

    protected void initKey(byte[] salt) {
    }

    public void setCheckedWriting(boolean value) {
        this.checkedWriting = value;
    }

    private void checkWritingAllowed() {
        if (this.handler != null && this.checkedWriting) {
            this.handler.checkWritingAllowed();
        }
    }

    private void checkPowerOff() {
        if (this.handler != null) {
            this.handler.checkPowerOff();
        }
    }

    public void init() {
        int len = 16;
        byte[] magic = HEADER.getBytes(StandardCharsets.UTF_8);
        if (this.length() < 48L) {
            this.checkedWriting = false;
            this.writeDirect(magic, 0, len);
            byte[] salt = this.generateSalt();
            this.writeDirect(salt, 0, len);
            this.initKey(salt);
            this.write(magic, 0, len);
            this.checkedWriting = true;
        } else {
            this.seek(0L);
            byte[] buff = new byte[len];
            this.readFullyDirect(buff, 0, len);
            if (!Arrays.equals(buff, magic)) {
                throw DbException.get(90048, this.name);
            }
            byte[] salt = new byte[len];
            this.readFullyDirect(salt, 0, len);
            this.initKey(salt);
            this.readFully(buff, 0, 16);
            if (!Arrays.equals(buff, magic)) {
                throw DbException.get(90049, this.name);
            }
        }
    }

    public void close() {
        if (this.file != null) {
            try {
                FileStore.trace("close", this.name, this.file);
                this.file.close();
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, this.name);
            }
            finally {
                this.file = null;
            }
        }
    }

    public void closeSilently() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeAndDeleteSilently() {
        if (this.file != null) {
            this.closeSilently();
            this.handler.getTempFileDeleter().deleteFile(this.autoDeleteReference, this.name);
            this.name = null;
        }
    }

    public void readFullyDirect(byte[] b, int off, int len) {
        this.readFully(b, off, len);
    }

    public void readFully(byte[] b, int off, int len) {
        if (len < 0 || len % 16 != 0) {
            throw DbException.getInternalError("unaligned read " + this.name + " len " + len);
        }
        this.checkPowerOff();
        try {
            FileUtils.readFully(this.file, ByteBuffer.wrap(b, off, len));
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.name);
        }
        this.filePos += (long)len;
    }

    public void seek(long pos) {
        if (pos % 16L != 0L) {
            throw DbException.getInternalError("unaligned seek " + this.name + " pos " + pos);
        }
        try {
            if (pos != this.filePos) {
                this.file.position(pos);
                this.filePos = pos;
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, this.name);
        }
    }

    protected void writeDirect(byte[] b, int off, int len) {
        this.write(b, off, len);
    }

    public void write(byte[] b, int off, int len) {
        if (len < 0 || len % 16 != 0) {
            throw DbException.getInternalError("unaligned write " + this.name + " len " + len);
        }
        this.checkWritingAllowed();
        this.checkPowerOff();
        try {
            FileUtils.writeFully(this.file, ByteBuffer.wrap(b, off, len));
        }
        catch (IOException e) {
            this.closeFileSilently();
            throw DbException.convertIOException(e, this.name);
        }
        this.filePos += (long)len;
        this.fileLength = Math.max(this.filePos, this.fileLength);
    }

    public void setLength(long newLength) {
        if (newLength % 16L != 0L) {
            throw DbException.getInternalError("unaligned setLength " + this.name + " pos " + newLength);
        }
        this.checkPowerOff();
        this.checkWritingAllowed();
        try {
            if (newLength > this.fileLength) {
                long pos = this.filePos;
                this.file.position(newLength - 1L);
                FileUtils.writeFully(this.file, ByteBuffer.wrap(new byte[1]));
                this.file.position(pos);
            } else {
                this.file.truncate(newLength);
            }
            this.fileLength = newLength;
        }
        catch (IOException e) {
            this.closeFileSilently();
            throw DbException.convertIOException(e, this.name);
        }
    }

    public long length() {
        long len = this.fileLength;
        if (ASSERT) {
            try {
                len = this.file.size();
                if (len != this.fileLength) {
                    throw DbException.getInternalError("file " + this.name + " length " + len + " expected " + this.fileLength);
                }
                if (len % 16L != 0L) {
                    long newLength = len + 16L - len % 16L;
                    this.file.truncate(newLength);
                    this.fileLength = newLength;
                    throw DbException.getInternalError("unaligned file length " + this.name + " len " + len);
                }
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, this.name);
            }
        }
        return len;
    }

    public long getFilePointer() {
        if (ASSERT) {
            try {
                if (this.file.position() != this.filePos) {
                    throw DbException.getInternalError(this.file.position() + " " + this.filePos);
                }
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, this.name);
            }
        }
        return this.filePos;
    }

    public void sync() {
        try {
            this.file.force(true);
        }
        catch (IOException e) {
            this.closeFileSilently();
            throw DbException.convertIOException(e, this.name);
        }
    }

    public void autoDelete() {
        if (this.autoDeleteReference == null) {
            this.autoDeleteReference = this.handler.getTempFileDeleter().addFile(this.name, this);
        }
    }

    public void stopAutoDelete() {
        this.handler.getTempFileDeleter().stopAutoDelete(this.autoDeleteReference, this.name);
        this.autoDeleteReference = null;
    }

    public void closeFile() throws IOException {
        this.file.close();
        this.file = null;
    }

    private void closeFileSilently() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void openFile() throws IOException {
        if (this.file == null) {
            this.file = FileUtils.open(this.name, this.mode);
            this.file.position(this.filePos);
        }
    }

    private static void trace(String method, String fileName, Object o) {
        if (SysProperties.TRACE_IO) {
            System.out.println("FileStore." + method + " " + fileName + " " + o);
        }
    }

    public synchronized boolean tryLock() {
        try {
            this.lock = this.file.tryLock();
            return this.lock != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized void releaseLock() {
        if (this.file != null && this.lock != null) {
            try {
                this.lock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lock = null;
        }
    }

    static {
        boolean a = false;
        if (!$assertionsDisabled) {
            a = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        ASSERT = a;
    }
}

