/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.h2.server.web.PageParser;
import org.h2.server.web.WebApp;
import org.h2.server.web.WebServer;
import org.h2.server.web.WebSession;
import org.h2.util.NetworkConnectionInfo;

public class WebServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient WebServer server;

    public void init() {
        ServletConfig config = this.getServletConfig();
        Enumeration en = config.getInitParameterNames();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            String value = config.getInitParameter(name);
            if (!name.startsWith("-")) {
                name = "-" + name;
            }
            list.add(name);
            if (value.length() <= 0) continue;
            list.add(value);
        }
        String[] args = list.toArray(new String[0]);
        this.server = new WebServer();
        this.server.setAllowChunked(false);
        this.server.init(args);
    }

    public void destroy() {
        this.server.stop();
    }

    private boolean allow(HttpServletRequest req) {
        if (this.server.getAllowOthers()) {
            return true;
        }
        String addr = req.getRemoteAddr();
        try {
            InetAddress address = InetAddress.getByName(addr);
            return address.isLoopbackAddress();
        }
        catch (NoClassDefFoundError | UnknownHostException e) {
            return false;
        }
    }

    private String getAllowedFile(HttpServletRequest req, String requestedFile) {
        if (!this.allow(req)) {
            return "notAllowed.jsp";
        }
        if (requestedFile.length() == 0) {
            return "index.do";
        }
        return requestedFile;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String value;
        String name;
        req.setCharacterEncoding("utf-8");
        String file = req.getPathInfo();
        if (file == null) {
            resp.sendRedirect(req.getRequestURI() + "/");
            return;
        }
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        file = this.getAllowedFile(req, file);
        Properties attributes = new Properties();
        Enumeration en = req.getAttributeNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getAttribute(name).toString();
            attributes.put(name, value);
        }
        en = req.getParameterNames();
        while (en.hasMoreElements()) {
            name = en.nextElement().toString();
            value = req.getParameter(name);
            attributes.put(name, value);
        }
        WebSession session = null;
        String sessionId = attributes.getProperty("jsessionid");
        if (sessionId != null) {
            session = this.server.getSession(sessionId);
        }
        WebApp app = new WebApp(this.server);
        app.setSession(session, attributes);
        String ifModifiedSince = req.getHeader("if-modified-since");
        String scheme = req.getScheme();
        StringBuilder builder = new StringBuilder(scheme).append("://").append(req.getServerName());
        int serverPort = req.getServerPort();
        if (!(serverPort == 80 && scheme.equals("http") || serverPort == 443 && scheme.equals("https"))) {
            builder.append(':').append(serverPort);
        }
        String path = builder.append(req.getContextPath()).toString();
        file = app.processRequest(file, new NetworkConnectionInfo(path, req.getRemoteAddr(), req.getRemotePort()));
        session = app.getSession();
        String mimeType = app.getMimeType();
        boolean cache = app.getCache();
        if (cache && this.server.getStartDateTime().equals(ifModifiedSince)) {
            resp.setStatus(304);
            return;
        }
        byte[] bytes = this.server.getFile(file);
        if (bytes == null) {
            resp.sendError(404);
            bytes = ("File not found: " + file).getBytes(StandardCharsets.UTF_8);
        } else {
            if (session != null && file.endsWith(".jsp")) {
                String page = new String(bytes, StandardCharsets.UTF_8);
                page = PageParser.parse(page, session.map);
                bytes = page.getBytes(StandardCharsets.UTF_8);
            }
            resp.setContentType(mimeType);
            if (!cache) {
                resp.setHeader("Cache-Control", "no-cache");
            } else {
                resp.setHeader("Cache-Control", "max-age=10");
                resp.setHeader("Last-Modified", this.server.getStartDateTime());
            }
        }
        if (bytes != null) {
            ServletOutputStream out = resp.getOutputStream();
            out.write(bytes);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }
}

