/*
 * Decompiled with CFR 0.152.
 */
package org.h2.security.auth;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.h2.security.auth.AuthConfigException;
import org.h2.security.auth.PropertyConfig;
import org.h2.util.Utils;

public class ConfigProperties {
    private HashMap<String, String> properties = new HashMap();

    public ConfigProperties() {
    }

    public ConfigProperties(PropertyConfig ... configProperties) {
        this(configProperties == null ? null : Arrays.asList(configProperties));
    }

    public ConfigProperties(Collection<PropertyConfig> configProperties) {
        if (configProperties != null) {
            for (PropertyConfig currentProperty : configProperties) {
                if (this.properties.putIfAbsent(currentProperty.getName(), currentProperty.getValue()) == null) continue;
                throw new AuthConfigException("duplicate property " + currentProperty.getName());
            }
        }
    }

    public String getStringValue(String name, String defaultValue) {
        String result = this.properties.get(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String getStringValue(String name) {
        String result = this.properties.get(name);
        if (result == null) {
            throw new AuthConfigException("missing config property " + name);
        }
        return result;
    }

    public int getIntValue(String name, int defaultValue) {
        String result = this.properties.get(name);
        if (result == null) {
            return defaultValue;
        }
        return Integer.parseInt(result);
    }

    public int getIntValue(String name) {
        String result = this.properties.get(name);
        if (result == null) {
            throw new AuthConfigException("missing config property " + name);
        }
        return Integer.parseInt(result);
    }

    public boolean getBooleanValue(String name, boolean defaultValue) {
        String result = this.properties.get(name);
        if (result == null) {
            return defaultValue;
        }
        return Utils.parseBoolean(result, defaultValue, true);
    }
}

