/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.api.Trigger;
import org.h2.engine.SessionLocal;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SimpleResult;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.tools.TriggerAdapter;
import org.h2.util.JdbcUtils;
import org.h2.util.SourceCompiler;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueToObjectConverter;

public final class TriggerObject
extends SchemaObject {
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    private boolean insteadOf;
    private boolean before;
    private int typeMask;
    private boolean rowBased;
    private boolean onRollback;
    private int queueSize = 1024;
    private boolean noWait;
    private Table table;
    private String triggerClassName;
    private String triggerSource;
    private Trigger triggerCallback;

    public TriggerObject(Schema schema, int id, String name, Table table) {
        super(schema, id, name, 12);
        this.table = table;
        this.setTemporary(table.isTemporary());
    }

    public void setBefore(boolean before) {
        this.before = before;
    }

    public boolean isInsteadOf() {
        return this.insteadOf;
    }

    public void setInsteadOf(boolean insteadOf) {
        this.insteadOf = insteadOf;
    }

    private synchronized void load() {
        if (this.triggerCallback != null) {
            return;
        }
        try {
            SessionLocal sysSession = this.database.getSystemSession();
            JdbcConnection c2 = sysSession.createConnection(false);
            Trigger obj = this.triggerClassName != null ? JdbcUtils.loadUserClass(this.triggerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : this.loadFromSource();
            this.triggerCallback = obj;
            this.triggerCallback.init(c2, this.getSchema().getName(), this.getName(), this.table.getName(), this.before, this.typeMask);
        }
        catch (Throwable e) {
            this.triggerCallback = null;
            throw DbException.get(90043, e, this.getName(), this.triggerClassName != null ? this.triggerClassName : "..source..", e.toString());
        }
    }

    private Trigger loadFromSource() {
        SourceCompiler compiler;
        SourceCompiler sourceCompiler = compiler = this.database.getCompiler();
        synchronized (sourceCompiler) {
            String fullClassName = "org.h2.dynamic.trigger." + this.getName();
            compiler.setSource(fullClassName, this.triggerSource);
            try {
                if (SourceCompiler.isJavaxScriptSource(this.triggerSource)) {
                    return (Trigger)compiler.getCompiledScript(fullClassName).eval();
                }
                Method m = compiler.getMethod(fullClassName);
                if (m.getParameterTypes().length > 0) {
                    throw new IllegalStateException("No parameters are allowed for a trigger");
                }
                return (Trigger)m.invoke(null, new Object[0]);
            }
            catch (DbException e) {
                throw e;
            }
            catch (Exception e) {
                throw DbException.get(42000, e, this.triggerSource);
            }
        }
    }

    public void setTriggerClassName(String triggerClassName, boolean force) {
        this.setTriggerAction(triggerClassName, null, force);
    }

    public void setTriggerSource(String source, boolean force) {
        this.setTriggerAction(null, source, force);
    }

    private void setTriggerAction(String triggerClassName, String source, boolean force) {
        block2: {
            this.triggerClassName = triggerClassName;
            this.triggerSource = source;
            try {
                this.load();
            }
            catch (DbException e) {
                if (force) break block2;
                throw e;
            }
        }
    }

    public void fire(SessionLocal session, int type, boolean beforeAction) {
        if (this.rowBased || this.before != beforeAction || (this.typeMask & type) == 0) {
            return;
        }
        this.load();
        JdbcConnection c2 = session.createConnection(false);
        boolean old = false;
        if (type != 8) {
            old = session.setCommitOrRollbackDisabled(true);
        }
        Value identity = session.getLastIdentity();
        try {
            if (this.triggerCallback instanceof TriggerAdapter) {
                ((TriggerAdapter)this.triggerCallback).fire((Connection)c2, (ResultSet)null, (ResultSet)null);
            } else {
                this.triggerCallback.fire(c2, null, null);
            }
        }
        catch (Throwable e) {
            throw this.getErrorExecutingTrigger(e);
        }
        finally {
            session.setLastIdentity(identity);
            if (type != 8) {
                session.setCommitOrRollbackDisabled(old);
            }
        }
    }

    private static Object[] convertToObjectList(Row row, JdbcConnection conn) {
        if (row == null) {
            return null;
        }
        int len = row.getColumnCount();
        Object[] list = new Object[len];
        for (int i = 0; i < len; ++i) {
            list[i] = ValueToObjectConverter.valueToDefaultObject(row.getValue(i), conn, false);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireRow(SessionLocal session, Table table, Row oldRow, Row newRow, boolean beforeAction, boolean rollback) {
        block23: {
            if (!this.rowBased || this.before != beforeAction) {
                return false;
            }
            if (rollback && !this.onRollback) {
                return false;
            }
            this.load();
            boolean fire = false;
            if ((this.typeMask & 1) != 0 && oldRow == null && newRow != null) {
                fire = true;
            }
            if ((this.typeMask & 2) != 0 && oldRow != null && newRow != null) {
                fire = true;
            }
            if ((this.typeMask & 4) != 0 && oldRow != null && newRow == null) {
                fire = true;
            }
            if (!fire) {
                return false;
            }
            JdbcConnection c2 = session.createConnection(false);
            boolean old = session.getAutoCommit();
            boolean oldDisabled = session.setCommitOrRollbackDisabled(true);
            Value identity = session.getLastIdentity();
            try {
                session.setAutoCommit(false);
                if (this.triggerCallback instanceof TriggerAdapter) {
                    Value[] updatedList;
                    JdbcResultSet oldResultSet = oldRow != null ? TriggerObject.createResultSet(c2, table, oldRow, false) : null;
                    JdbcResultSet newResultSet = newRow != null ? TriggerObject.createResultSet(c2, table, newRow, this.before) : null;
                    try {
                        ((TriggerAdapter)this.triggerCallback).fire((Connection)c2, oldResultSet, newResultSet);
                    }
                    catch (Throwable e) {
                        throw this.getErrorExecutingTrigger(e);
                    }
                    if (newResultSet != null && (updatedList = newResultSet.getUpdateRow()) != null) {
                        boolean modified = false;
                        int l = updatedList.length;
                        for (int i = 0; i < l; ++i) {
                            Value v = updatedList[i];
                            if (v == null) continue;
                            modified = true;
                            newRow.setValue(i, v);
                        }
                        if (modified) {
                            table.convertUpdateRow(session, newRow, true);
                        }
                    }
                    break block23;
                }
                Object[] oldList = TriggerObject.convertToObjectList(oldRow, c2);
                Object[] newList = TriggerObject.convertToObjectList(newRow, c2);
                Object[] newListBackup = this.before && newList != null ? Arrays.copyOf(newList, newList.length) : null;
                try {
                    this.triggerCallback.fire(c2, oldList, newList);
                }
                catch (Throwable e) {
                    throw this.getErrorExecutingTrigger(e);
                }
                if (newListBackup != null) {
                    boolean modified = false;
                    for (int i = 0; i < newList.length; ++i) {
                        Object o = newList[i];
                        if (o == newListBackup[i]) continue;
                        modified = true;
                        newRow.setValue(i, ValueToObjectConverter.objectToValue(session, o, -1));
                    }
                    if (modified) {
                        table.convertUpdateRow(session, newRow, true);
                    }
                }
            }
            catch (Exception e) {
                if (this.onRollback) {
                    break block23;
                }
                throw DbException.convert(e);
            }
            finally {
                session.setLastIdentity(identity);
                session.setCommitOrRollbackDisabled(oldDisabled);
                session.setAutoCommit(old);
            }
        }
        return this.insteadOf;
    }

    private static JdbcResultSet createResultSet(JdbcConnection conn, Table table, Row row, boolean updatable) throws SQLException {
        SimpleResult result = new SimpleResult(table.getSchema().getName(), table.getName());
        for (Column c : table.getColumns()) {
            result.addColumn(c.getName(), c.getType());
        }
        result.addRow(row.getValueList());
        result.addRow(row.getValueList());
        JdbcResultSet resultSet = new JdbcResultSet(conn, null, null, (ResultInterface)result, -1, false, false, updatable);
        resultSet.next();
        return resultSet;
    }

    private DbException getErrorExecutingTrigger(Throwable e) {
        if (e instanceof DbException) {
            return (DbException)e;
        }
        if (e instanceof SQLException) {
            return DbException.convert(e);
        }
        return DbException.get(90044, e, this.getName(), this.triggerClassName != null ? this.triggerClassName : "..source..", e.toString());
    }

    public int getTypeMask() {
        return this.typeMask;
    }

    public void setTypeMask(int typeMask) {
        this.typeMask = typeMask;
    }

    public void setRowBased(boolean rowBased) {
        this.rowBased = rowBased;
    }

    public boolean isRowBased() {
        return this.rowBased;
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public void setOnRollback(boolean onRollback) {
        this.onRollback = onRollback;
    }

    public boolean isOnRollback() {
        return this.onRollback;
    }

    @Override
    public String getCreateSQLForCopy(Table targetTable, String quotedName) {
        StringBuilder builder = new StringBuilder("CREATE FORCE TRIGGER ");
        builder.append(quotedName);
        if (this.insteadOf) {
            builder.append(" INSTEAD OF ");
        } else if (this.before) {
            builder.append(" BEFORE ");
        } else {
            builder.append(" AFTER ");
        }
        this.getTypeNameList(builder).append(" ON ");
        targetTable.getSQL(builder, 0);
        if (this.rowBased) {
            builder.append(" FOR EACH ROW");
        }
        if (this.noWait) {
            builder.append(" NOWAIT");
        } else {
            builder.append(" QUEUE ").append(this.queueSize);
        }
        if (this.triggerClassName != null) {
            StringUtils.quoteStringSQL(builder.append(" CALL "), this.triggerClassName);
        } else {
            StringUtils.quoteStringSQL(builder.append(" AS "), this.triggerSource);
        }
        return builder.toString();
    }

    public StringBuilder getTypeNameList(StringBuilder builder) {
        boolean f = false;
        if ((this.typeMask & 1) != 0) {
            f = true;
            builder.append("INSERT");
        }
        if ((this.typeMask & 2) != 0) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("UPDATE");
        }
        if ((this.typeMask & 4) != 0) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("DELETE");
        }
        if ((this.typeMask & 8) != 0) {
            if (f) {
                builder.append(", ");
            }
            f = true;
            builder.append("SELECT");
        }
        if (this.onRollback) {
            if (f) {
                builder.append(", ");
            }
            builder.append("ROLLBACK");
        }
        return builder;
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(0));
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.table.removeTrigger(this);
        this.database.removeMeta(session, this.getId());
        if (this.triggerCallback != null) {
            try {
                this.triggerCallback.remove();
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
        this.table = null;
        this.triggerClassName = null;
        this.triggerSource = null;
        this.triggerCallback = null;
        this.invalidate();
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isBefore() {
        return this.before;
    }

    public String getTriggerClassName() {
        return this.triggerClassName;
    }

    public String getTriggerSource() {
        return this.triggerSource;
    }

    public void close() throws SQLException {
        if (this.triggerCallback != null) {
            this.triggerCallback.close();
        }
    }

    public boolean isSelectTrigger() {
        return (this.typeMask & 8) != 0;
    }
}

