/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import org.h2.command.ddl.SequenceOptions;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

public final class Sequence
extends SchemaObject {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long baseValue;
    private long margin;
    private TypeInfo dataType;
    private long increment;
    private long cacheSize;
    private long startValue;
    private long minValue;
    private long maxValue;
    private Cycle cycle;
    private boolean belongsToTable;
    private boolean writeWithMargin;

    public Sequence(SessionLocal session, Schema schema, int id, String name, SequenceOptions options, boolean belongsToTable) {
        super(schema, id, name, 9);
        boolean mayAdjustCacheSize;
        long cacheSize;
        long maxValue;
        this.dataType = options.getDataType();
        if (this.dataType == null) {
            this.dataType = session.getMode().decimalSequences ? TypeInfo.TYPE_NUMERIC_BIGINT : TypeInfo.TYPE_BIGINT;
            options.setDataType(this.dataType);
        }
        long[] bounds = options.getBounds();
        Long t = options.getIncrement(session);
        long increment = t != null ? t : 1L;
        Long start = options.getStartValue(session);
        Long min = options.getMinValue(null, session);
        Long max = options.getMaxValue(null, session);
        long minValue = min != null ? min : Sequence.getDefaultMinValue(start, increment, bounds);
        long l = maxValue = max != null ? max : Sequence.getDefaultMaxValue(start, increment, bounds);
        long startValue = start != null ? start : (increment >= 0L ? minValue : maxValue);
        Long restart = options.getRestartValue(session, startValue);
        long baseValue = restart != null ? restart : startValue;
        t = options.getCacheSize(session);
        if (t != null) {
            cacheSize = t;
            mayAdjustCacheSize = false;
        } else {
            cacheSize = 32L;
            mayAdjustCacheSize = true;
        }
        cacheSize = this.checkOptions(baseValue, startValue, minValue, maxValue, increment, cacheSize, mayAdjustCacheSize);
        Cycle cycle = options.getCycle();
        if (cycle == null) {
            cycle = Cycle.NO_CYCLE;
        } else if (cycle == Cycle.EXHAUSTED) {
            baseValue = startValue;
        }
        this.margin = this.baseValue = baseValue;
        this.increment = increment;
        this.cacheSize = cacheSize;
        this.startValue = startValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.cycle = cycle;
        this.belongsToTable = belongsToTable;
    }

    public synchronized void modify(Long baseValue, Long startValue, Long minValue, Long maxValue, Long increment, Cycle cycle, Long cacheSize) {
        boolean mayAdjustCacheSize;
        long cacheSizeAsLong;
        long incrementAsLong;
        long baseValueAsLong = baseValue != null ? baseValue : this.baseValue;
        long startValueAsLong = startValue != null ? startValue : this.startValue;
        long minValueAsLong = minValue != null ? minValue : this.minValue;
        long maxValueAsLong = maxValue != null ? maxValue : this.maxValue;
        long l = incrementAsLong = increment != null ? increment : this.increment;
        if (cacheSize != null) {
            cacheSizeAsLong = cacheSize;
            mayAdjustCacheSize = false;
        } else {
            cacheSizeAsLong = this.cacheSize;
            mayAdjustCacheSize = true;
        }
        cacheSizeAsLong = this.checkOptions(baseValueAsLong, startValueAsLong, minValueAsLong, maxValueAsLong, incrementAsLong, cacheSizeAsLong, mayAdjustCacheSize);
        if (cycle == null) {
            cycle = this.cycle;
            if (cycle == Cycle.EXHAUSTED && baseValue != null) {
                cycle = Cycle.NO_CYCLE;
            }
        } else if (cycle == Cycle.EXHAUSTED) {
            baseValueAsLong = startValueAsLong;
        }
        this.margin = this.baseValue = baseValueAsLong;
        this.startValue = startValueAsLong;
        this.minValue = minValueAsLong;
        this.maxValue = maxValueAsLong;
        this.increment = incrementAsLong;
        this.cacheSize = cacheSizeAsLong;
        this.cycle = cycle;
    }

    private long checkOptions(long baseValue, long startValue, long minValue, long maxValue, long increment, long cacheSize, boolean mayAdjustCacheSize) {
        if (minValue <= baseValue && baseValue <= maxValue && minValue <= startValue && startValue <= maxValue && minValue < maxValue && increment != 0L) {
            long range = maxValue - minValue;
            if (Long.compareUnsigned(Math.abs(increment), range) <= 0 && cacheSize >= 0L) {
                if (cacheSize <= 1L) {
                    return 1L;
                }
                long maxCacheSize = Sequence.getMaxCacheSize(range, increment);
                if (cacheSize <= maxCacheSize) {
                    return cacheSize;
                }
                if (mayAdjustCacheSize) {
                    return maxCacheSize;
                }
            }
        }
        throw DbException.get(90009, this.getName(), Long.toString(baseValue), Long.toString(startValue), Long.toString(minValue), Long.toString(maxValue), Long.toString(increment), Long.toString(cacheSize));
    }

    private static long getMaxCacheSize(long range, long increment) {
        if (increment > 0L) {
            if (range < 0L) {
                range = Long.MAX_VALUE;
            } else if ((range += increment) < 0L) {
                range = Long.MAX_VALUE;
            }
        } else if ((range = -range) > 0L) {
            range = Long.MIN_VALUE;
        } else if ((range += increment) >= 0L) {
            range = Long.MIN_VALUE;
        }
        return range / increment;
    }

    public static long getDefaultMinValue(Long startValue, long increment, long[] bounds) {
        long v;
        long l = v = increment >= 0L ? 1L : bounds[0];
        if (startValue != null && increment >= 0L && startValue < v) {
            v = startValue;
        }
        return v;
    }

    public static long getDefaultMaxValue(Long startValue, long increment, long[] bounds) {
        long v;
        long l = v = increment >= 0L ? bounds[1] : -1L;
        if (startValue != null && increment < 0L && startValue > v) {
            v = startValue;
        }
        return v;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public TypeInfo getDataType() {
        return this.dataType;
    }

    public int getEffectivePrecision() {
        TypeInfo dataType = this.dataType;
        switch (dataType.getValueType()) {
            case 13: {
                int p = (int)dataType.getPrecision();
                int s = dataType.getScale();
                if (p - s > 19) {
                    return 19 + s;
                }
                return p;
            }
            case 16: {
                return Math.min((int)dataType.getPrecision(), 19);
            }
        }
        return (int)dataType.getPrecision();
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public Cycle getCycle() {
        return this.cycle;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("DROP SEQUENCE IF EXISTS ");
        return this.getSQL(builder, 0).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCreateSQL() {
        StringBuilder builder = this.getSQL(new StringBuilder("CREATE SEQUENCE "), 0);
        if (this.dataType.getValueType() != 12) {
            this.dataType.getSQL(builder.append(" AS "), 0);
        }
        builder.append(' ');
        Sequence sequence = this;
        synchronized (sequence) {
            this.getSequenceOptionsSQL(builder, this.writeWithMargin ? this.margin : this.baseValue);
        }
        if (this.belongsToTable) {
            builder.append(" BELONGS_TO_TABLE");
        }
        return builder.toString();
    }

    public synchronized StringBuilder getSequenceOptionsSQL(StringBuilder builder) {
        return this.getSequenceOptionsSQL(builder, this.baseValue);
    }

    private StringBuilder getSequenceOptionsSQL(StringBuilder builder, long value) {
        builder.append("START WITH ").append(this.startValue);
        if (value != this.startValue && this.cycle != Cycle.EXHAUSTED) {
            builder.append(" RESTART WITH ").append(value);
        }
        if (this.increment != 1L) {
            builder.append(" INCREMENT BY ").append(this.increment);
        }
        long[] bounds = SequenceOptions.getBounds(this.dataType);
        if (this.minValue != Sequence.getDefaultMinValue(value, this.increment, bounds)) {
            builder.append(" MINVALUE ").append(this.minValue);
        }
        if (this.maxValue != Sequence.getDefaultMaxValue(value, this.increment, bounds)) {
            builder.append(" MAXVALUE ").append(this.maxValue);
        }
        if (this.cycle == Cycle.CYCLE) {
            builder.append(" CYCLE");
        } else if (this.cycle == Cycle.EXHAUSTED) {
            builder.append(" EXHAUSTED");
        }
        if (this.cacheSize != 32L) {
            if (this.cacheSize == 1L) {
                builder.append(" NO CACHE");
            } else if (this.cacheSize > 32L || this.cacheSize != Sequence.getMaxCacheSize(this.maxValue - this.minValue, this.increment)) {
                builder.append(" CACHE ").append(this.cacheSize);
            }
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getNext(SessionLocal session) {
        boolean needsFlush;
        long result;
        Sequence sequence = this;
        synchronized (sequence) {
            if (this.cycle == Cycle.EXHAUSTED) {
                throw DbException.get(90006, this.getName());
            }
            result = this.baseValue;
            long newBase = result + this.increment;
            needsFlush = this.increment > 0L ? this.increment(result, newBase) : this.decrement(result, newBase);
        }
        if (needsFlush) {
            this.flush(session);
        }
        return ValueBigint.get(result).castTo(this.dataType, session);
    }

    private boolean increment(long oldBase, long newBase) {
        boolean needsFlush = false;
        if (newBase > this.maxValue || ((oldBase ^ 0xFFFFFFFFFFFFFFFFL) & newBase) < 0L) {
            newBase = this.minValue;
            needsFlush = true;
            if (this.cycle == Cycle.CYCLE) {
                this.margin = newBase + this.increment * (this.cacheSize - 1L);
            } else {
                this.margin = newBase;
                this.cycle = Cycle.EXHAUSTED;
            }
        } else if (newBase > this.margin) {
            long newMargin = newBase + this.increment * (this.cacheSize - 1L);
            if (newMargin > this.maxValue || ((newBase ^ 0xFFFFFFFFFFFFFFFFL) & newMargin) < 0L) {
                newMargin = newBase;
            }
            this.margin = newMargin;
            needsFlush = true;
        }
        this.baseValue = newBase;
        return needsFlush;
    }

    private boolean decrement(long oldBase, long newBase) {
        boolean needsFlush = false;
        if (newBase < this.minValue || (oldBase & (newBase ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
            newBase = this.maxValue;
            needsFlush = true;
            if (this.cycle == Cycle.CYCLE) {
                this.margin = newBase + this.increment * (this.cacheSize - 1L);
            } else {
                this.margin = newBase;
                this.cycle = Cycle.EXHAUSTED;
            }
        } else if (newBase < this.margin) {
            long newMargin = newBase + this.increment * (this.cacheSize - 1L);
            if (newMargin < this.minValue || (newBase & (newMargin ^ 0xFFFFFFFFFFFFFFFFL)) < 0L) {
                newMargin = newBase;
            }
            this.margin = newMargin;
            needsFlush = true;
        }
        this.baseValue = newBase;
        return needsFlush;
    }

    public void flushWithoutMargin() {
        if (this.margin != this.baseValue) {
            this.margin = this.baseValue;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(SessionLocal session) {
        if (this.isTemporary()) {
            return;
        }
        if (session == null || !this.database.isSysTableLockedBy(session)) {
            SessionLocal sysSession;
            SessionLocal sessionLocal = sysSession = this.database.getSystemSession();
            synchronized (sessionLocal) {
                this.flushInternal(sysSession);
                sysSession.commit(false);
            }
        }
        SessionLocal sessionLocal = session;
        synchronized (sessionLocal) {
            this.flushInternal(session);
        }
    }

    private void flushInternal(SessionLocal session) {
        boolean metaWasLocked = this.database.lockMeta(session);
        try {
            this.writeWithMargin = true;
            this.database.updateMeta(session, this);
        }
        finally {
            this.writeWithMargin = false;
            if (!metaWasLocked) {
                this.database.unlockMeta(session);
            }
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    public synchronized long getBaseValue() {
        return this.baseValue;
    }

    public synchronized long getCurrentValue() {
        return this.baseValue - this.increment;
    }

    public void setBelongsToTable(boolean b) {
        this.belongsToTable = b;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public static enum Cycle {
        CYCLE,
        NO_CYCLE,
        EXHAUSTED;


        public boolean isCycle() {
            return this == CYCLE;
        }
    }
}

