/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.command.ddl.CreateSynonymData;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbSettings;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.FunctionAlias;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.schema.UserAggregate;
import org.h2.schema.UserDefinedFunction;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableLink;
import org.h2.table.TableSynonym;
import org.h2.util.Utils;

public class Schema
extends DbObject {
    private RightOwner owner;
    private final boolean system;
    private ArrayList<String> tableEngineParams;
    private final ConcurrentHashMap<String, Table> tablesAndViews;
    private final ConcurrentHashMap<String, Domain> domains;
    private final ConcurrentHashMap<String, TableSynonym> synonyms;
    private final ConcurrentHashMap<String, Index> indexes;
    private final ConcurrentHashMap<String, Sequence> sequences;
    private final ConcurrentHashMap<String, TriggerObject> triggers;
    private final ConcurrentHashMap<String, Constraint> constraints;
    private final ConcurrentHashMap<String, Constant> constants;
    private final ConcurrentHashMap<String, UserDefinedFunction> functionsAndAggregates;
    private final HashSet<String> temporaryUniqueNames = new HashSet();

    public Schema(Database database, int id, String schemaName, RightOwner owner, boolean system) {
        super(database, id, schemaName, 8);
        this.tablesAndViews = database.newConcurrentStringMap();
        this.domains = database.newConcurrentStringMap();
        this.synonyms = database.newConcurrentStringMap();
        this.indexes = database.newConcurrentStringMap();
        this.sequences = database.newConcurrentStringMap();
        this.triggers = database.newConcurrentStringMap();
        this.constraints = database.newConcurrentStringMap();
        this.constants = database.newConcurrentStringMap();
        this.functionsAndAggregates = database.newConcurrentStringMap();
        this.owner = owner;
        this.system = system;
    }

    public boolean canDrop() {
        return !this.system;
    }

    @Override
    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        StringBuilder builder = new StringBuilder("CREATE SCHEMA IF NOT EXISTS ");
        this.getSQL(builder, 0).append(" AUTHORIZATION ");
        this.owner.getSQL(builder, 0);
        return builder.toString();
    }

    @Override
    public int getType() {
        return 10;
    }

    public boolean isEmpty() {
        return this.tablesAndViews.isEmpty() && this.domains.isEmpty() && this.synonyms.isEmpty() && this.indexes.isEmpty() && this.sequences.isEmpty() && this.triggers.isEmpty() && this.constraints.isEmpty() && this.constants.isEmpty() && this.functionsAndAggregates.isEmpty();
    }

    @Override
    public ArrayList<DbObject> getChildren() {
        ArrayList<DbObject> children = Utils.newSmallArrayList();
        ArrayList<Right> rights = this.database.getAllRights();
        for (Right right : rights) {
            if (right.getGrantedObject() != this) continue;
            children.add(right);
        }
        return children;
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        this.removeChildrenFromMap(session, this.triggers);
        this.removeChildrenFromMap(session, this.constraints);
        boolean modified = true;
        while (!this.tablesAndViews.isEmpty()) {
            boolean newModified = false;
            for (Table obj : this.tablesAndViews.values()) {
                if (obj.getName() == null) continue;
                Table dependentTable = this.database.getDependentTable(obj, obj);
                if (dependentTable == null) {
                    this.database.removeSchemaObject(session, obj);
                    newModified = true;
                    continue;
                }
                if (dependentTable.getSchema() != this) {
                    throw DbException.get(90107, obj.getTraceSQL(), dependentTable.getTraceSQL());
                }
                if (modified) continue;
                dependentTable.removeColumnExpressionsDependencies(session);
                dependentTable.setModified();
                this.database.updateMeta(session, dependentTable);
            }
            modified = newModified;
        }
        this.removeChildrenFromMap(session, this.domains);
        this.removeChildrenFromMap(session, this.indexes);
        this.removeChildrenFromMap(session, this.sequences);
        this.removeChildrenFromMap(session, this.constants);
        this.removeChildrenFromMap(session, this.functionsAndAggregates);
        for (Right right : this.database.getAllRights()) {
            if (right.getGrantedObject() != this) continue;
            this.database.removeDatabaseObject(session, right);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    private void removeChildrenFromMap(SessionLocal session, ConcurrentHashMap<String, ? extends SchemaObject> map) {
        if (!map.isEmpty()) {
            for (SchemaObject schemaObject : map.values()) {
                if (!schemaObject.isValid()) continue;
                this.database.removeSchemaObject(session, schemaObject);
            }
        }
    }

    public RightOwner getOwner() {
        return this.owner;
    }

    public ArrayList<String> getTableEngineParams() {
        return this.tableEngineParams;
    }

    public void setTableEngineParams(ArrayList<String> tableEngineParams) {
        this.tableEngineParams = tableEngineParams;
    }

    private Map<String, SchemaObject> getMap(int type) {
        ConcurrentHashMap<String, SchemaObject> result;
        switch (type) {
            case 0: {
                result = this.tablesAndViews;
                break;
            }
            case 12: {
                result = this.domains;
                break;
            }
            case 15: {
                result = this.synonyms;
                break;
            }
            case 3: {
                result = this.sequences;
                break;
            }
            case 1: {
                result = this.indexes;
                break;
            }
            case 4: {
                result = this.triggers;
                break;
            }
            case 5: {
                result = this.constraints;
                break;
            }
            case 11: {
                result = this.constants;
                break;
            }
            case 9: 
            case 14: {
                result = this.functionsAndAggregates;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + type);
            }
        }
        return result;
    }

    public void add(SchemaObject obj) {
        if (obj.getSchema() != this) {
            throw DbException.getInternalError("wrong schema");
        }
        String name = obj.getName();
        Map<String, SchemaObject> map = this.getMap(obj.getType());
        if (map.putIfAbsent(name, obj) != null) {
            throw DbException.getInternalError("object already exists: " + name);
        }
        this.freeUniqueName(name);
    }

    public void rename(SchemaObject obj, String newName) {
        int type = obj.getType();
        Map<String, SchemaObject> map = this.getMap(type);
        if (SysProperties.CHECK) {
            if (!map.containsKey(obj.getName()) && !(obj instanceof MetaTable)) {
                throw DbException.getInternalError("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                throw DbException.getInternalError("object already exists: " + newName);
            }
        }
        obj.checkRename();
        map.remove(obj.getName());
        this.freeUniqueName(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.freeUniqueName(newName);
    }

    public Table findTableOrView(SessionLocal session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        return table;
    }

    public Table resolveTableOrView(SessionLocal session, String name) {
        TableSynonym synonym;
        Table table = this.findTableOrView(session, name);
        if (table == null && (synonym = this.synonyms.get(name)) != null) {
            return synonym.getSynonymFor();
        }
        return table;
    }

    public TableSynonym getSynonym(String name) {
        return this.synonyms.get(name);
    }

    public Domain findDomain(String name) {
        return this.domains.get(name);
    }

    public Index findIndex(SessionLocal session, String name) {
        Index index = this.indexes.get(name);
        if (index == null) {
            index = session.findLocalTempTableIndex(name);
        }
        return index;
    }

    public TriggerObject findTrigger(String name) {
        return this.triggers.get(name);
    }

    public Sequence findSequence(String sequenceName) {
        return this.sequences.get(sequenceName);
    }

    public Constraint findConstraint(SessionLocal session, String name) {
        Constraint constraint = this.constraints.get(name);
        if (constraint == null) {
            constraint = session.findLocalTempTableConstraint(name);
        }
        return constraint;
    }

    public Constant findConstant(String constantName) {
        return this.constants.get(constantName);
    }

    public FunctionAlias findFunction(String functionAlias) {
        UserDefinedFunction userDefinedFunction = this.findFunctionOrAggregate(functionAlias);
        return userDefinedFunction instanceof FunctionAlias ? (FunctionAlias)userDefinedFunction : null;
    }

    public UserAggregate findAggregate(String name) {
        UserDefinedFunction userDefinedFunction = this.findFunctionOrAggregate(name);
        return userDefinedFunction instanceof UserAggregate ? (UserAggregate)userDefinedFunction : null;
    }

    public UserDefinedFunction findFunctionOrAggregate(String name) {
        return this.functionsAndAggregates.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserveUniqueName(String name) {
        if (name != null) {
            HashSet<String> hashSet = this.temporaryUniqueNames;
            synchronized (hashSet) {
                this.temporaryUniqueNames.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUniqueName(String name) {
        if (name != null) {
            HashSet<String> hashSet = this.temporaryUniqueNames;
            synchronized (hashSet) {
                this.temporaryUniqueNames.remove(name);
            }
        }
    }

    private String getUniqueName(DbObject obj, Map<String, ? extends SchemaObject> map, String prefix) {
        StringBuilder nameBuilder = new StringBuilder(prefix);
        String hash = Integer.toHexString(obj.getName().hashCode());
        HashSet<String> hashSet = this.temporaryUniqueNames;
        synchronized (hashSet) {
            int len = hash.length();
            for (int i = 0; i < len; ++i) {
                char c = hash.charAt(i);
                String name = nameBuilder.append(c >= 'a' ? (char)(c - 32) : c).toString();
                if (map.containsKey(name) || !this.temporaryUniqueNames.add(name)) continue;
                return name;
            }
            int nameLength = nameBuilder.append('_').length();
            int i = 0;
            while (true) {
                String name;
                if (!map.containsKey(name = nameBuilder.append(i).toString()) && this.temporaryUniqueNames.add(name)) {
                    return name;
                }
                nameBuilder.setLength(nameLength);
                ++i;
            }
        }
    }

    public String getUniqueConstraintName(SessionLocal session, Table table) {
        AbstractMap tableConstraints = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableConstraints() : this.constraints;
        return this.getUniqueName(table, tableConstraints, "CONSTRAINT_");
    }

    public String getUniqueDomainConstraintName(SessionLocal session, Domain domain) {
        return this.getUniqueName(domain, this.constraints, "CONSTRAINT_");
    }

    public String getUniqueIndexName(SessionLocal session, Table table, String prefix) {
        AbstractMap tableIndexes = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableIndexes() : this.indexes;
        return this.getUniqueName(table, tableIndexes, prefix);
    }

    public Table getTableOrView(SessionLocal session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null) {
            if (session != null) {
                table = session.findLocalTempTable(name);
            }
            if (table == null) {
                throw DbException.get(42102, name);
            }
        }
        return table;
    }

    public Domain getDomain(String name) {
        Domain domain = this.domains.get(name);
        if (domain == null) {
            throw DbException.get(90120, name);
        }
        return domain;
    }

    public Index getIndex(String name) {
        Index index = this.indexes.get(name);
        if (index == null) {
            throw DbException.get(42112, name);
        }
        return index;
    }

    public Constraint getConstraint(String name) {
        Constraint constraint = this.constraints.get(name);
        if (constraint == null) {
            throw DbException.get(90057, name);
        }
        return constraint;
    }

    public Constant getConstant(String constantName) {
        Constant constant = this.constants.get(constantName);
        if (constant == null) {
            throw DbException.get(90115, constantName);
        }
        return constant;
    }

    public Sequence getSequence(String sequenceName) {
        Sequence sequence = this.sequences.get(sequenceName);
        if (sequence == null) {
            throw DbException.get(90036, sequenceName);
        }
        return sequence;
    }

    public ArrayList<SchemaObject> getAll(ArrayList<SchemaObject> addTo) {
        if (addTo == null) {
            addTo = Utils.newSmallArrayList();
        }
        addTo.addAll(this.tablesAndViews.values());
        addTo.addAll(this.domains.values());
        addTo.addAll(this.synonyms.values());
        addTo.addAll(this.sequences.values());
        addTo.addAll(this.indexes.values());
        addTo.addAll(this.triggers.values());
        addTo.addAll(this.constraints.values());
        addTo.addAll(this.constants.values());
        addTo.addAll(this.functionsAndAggregates.values());
        return addTo;
    }

    public void getAll(int type, ArrayList<SchemaObject> addTo) {
        addTo.addAll(this.getMap(type).values());
    }

    public Collection<Domain> getAllDomains() {
        return this.domains.values();
    }

    public Collection<Constraint> getAllConstraints() {
        return this.constraints.values();
    }

    public Collection<Constant> getAllConstants() {
        return this.constants.values();
    }

    public Collection<Sequence> getAllSequences() {
        return this.sequences.values();
    }

    public Collection<TriggerObject> getAllTriggers() {
        return this.triggers.values();
    }

    public Collection<Table> getAllTablesAndViews(SessionLocal session) {
        return this.tablesAndViews.values();
    }

    public Collection<Index> getAllIndexes() {
        return this.indexes.values();
    }

    public Collection<TableSynonym> getAllSynonyms() {
        return this.synonyms.values();
    }

    public Collection<UserDefinedFunction> getAllFunctionsAndAggregates() {
        return this.functionsAndAggregates.values();
    }

    public Table getTableOrViewByName(SessionLocal session, String name) {
        return this.tablesAndViews.get(name);
    }

    public void remove(SchemaObject obj) {
        String objName = obj.getName();
        Map<String, SchemaObject> map = this.getMap(obj.getType());
        if (map.remove(objName) == null) {
            throw DbException.getInternalError("not found: " + objName);
        }
        this.freeUniqueName(objName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table createTable(CreateTableData data) {
        Database database = this.database;
        synchronized (database) {
            if (!data.temporary || data.globalTemporary) {
                this.database.lockMeta(data.session);
            }
            data.schema = this;
            String tableEngine = data.tableEngine;
            if (tableEngine == null) {
                DbSettings s = this.database.getSettings();
                tableEngine = s.defaultTableEngine;
                if (tableEngine == null) {
                    return this.database.getStore().createTable(data);
                }
                data.tableEngine = tableEngine;
            }
            if (data.tableEngineParams == null) {
                data.tableEngineParams = this.tableEngineParams;
            }
            return this.database.getTableEngine(tableEngine).createTable(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableSynonym createSynonym(CreateSynonymData data) {
        Database database = this.database;
        synchronized (database) {
            this.database.lockMeta(data.session);
            data.schema = this;
            return new TableSynonym(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableLink createTableLink(int id, String tableName, String driver, String url, String user, String password, String originalSchema, String originalTable, boolean emitUpdates, boolean force) {
        Database database = this.database;
        synchronized (database) {
            return new TableLink(this, id, tableName, driver, url, user, password, originalSchema, originalTable, emitUpdates, force);
        }
    }
}

