/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.DefaultRow;
import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

public final class Sparse
extends DefaultRow {
    private final int columnCount;
    private final int[] map;

    Sparse(int columnCount, int capacity, int[] map) {
        super(new Value[capacity]);
        this.columnCount = columnCount;
        this.map = map;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Value getValue(int i) {
        if (i == -1) {
            return ValueBigint.get(this.getKey());
        }
        int index = this.map[i];
        return index > 0 ? super.getValue(index - 1) : null;
    }

    @Override
    public void setValue(int i, Value v) {
        int index;
        if (i == -1) {
            this.setKey(v.getLong());
        }
        if ((index = this.map[i]) > 0) {
            super.setValue(index - 1, v);
        }
    }

    @Override
    public void copyFrom(SearchRow source) {
        this.setKey(source.getKey());
        for (int i = 0; i < this.map.length; ++i) {
            int index = this.map[i];
            if (index <= 0) continue;
            super.setValue(index - 1, source.getValue(i));
        }
    }
}

