/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

public class DefaultRow
extends Row {
    public static final int MEMORY_CALCULATE = -1;
    protected final Value[] data;
    private int memory;

    DefaultRow(int columnCount) {
        this.data = new Value[columnCount];
        this.memory = -1;
    }

    public DefaultRow(Value[] data) {
        this.data = data;
        this.memory = -1;
    }

    public DefaultRow(Value[] data, int memory) {
        this.data = data;
        this.memory = memory;
    }

    @Override
    public Value getValue(int i) {
        return i == -1 ? ValueBigint.get(this.key) : this.data[i];
    }

    @Override
    public void setValue(int i, Value v) {
        if (i == -1) {
            this.key = v.getLong();
        } else {
            this.data[i] = v;
        }
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        this.memory = this.calculateMemory();
        return this.memory;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("( /* key:").append(this.key).append(" */ ");
        int length = this.data.length;
        for (int i = 0; i < length; ++i) {
            Value v;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((v = this.data[i]) == null ? "null" : v.getTraceSQL());
        }
        return builder.append(')').toString();
    }

    protected int calculateMemory() {
        int m = 64 + this.data.length * 8;
        for (Value v : this.data) {
            if (v == null) continue;
            m += v.getMemory();
        }
        return m;
    }

    @Override
    public Value[] getValueList() {
        return this.data;
    }

    @Override
    public boolean hasSharedData(Row other) {
        return other instanceof DefaultRow && this.data == ((DefaultRow)other).data;
    }

    @Override
    public void copyFrom(SearchRow source) {
        this.setKey(source.getKey());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.setValue(i, source.getValue(i));
        }
    }
}

