/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;

public abstract class BasicDataType<T>
implements DataType<T> {
    @Override
    public abstract int getMemory(T var1);

    @Override
    public abstract void write(WriteBuffer var1, T var2);

    @Override
    public abstract T read(ByteBuffer var1);

    @Override
    public int compare(T a, T b) {
        throw DataUtils.newUnsupportedOperationException("Can not compare");
    }

    @Override
    public boolean isMemoryEstimationAllowed() {
        return true;
    }

    @Override
    public int binarySearch(T key, Object storageObj, int size, int initialGuess) {
        T[] storage = this.cast(storageObj);
        int low = 0;
        int high = size - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        while (low <= high) {
            int compare = this.compare(key, storage[x]);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return ~low;
    }

    @Override
    public void write(WriteBuffer buff, Object storage, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, this.cast(storage)[i]);
        }
    }

    @Override
    public void read(ByteBuffer buff, Object storage, int len) {
        for (int i = 0; i < len; ++i) {
            this.cast((Object)storage)[i] = this.read(buff);
        }
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass().equals(obj.getClass());
    }

    protected final T[] cast(Object storage) {
        return (Object[])storage;
    }
}

