/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import java.nio.ByteBuffer;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.tx.VersionedValueCommitted;
import org.h2.mvstore.tx.VersionedValueUncommitted;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.MetaType;
import org.h2.mvstore.type.StatefulDataType;
import org.h2.value.VersionedValue;

public class VersionedValueType<T, D>
extends BasicDataType<VersionedValue<T>>
implements StatefulDataType<D> {
    private final DataType<T> valueType;
    private final Factory<D> factory = new Factory();

    public VersionedValueType(DataType<T> valueType) {
        this.valueType = valueType;
    }

    public VersionedValue<T>[] createStorage(int size) {
        return new VersionedValue[size];
    }

    @Override
    public int getMemory(VersionedValue<T> v) {
        if (v == null) {
            return 0;
        }
        int res = 48 + this.getValMemory(v.getCurrentValue());
        if (v.getOperationId() != 0L) {
            res += this.getValMemory(v.getCommittedValue());
        }
        return res;
    }

    private int getValMemory(T obj) {
        return obj == null ? 0 : this.valueType.getMemory(obj);
    }

    @Override
    public void read(ByteBuffer buff, Object storage, int len) {
        if (buff.get() == 0) {
            for (int i = 0; i < len; ++i) {
                ((VersionedValue[])this.cast((Object)storage))[i] = VersionedValueCommitted.getInstance(this.valueType.read(buff));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                ((VersionedValue[])this.cast((Object)storage))[i] = this.read(buff);
            }
        }
    }

    @Override
    public VersionedValue<T> read(ByteBuffer buff) {
        long operationId = DataUtils.readVarLong(buff);
        if (operationId == 0L) {
            return VersionedValueCommitted.getInstance(this.valueType.read(buff));
        }
        byte flags = buff.get();
        Object value = (flags & 1) != 0 ? (Object)this.valueType.read(buff) : null;
        Object committedValue = (flags & 2) != 0 ? (Object)this.valueType.read(buff) : null;
        return VersionedValueUncommitted.getInstance(operationId, value, committedValue);
    }

    @Override
    public void write(WriteBuffer buff, Object storage, int len) {
        VersionedValue v;
        int i;
        boolean fastPath = true;
        for (i = 0; i < len; ++i) {
            v = ((VersionedValue[])this.cast(storage))[i];
            if (v.getOperationId() == 0L && v.getCurrentValue() != null) continue;
            fastPath = false;
        }
        if (fastPath) {
            buff.put((byte)0);
            for (i = 0; i < len; ++i) {
                v = ((VersionedValue[])this.cast(storage))[i];
                this.valueType.write(buff, v.getCurrentValue());
            }
        } else {
            buff.put((byte)1);
            for (i = 0; i < len; ++i) {
                this.write(buff, ((VersionedValue[])this.cast(storage))[i]);
            }
        }
    }

    @Override
    public void write(WriteBuffer buff, VersionedValue<T> v) {
        long operationId = v.getOperationId();
        buff.putVarLong(operationId);
        if (operationId == 0L) {
            this.valueType.write(buff, v.getCurrentValue());
        } else {
            T committedValue = v.getCommittedValue();
            int flags = (v.getCurrentValue() == null ? 0 : 1) | (committedValue == null ? 0 : 2);
            buff.put((byte)flags);
            if (v.getCurrentValue() != null) {
                this.valueType.write(buff, v.getCurrentValue());
            }
            if (committedValue != null) {
                this.valueType.write(buff, committedValue);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VersionedValueType)) {
            return false;
        }
        VersionedValueType other = (VersionedValueType)obj;
        return this.valueType.equals(other.valueType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.valueType.hashCode();
    }

    @Override
    public void save(WriteBuffer buff, MetaType<D> metaType) {
        metaType.write(buff, this.valueType);
    }

    @Override
    public int compare(VersionedValue<T> a, VersionedValue<T> b) {
        return this.valueType.compare(a.getCurrentValue(), b.getCurrentValue());
    }

    @Override
    public Factory<D> getFactory() {
        return this.factory;
    }

    public static final class Factory<D>
    implements StatefulDataType.Factory<D> {
        @Override
        public DataType<?> create(ByteBuffer buff, MetaType<D> metaType, D database) {
            Object valueType = metaType.read(buff);
            return new VersionedValueType(valueType);
        }
    }
}

