/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.h2.engine.IsolationLevel;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.SpatialDataType;
import org.h2.mvstore.tx.CommitDecisionMaker;
import org.h2.mvstore.tx.Record;
import org.h2.mvstore.tx.RollbackDecisionMaker;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.tx.VersionedBitSet;
import org.h2.mvstore.tx.VersionedValueType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.LongDataType;
import org.h2.mvstore.type.MetaType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.StringUtils;
import org.h2.value.VersionedValue;

public class TransactionStore {
    final MVStore store;
    final int timeoutMillis;
    private final MVMap<Integer, Object[]> preparedTransactions;
    private final MVMap<String, DataType<?>> typeRegistry;
    final MVMap<Long, Record<?, ?>>[] undoLogs = new MVMap[65535];
    private final MVMap.Builder<Long, Record<?, ?>> undoLogBuilder;
    private final DataType<?> dataType;
    final AtomicReference<VersionedBitSet> openTransactions = new AtomicReference<VersionedBitSet>(new VersionedBitSet());
    final AtomicReference<BitSet> committingTransactions = new AtomicReference<BitSet>(new BitSet());
    private boolean init;
    private int maxTransactionId = 65535;
    private final AtomicReferenceArray<Transaction> transactions = new AtomicReferenceArray(65536);
    private static final String TYPE_REGISTRY_NAME = "_";
    public static final String UNDO_LOG_NAME_PREFIX = "undoLog";
    private static final char UNDO_LOG_COMMITTED = '-';
    private static final char UNDO_LOG_OPEN = '.';
    private static final int MAX_OPEN_TRANSACTIONS = 65535;
    private static final int LOG_ID_BITS = 40;
    private static final long LOG_ID_MASK = 0xFFFFFFFFFFL;
    private static final RollbackListener ROLLBACK_LISTENER_NONE = (map, key, existingValue, restoredValue) -> {};

    private static String getUndoLogName(int transactionId) {
        return transactionId > 0 ? "undoLog." + transactionId : "undoLog.";
    }

    public TransactionStore(MVStore store) {
        this(store, new ObjectDataType());
    }

    public TransactionStore(MVStore store, DataType<?> dataType) {
        this(store, new MetaType<Object>(null, store.backgroundExceptionHandler), dataType, 0);
    }

    public TransactionStore(MVStore store, MetaType<?> metaDataType, DataType<?> dataType, int timeoutMillis) {
        this.store = store;
        this.dataType = dataType;
        this.timeoutMillis = timeoutMillis;
        this.typeRegistry = TransactionStore.openTypeRegistry(store, metaDataType);
        this.preparedTransactions = store.openMap("openTransactions", new MVMap.Builder());
        this.undoLogBuilder = this.createUndoLogBuilder();
    }

    MVMap.Builder<Long, Record<?, ?>> createUndoLogBuilder() {
        return ((MVMap.Builder)new MVMap.Builder().singleWriter().keyType((DataType)LongDataType.INSTANCE)).valueType((DataType)new Record.Type(this));
    }

    private static MVMap<String, DataType<?>> openTypeRegistry(MVStore store, MetaType<?> metaDataType) {
        MVMap.BasicBuilder typeRegistryBuilder = ((MVMap.Builder)new MVMap.Builder().keyType((DataType)StringDataType.INSTANCE)).valueType(metaDataType);
        return store.openMap(TYPE_REGISTRY_NAME, typeRegistryBuilder);
    }

    public void init() {
        this.init(ROLLBACK_LISTENER_NONE);
    }

    public void init(RollbackListener listener) {
        if (!this.init) {
            for (String mapName : this.store.getMapNames()) {
                if (!mapName.startsWith(UNDO_LOG_NAME_PREFIX)) continue;
                if (mapName.length() > UNDO_LOG_NAME_PREFIX.length()) {
                    boolean committed;
                    boolean bl = committed = mapName.charAt(UNDO_LOG_NAME_PREFIX.length()) == '-';
                    if (this.store.hasData(mapName)) {
                        int transactionId = StringUtils.parseUInt31(mapName, UNDO_LOG_NAME_PREFIX.length() + 1, mapName.length());
                        VersionedBitSet openTxBitSet = this.openTransactions.get();
                        if (!openTxBitSet.get(transactionId)) {
                            String name;
                            int status;
                            Object[] data = this.preparedTransactions.get(transactionId);
                            if (data == null) {
                                status = 1;
                                name = null;
                            } else {
                                status = (Integer)data[0];
                                name = (String)data[1];
                            }
                            Object undoLog = this.store.openMap(mapName, this.undoLogBuilder);
                            this.undoLogs[transactionId] = undoLog;
                            Long lastUndoKey = (Long)((MVMap)undoLog).lastKey();
                            assert (lastUndoKey != null);
                            assert (TransactionStore.getTransactionId(lastUndoKey) == transactionId);
                            long logId = TransactionStore.getLogId(lastUndoKey) + 1L;
                            if (committed) {
                                this.store.renameMap((MVMap<?, ?>)undoLog, TransactionStore.getUndoLogName(transactionId));
                                this.markUndoLogAsCommitted(transactionId);
                            } else {
                                boolean bl2 = committed = logId > 0xFFFFFFFFFFL;
                            }
                            if (committed) {
                                status = 3;
                                lastUndoKey = ((MVMap)undoLog).lowerKey((Long)lastUndoKey);
                                assert (lastUndoKey == null || TransactionStore.getTransactionId(lastUndoKey) == transactionId);
                                logId = lastUndoKey == null ? 0L : TransactionStore.getLogId(lastUndoKey) + 1L;
                            }
                            this.registerTransaction(transactionId, status, name, logId, this.timeoutMillis, 0, IsolationLevel.READ_COMMITTED, listener);
                            continue;
                        }
                    }
                }
                if (this.store.isReadOnly()) continue;
                this.store.removeMap(mapName);
            }
            this.init = true;
        }
    }

    private void markUndoLogAsCommitted(int transactionId) {
        this.addUndoLogRecord(transactionId, 0xFFFFFFFFFFL, Record.COMMIT_MARKER);
    }

    public void endLeftoverTransactions() {
        List<Transaction> list = this.getOpenTransactions();
        for (Transaction t : list) {
            int status = t.getStatus();
            if (status == 3) {
                t.commit();
                continue;
            }
            if (status == 2) continue;
            t.rollback();
        }
    }

    int getMaxTransactionId() {
        return this.maxTransactionId;
    }

    public void setMaxTransactionId(int max) {
        DataUtils.checkArgument(max <= 65535, "Concurrent transactions limit is too high: {0}", max);
        this.maxTransactionId = max;
    }

    public boolean hasMap(String name) {
        return this.store.hasMap(name);
    }

    static long getOperationId(int transactionId, long logId) {
        DataUtils.checkArgument(transactionId >= 0 && transactionId < 0x1000000, "Transaction id out of range: {0}", transactionId);
        DataUtils.checkArgument(logId >= 0L && logId <= 0xFFFFFFFFFFL, "Transaction log id out of range: {0}", logId);
        return (long)transactionId << 40 | logId;
    }

    static int getTransactionId(long operationId) {
        return (int)(operationId >>> 40);
    }

    static long getLogId(long operationId) {
        return operationId & 0xFFFFFFFFFFL;
    }

    public List<Transaction> getOpenTransactions() {
        if (!this.init) {
            this.init();
        }
        ArrayList<Transaction> list = new ArrayList<Transaction>();
        int transactionId = 0;
        BitSet bitSet = this.openTransactions.get();
        while ((transactionId = bitSet.nextSetBit(transactionId + 1)) > 0) {
            Transaction transaction = this.getTransaction(transactionId);
            if (transaction == null || transaction.getStatus() == 0) continue;
            list.add(transaction);
        }
        return list;
    }

    public synchronized void close() {
        this.store.commit();
    }

    public Transaction begin() {
        return this.begin(ROLLBACK_LISTENER_NONE, this.timeoutMillis, 0, IsolationLevel.READ_COMMITTED);
    }

    public Transaction begin(RollbackListener listener, int timeoutMillis, int ownerId, IsolationLevel isolationLevel) {
        Transaction transaction = this.registerTransaction(0, 1, null, 0L, timeoutMillis, ownerId, isolationLevel, listener);
        return transaction;
    }

    private Transaction registerTransaction(int txId, int status, String name, long logId, int timeoutMillis, int ownerId, IsolationLevel isolationLevel, RollbackListener listener) {
        long sequenceNo;
        int transactionId;
        VersionedBitSet clone;
        VersionedBitSet original;
        boolean success;
        do {
            original = this.openTransactions.get();
            if (txId == 0) {
                transactionId = original.nextClearBit(1);
            } else {
                transactionId = txId;
                assert (!original.get(transactionId));
            }
            if (transactionId > this.maxTransactionId) {
                throw DataUtils.newMVStoreException(102, "There are {0} open transactions", transactionId - 1);
            }
            clone = original.clone();
            clone.set(transactionId);
            sequenceNo = clone.getVersion() + 1L;
            clone.setVersion(sequenceNo);
        } while (!(success = this.openTransactions.compareAndSet(original, clone)));
        Transaction transaction = new Transaction(this, transactionId, sequenceNo, status, name, logId, timeoutMillis, ownerId, isolationLevel, listener);
        assert (this.transactions.get(transactionId) == null);
        this.transactions.set(transactionId, transaction);
        if (this.undoLogs[transactionId] == null) {
            String undoName = TransactionStore.getUndoLogName(transactionId);
            Object undoLog = this.store.openMap(undoName, this.undoLogBuilder);
            this.undoLogs[transactionId] = undoLog;
        }
        return transaction;
    }

    void storeTransaction(Transaction t) {
        if (t.getStatus() == 2 || t.getName() != null) {
            Object[] v = new Object[]{t.getStatus(), t.getName()};
            this.preparedTransactions.put(t.getId(), v);
            t.wasStored = true;
        }
    }

    long addUndoLogRecord(int transactionId, long logId, Record<?, ?> record) {
        MVMap<Long, Record<?, ?>> undoLog = this.undoLogs[transactionId];
        long undoKey = TransactionStore.getOperationId(transactionId, logId);
        if (logId == 0L && !undoLog.isEmpty()) {
            throw DataUtils.newMVStoreException(102, "An old transaction with the same id is still open: {0}", transactionId);
        }
        undoLog.append(undoKey, record);
        return undoKey;
    }

    void removeUndoLogRecord(int transactionId) {
        this.undoLogs[transactionId].trimLast();
    }

    void removeMap(TransactionMap<?, ?> map) {
        this.store.removeMap(map.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(Transaction t, boolean recovery) {
        if (!this.store.isClosed()) {
            Cursor<Object, Record<?, ?>> cursor;
            int transactionId = t.transactionId;
            MVMap<Long, Record<?, ?>> undoLog = this.undoLogs[transactionId];
            if (recovery) {
                this.removeUndoLogRecord(transactionId);
                cursor = undoLog.cursor(null);
            } else {
                cursor = undoLog.cursor(null);
                this.markUndoLogAsCommitted(transactionId);
            }
            this.flipCommittingTransactionsBit(transactionId, true);
            CommitDecisionMaker commitDecisionMaker = new CommitDecisionMaker();
            try {
                while (cursor.hasNext()) {
                    Long undoKey = cursor.next();
                    Record<?, ?> op = cursor.getValue();
                    int mapId = op.mapId;
                    MVMap map = this.openMap(mapId);
                    if (map == null || map.isClosed()) continue;
                    Object key = op.key;
                    commitDecisionMaker.setUndoKey(undoKey);
                    map.operate(key, null, commitDecisionMaker);
                }
            }
            finally {
                try {
                    undoLog.clear();
                }
                finally {
                    this.flipCommittingTransactionsBit(transactionId, false);
                }
            }
        }
    }

    private void flipCommittingTransactionsBit(int transactionId, boolean flag) {
        BitSet clone;
        BitSet original;
        boolean success;
        do {
            original = this.committingTransactions.get();
            assert (original.get(transactionId) != flag) : flag ? "Double commit" : "Mysterious bit's disappearance";
            clone = (BitSet)original.clone();
            clone.set(transactionId, flag);
        } while (!(success = this.committingTransactions.compareAndSet(original, clone)));
    }

    <K, V> MVMap<K, VersionedValue<V>> openVersionedMap(String name, DataType<K> keyType, DataType<V> valueType) {
        VersionedValueType vt = valueType == null ? null : new VersionedValueType(valueType);
        return this.openMap(name, keyType, vt);
    }

    public <K, V> MVMap<K, V> openMap(String name, DataType<K> keyType, DataType<V> valueType) {
        return this.store.openMap(name, ((MVMap.Builder)new TxMapBuilder(this.typeRegistry, this.dataType).keyType(keyType)).valueType(valueType));
    }

    <K, V> MVMap<K, VersionedValue<V>> openMap(int mapId) {
        MVMap map = this.store.getMap(mapId);
        if (map == null) {
            String mapName = this.store.getMapName(mapId);
            if (mapName == null) {
                return null;
            }
            TxMapBuilder txMapBuilder = new TxMapBuilder(this.typeRegistry, this.dataType);
            map = this.store.openMap(mapId, txMapBuilder);
        }
        return map;
    }

    <K, V> MVMap<K, VersionedValue<V>> getMap(int mapId) {
        MVMap map = this.store.getMap(mapId);
        if (map == null && !this.init) {
            map = this.openMap(mapId);
        }
        assert (map != null) : "map with id " + mapId + " is missing" + (this.init ? "" : " during initialization");
        return map;
    }

    void endTransaction(Transaction t, boolean hasChanges) {
        VersionedBitSet clone;
        VersionedBitSet original;
        boolean success;
        t.closeIt();
        int txId = t.transactionId;
        this.transactions.set(txId, null);
        do {
            original = this.openTransactions.get();
            assert (original.get(txId));
            clone = original.clone();
            clone.clear(txId);
        } while (!(success = this.openTransactions.compareAndSet(original, clone)));
        if (hasChanges) {
            boolean wasStored = t.wasStored;
            if (wasStored && !this.preparedTransactions.isClosed()) {
                this.preparedTransactions.remove(txId);
            }
            if (this.store.isVersioningRequired()) {
                int max;
                int unsaved;
                if (wasStored || this.store.getAutoCommitDelay() == 0) {
                    this.store.commit();
                } else if (this.isUndoEmpty() && (unsaved = this.store.getUnsavedMemory()) * 4 > (max = this.store.getAutoCommitMemory()) * 3) {
                    this.store.tryCommit();
                }
            }
        }
    }

    RootReference<Long, Record<?, ?>>[] collectUndoLogRootReferences() {
        BitSet opentransactions = this.openTransactions.get();
        RootReference[] undoLogRootReferences = new RootReference[opentransactions.length()];
        int i = opentransactions.nextSetBit(0);
        while (i >= 0) {
            MVMap<Long, Record<?, ?>> undoLog = this.undoLogs[i];
            if (undoLog != null) {
                RootReference<Long, Record<?, ?>> rootReference = undoLog.getRoot();
                if (rootReference.needFlush()) {
                    return null;
                }
                undoLogRootReferences[i] = rootReference;
            }
            i = opentransactions.nextSetBit(i + 1);
        }
        return undoLogRootReferences;
    }

    static long calculateUndoLogsTotalSize(RootReference<Long, Record<?, ?>>[] undoLogRootReferences) {
        long undoLogsTotalSize = 0L;
        for (RootReference<Long, Record<?, ?>> rootReference : undoLogRootReferences) {
            if (rootReference == null) continue;
            undoLogsTotalSize += rootReference.getTotalCount();
        }
        return undoLogsTotalSize;
    }

    private boolean isUndoEmpty() {
        BitSet openTrans = this.openTransactions.get();
        int i = openTrans.nextSetBit(0);
        while (i >= 0) {
            MVMap<Long, Record<?, ?>> undoLog = this.undoLogs[i];
            if (undoLog != null && !undoLog.isEmpty()) {
                return false;
            }
            i = openTrans.nextSetBit(i + 1);
        }
        return true;
    }

    Transaction getTransaction(int transactionId) {
        return this.transactions.get(transactionId);
    }

    void rollbackTo(Transaction t, long maxLogId, long toLogId) {
        int transactionId = t.getId();
        MVMap<Long, Record<?, ?>> undoLog = this.undoLogs[transactionId];
        RollbackDecisionMaker decisionMaker = new RollbackDecisionMaker(this, transactionId, toLogId, t.listener);
        for (long logId = maxLogId - 1L; logId >= toLogId; --logId) {
            Long undoKey = TransactionStore.getOperationId(transactionId, logId);
            undoLog.operate(undoKey, null, decisionMaker);
            decisionMaker.reset();
        }
    }

    Iterator<Change> getChanges(final Transaction t, final long maxLogId, final long toLogId) {
        final MVMap<Long, Record<?, ?>> undoLog = this.undoLogs[t.getId()];
        return new Iterator<Change>(){
            private long logId;
            private Change current;
            {
                this.logId = maxLogId - 1L;
            }

            private void fetchNext() {
                int transactionId = t.getId();
                while (this.logId >= toLogId) {
                    Long undoKey = TransactionStore.getOperationId(transactionId, this.logId);
                    Record op = (Record)undoLog.get(undoKey);
                    --this.logId;
                    if (op == null) {
                        if ((undoKey = undoLog.floorKey(undoKey)) == null || TransactionStore.getTransactionId(undoKey) != transactionId) break;
                        this.logId = TransactionStore.getLogId(undoKey);
                        continue;
                    }
                    int mapId = op.mapId;
                    MVMap m = TransactionStore.this.openMap(mapId);
                    if (m == null) continue;
                    VersionedValue oldValue = op.oldValue;
                    this.current = new Change(m.getName(), op.key, oldValue == null ? null : oldValue.getCurrentValue());
                    return;
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    this.fetchNext();
                }
                return this.current != null;
            }

            @Override
            public Change next() {
                if (!this.hasNext()) {
                    throw DataUtils.newUnsupportedOperationException("no data");
                }
                Change result = this.current;
                this.current = null;
                return result;
            }
        };
    }

    private static final class TxMapBuilder<K, V>
    extends MVMap.Builder<K, V> {
        private final MVMap<String, DataType<?>> typeRegistry;
        private final DataType defaultDataType;

        TxMapBuilder(MVMap<String, DataType<?>> typeRegistry, DataType<?> defaultDataType) {
            this.typeRegistry = typeRegistry;
            this.defaultDataType = defaultDataType;
        }

        private void registerDataType(DataType<?> dataType) {
            String key = TxMapBuilder.getDataTypeRegistrationKey(dataType);
            DataType<?> registeredDataType = this.typeRegistry.putIfAbsent(key, dataType);
            if (registeredDataType != null) {
                // empty if block
            }
        }

        static String getDataTypeRegistrationKey(DataType<?> dataType) {
            return Integer.toHexString(Objects.hashCode(dataType));
        }

        @Override
        public MVMap<K, V> create(MVStore store, Map<String, Object> config) {
            DataType<Object> keyType = this.getKeyType();
            if (keyType == null) {
                String keyTypeKey = (String)config.remove("key");
                if (keyTypeKey != null) {
                    keyType = this.typeRegistry.get(keyTypeKey);
                    if (keyType == null) {
                        throw DataUtils.newMVStoreException(106, "Data type with hash {0} can not be found", keyTypeKey);
                    }
                    this.setKeyType(keyType);
                }
            } else {
                this.registerDataType(keyType);
            }
            DataType<Object> valueType = this.getValueType();
            if (valueType == null) {
                String valueTypeKey = (String)config.remove("val");
                if (valueTypeKey != null) {
                    valueType = this.typeRegistry.get(valueTypeKey);
                    if (valueType == null) {
                        throw DataUtils.newMVStoreException(106, "Data type with hash {0} can not be found", valueTypeKey);
                    }
                    this.setValueType(valueType);
                }
            } else {
                this.registerDataType(valueType);
            }
            if (this.getKeyType() == null) {
                this.setKeyType(this.defaultDataType);
                this.registerDataType(this.getKeyType());
            }
            if (this.getValueType() == null) {
                this.setValueType(new VersionedValueType(this.defaultDataType));
                this.registerDataType(this.getValueType());
            }
            config.put("store", store);
            config.put("key", this.getKeyType());
            config.put("val", this.getValueType());
            return this.create(config);
        }

        @Override
        protected MVMap<K, V> create(Map<String, Object> config) {
            if ("rtree".equals(config.get("type"))) {
                MVRTreeMap map = new MVRTreeMap(config, (SpatialDataType)this.getKeyType(), this.getValueType());
                return map;
            }
            return new TMVMap(config, this.getKeyType(), this.getValueType());
        }

        private static final class TMVMap<K, V>
        extends MVMap<K, V> {
            private final String type;

            TMVMap(Map<String, Object> config, DataType<K> keyType, DataType<V> valueType) {
                super(config, keyType, valueType);
                this.type = (String)config.get("type");
            }

            private TMVMap(MVMap<K, V> source) {
                super(source);
                this.type = source.getType();
            }

            @Override
            protected MVMap<K, V> cloneIt() {
                return new TMVMap<K, V>(this);
            }

            @Override
            public String getType() {
                return this.type;
            }

            @Override
            protected String asString(String name) {
                StringBuilder buff = new StringBuilder();
                buff.append(super.asString(name));
                DataUtils.appendMap(buff, "key", TxMapBuilder.getDataTypeRegistrationKey(this.getKeyType()));
                DataUtils.appendMap(buff, "val", TxMapBuilder.getDataTypeRegistrationKey(this.getValueType()));
                return buff.toString();
            }
        }
    }

    public static interface RollbackListener {
        public void onRollback(MVMap<Object, VersionedValue<Object>> var1, Object var2, VersionedValue<Object> var3, VersionedValue<Object> var4);
    }

    public static class Change {
        public final String mapName;
        public final Object key;
        public final Object value;

        public Change(String mapName, Object key, Object value) {
            this.mapName = mapName;
            this.key = key;
            this.value = value;
        }
    }
}

