/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import org.h2.mvstore.MVMap;
import org.h2.mvstore.tx.Record;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.value.VersionedValue;

final class RollbackDecisionMaker
extends MVMap.DecisionMaker<Record<?, ?>> {
    private final TransactionStore store;
    private final long transactionId;
    private final long toLogId;
    private final TransactionStore.RollbackListener listener;
    private MVMap.Decision decision;

    RollbackDecisionMaker(TransactionStore store, long transactionId, long toLogId, TransactionStore.RollbackListener listener) {
        this.store = store;
        this.transactionId = transactionId;
        this.toLogId = toLogId;
        this.listener = listener;
    }

    @Override
    public MVMap.Decision decide(Record existingValue, Record providedValue) {
        assert (this.decision == null);
        if (existingValue == null) {
            this.decision = MVMap.Decision.ABORT;
        } else {
            int mapId;
            MVMap<Object, VersionedValue<Object>> map;
            long operationId;
            VersionedValue<Object> valueToRestore = existingValue.oldValue;
            if ((valueToRestore == null || (operationId = valueToRestore.getOperationId()) == 0L || (long)TransactionStore.getTransactionId(operationId) == this.transactionId && TransactionStore.getLogId(operationId) < this.toLogId) && (map = this.store.openMap(mapId = existingValue.mapId)) != null && !map.isClosed()) {
                Object key = existingValue.key;
                VersionedValue previousValue = (VersionedValue)map.operate(key, valueToRestore, MVMap.DecisionMaker.DEFAULT);
                this.listener.onRollback(map, key, previousValue, valueToRestore);
            }
            this.decision = MVMap.Decision.REMOVE;
        }
        return this.decision;
    }

    @Override
    public void reset() {
        this.decision = null;
    }

    public String toString() {
        return "rollback-" + this.transactionId;
    }
}

