/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.rtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.rtree.Spatial;
import org.h2.mvstore.rtree.SpatialDataType;
import org.h2.mvstore.type.DataType;

public final class MVRTreeMap<V>
extends MVMap<Spatial, V> {
    private final SpatialDataType keyType;
    private boolean quadraticSplit;

    public MVRTreeMap(Map<String, Object> config, SpatialDataType keyType, DataType<V> valueType) {
        super(config, keyType, valueType);
        this.keyType = keyType;
        this.quadraticSplit = Boolean.parseBoolean(String.valueOf(config.get("quadraticSplit")));
    }

    private MVRTreeMap(MVRTreeMap<V> source) {
        super(source);
        this.keyType = source.keyType;
        this.quadraticSplit = source.quadraticSplit;
    }

    public MVRTreeMap<V> cloneIt() {
        return new MVRTreeMap<V>(this);
    }

    public RTreeCursor<V> findIntersectingKeys(Spatial x) {
        return new IntersectsRTreeCursor(this.getRootPage(), x, this.keyType);
    }

    public RTreeCursor<V> findContainedKeys(Spatial x) {
        return new ContainsRTreeCursor(this.getRootPage(), x, this.keyType);
    }

    private boolean contains(Page<Spatial, V> p, int index, Spatial key) {
        return this.keyType.contains(p.getKey(index), key);
    }

    @Override
    public V get(Page<Spatial, V> p, Spatial key) {
        int keyCount = p.getKeyCount();
        if (!p.isLeaf()) {
            for (int i = 0; i < keyCount; ++i) {
                V o;
                if (!this.contains(p, i, key) || (o = this.get(p.getChildPage(i), key)) == null) continue;
                return o;
            }
        } else {
            for (int i = 0; i < keyCount; ++i) {
                if (!this.keyType.equals(p.getKey(i), key)) continue;
                return p.getValue(i);
            }
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return (V)this.operate((Spatial)key, (V)null, (MVMap.DecisionMaker<? super V>)MVMap.DecisionMaker.REMOVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V operate(Spatial key, V value, MVMap.DecisionMaker<? super V> decisionMaker) {
        int attempt = 0;
        ArrayList<Page<Spatial, V>> removedPages = this.isPersistent() ? new ArrayList<Page<Spatial, V>>() : null;
        while (true) {
            RootReference rootReference = this.flushAndGetRoot();
            if (attempt++ == 0 && !rootReference.isLockedByCurrentThread()) {
                this.beforeWrite();
            }
            Page p = rootReference.root;
            if (removedPages != null && p.getTotalCount() > 0L) {
                removedPages.add(p);
            }
            p = p.copy();
            Object result = this.operate(p, key, value, decisionMaker, removedPages);
            if (!p.isLeaf() && p.getTotalCount() == 0L) {
                if (removedPages != null) {
                    removedPages.add(p);
                }
                p = this.createEmptyLeaf();
            } else if (p.getKeyCount() > this.store.getKeysPerPage() || (long)p.getMemory() > this.store.getMaxPageSize() && p.getKeyCount() > 3) {
                long totalCount = p.getTotalCount();
                Page split = this.split(p);
                Spatial k1 = this.getBounds(p);
                Spatial k2 = this.getBounds(split);
                Spatial[] spatialArray = (Spatial[])p.createKeyStorage(2);
                spatialArray[0] = k1;
                spatialArray[1] = k2;
                Page.PageReference<K, V>[] children = Page.createRefStorage(3);
                children[0] = new Page.PageReference(p);
                children[1] = new Page.PageReference(split);
                children[2] = Page.PageReference.empty();
                p = Page.createNode(this, spatialArray, children, totalCount, 0);
                if (this.isPersistent()) {
                    this.store.registerUnsavedMemory(p.getMemory());
                }
            }
            if (removedPages == null) {
                if (MVRTreeMap.updateRoot(rootReference, p, attempt)) {
                    return result;
                }
            } else {
                RootReference lockedRootReference = this.tryLock(rootReference, attempt);
                if (lockedRootReference != null) {
                    try {
                        long version = lockedRootReference.version;
                        int unsavedMemory = 0;
                        for (Page page : removedPages) {
                            if (page.isRemoved()) continue;
                            unsavedMemory += page.removePage(version);
                        }
                        if (this.isPersistent()) {
                            this.store.registerUnsavedMemory(unsavedMemory);
                        }
                    }
                    finally {
                        this.unlockRoot(p);
                    }
                    return result;
                }
                removedPages.clear();
            }
            decisionMaker.reset();
        }
    }

    private V operate(Page<Spatial, V> p, Spatial key, V value, MVMap.DecisionMaker<? super V> decisionMaker, Collection<Page<Spatial, V>> removedPages) {
        V result;
        if (p.isLeaf()) {
            int index = -1;
            int keyCount = p.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                if (!this.keyType.equals(p.getKey(i), key)) continue;
                index = i;
            }
            Object result2 = index < 0 ? null : (Object)p.getValue(index);
            MVMap.Decision decision = decisionMaker.decide(result2, value);
            switch (decision) {
                case REPEAT: 
                case ABORT: {
                    break;
                }
                case REMOVE: {
                    if (index < 0) break;
                    p.remove(index);
                    break;
                }
                case PUT: {
                    value = decisionMaker.selectValue(result2, value);
                    if (index < 0) {
                        p.insertLeaf(p.getKeyCount(), key, value);
                        break;
                    }
                    p.setKey(index, key);
                    p.setValue(index, value);
                }
            }
            return result2;
        }
        int index = -1;
        for (int i = 0; i < p.getKeyCount(); ++i) {
            if (!this.contains(p, i, key)) continue;
            Page<Spatial, V> c = p.getChildPage(i);
            if (this.get(c, key) != null) {
                index = i;
                break;
            }
            if (index >= 0) continue;
            index = i;
        }
        if (index < 0) {
            float min = Float.MAX_VALUE;
            for (int i = 0; i < p.getKeyCount(); ++i) {
                Spatial k = p.getKey(i);
                float areaIncrease = this.keyType.getAreaIncrease(k, key);
                if (!(areaIncrease < min)) continue;
                index = i;
                min = areaIncrease;
            }
        }
        Page<Spatial, V> c = p.getChildPage(index);
        if (removedPages != null) {
            removedPages.add(c);
        }
        if ((c = c.copy()).getKeyCount() > this.store.getKeysPerPage() || (long)c.getMemory() > this.store.getMaxPageSize() && c.getKeyCount() > 4) {
            Page<Spatial, V> split = this.split(c);
            p.setKey(index, this.getBounds(c));
            p.setChild(index, c);
            p.insertNode(index, this.getBounds(split), split);
            result = this.operate(p, key, value, decisionMaker, removedPages);
        } else {
            result = this.operate(c, key, value, decisionMaker, removedPages);
            Spatial bounds = p.getKey(index);
            if (!this.keyType.contains(bounds, key)) {
                bounds = this.keyType.createBoundingBox(bounds);
                this.keyType.increaseBounds(bounds, key);
                p.setKey(index, bounds);
            }
            if (c.getTotalCount() > 0L) {
                p.setChild(index, c);
            } else {
                p.remove(index);
            }
        }
        return result;
    }

    private Spatial getBounds(Page<Spatial, V> x) {
        Spatial bounds = this.keyType.createBoundingBox(x.getKey(0));
        int keyCount = x.getKeyCount();
        for (int i = 1; i < keyCount; ++i) {
            this.keyType.increaseBounds(bounds, x.getKey(i));
        }
        return bounds;
    }

    @Override
    public V put(Spatial key, V value) {
        return (V)this.operate(key, value, MVMap.DecisionMaker.PUT);
    }

    public void add(Spatial key, V value) {
        this.operate(key, value, MVMap.DecisionMaker.PUT);
    }

    private Page<Spatial, V> split(Page<Spatial, V> p) {
        return this.quadraticSplit ? this.splitQuadratic(p) : this.splitLinear(p);
    }

    private Page<Spatial, V> splitLinear(Page<Spatial, V> p) {
        int keyCount = p.getKeyCount();
        ArrayList<Spatial> keys = new ArrayList<Spatial>(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            keys.add(p.getKey(i));
        }
        int[] extremes = this.keyType.getExtremes(keys);
        if (extremes == null) {
            return this.splitQuadratic(p);
        }
        Page<Spatial, V> splitA = this.newPage(p.isLeaf());
        Page<Spatial, V> splitB = this.newPage(p.isLeaf());
        MVRTreeMap.move(p, splitA, extremes[0]);
        if (extremes[1] > extremes[0]) {
            extremes[1] = extremes[1] - 1;
        }
        MVRTreeMap.move(p, splitB, extremes[1]);
        Spatial boundsA = this.keyType.createBoundingBox(splitA.getKey(0));
        Spatial boundsB = this.keyType.createBoundingBox(splitB.getKey(0));
        while (p.getKeyCount() > 0) {
            float b;
            Spatial o = p.getKey(0);
            float a = this.keyType.getAreaIncrease(boundsA, o);
            if (a < (b = this.keyType.getAreaIncrease(boundsB, o))) {
                this.keyType.increaseBounds(boundsA, o);
                MVRTreeMap.move(p, splitA, 0);
                continue;
            }
            this.keyType.increaseBounds(boundsB, o);
            MVRTreeMap.move(p, splitB, 0);
        }
        while (splitB.getKeyCount() > 0) {
            MVRTreeMap.move(splitB, p, 0);
        }
        return splitA;
    }

    private Page<Spatial, V> splitQuadratic(Page<Spatial, V> p) {
        Page<Spatial, V> splitA = this.newPage(p.isLeaf());
        Page<Spatial, V> splitB = this.newPage(p.isLeaf());
        float largest = Float.MIN_VALUE;
        int ia = 0;
        int ib = 0;
        int keyCount = p.getKeyCount();
        for (int a = 0; a < keyCount; ++a) {
            Spatial objA = p.getKey(a);
            for (int b = 0; b < keyCount; ++b) {
                Spatial objB;
                float area;
                if (a == b || !((area = this.keyType.getCombinedArea(objA, objB = p.getKey(b))) > largest)) continue;
                largest = area;
                ia = a;
                ib = b;
            }
        }
        MVRTreeMap.move(p, splitA, ia);
        if (ia < ib) {
            --ib;
        }
        MVRTreeMap.move(p, splitB, ib);
        Spatial boundsA = this.keyType.createBoundingBox(splitA.getKey(0));
        Spatial boundsB = this.keyType.createBoundingBox(splitB.getKey(0));
        while (p.getKeyCount() > 0) {
            float diff = 0.0f;
            float bestA = 0.0f;
            float bestB = 0.0f;
            int best = 0;
            keyCount = p.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                float incB;
                Spatial o = p.getKey(i);
                float incA = this.keyType.getAreaIncrease(boundsA, o);
                float d = Math.abs(incA - (incB = this.keyType.getAreaIncrease(boundsB, o)));
                if (!(d > diff)) continue;
                diff = d;
                bestA = incA;
                bestB = incB;
                best = i;
            }
            if (bestA < bestB) {
                this.keyType.increaseBounds(boundsA, p.getKey(best));
                MVRTreeMap.move(p, splitA, best);
                continue;
            }
            this.keyType.increaseBounds(boundsB, p.getKey(best));
            MVRTreeMap.move(p, splitB, best);
        }
        while (splitB.getKeyCount() > 0) {
            MVRTreeMap.move(splitB, p, 0);
        }
        return splitA;
    }

    private Page<Spatial, V> newPage(boolean leaf) {
        Page page;
        Page page2 = page = leaf ? this.createEmptyLeaf() : this.createEmptyNode();
        if (this.isPersistent()) {
            this.store.registerUnsavedMemory(page.getMemory());
        }
        return page;
    }

    private static <V> void move(Page<Spatial, V> source, Page<Spatial, V> target, int sourceIndex) {
        Spatial k = source.getKey(sourceIndex);
        if (source.isLeaf()) {
            V v = source.getValue(sourceIndex);
            target.insertLeaf(0, k, v);
        } else {
            Page<Spatial, V> c = source.getChildPage(sourceIndex);
            target.insertNode(0, k, c);
        }
        source.remove(sourceIndex);
    }

    public void addNodeKeys(ArrayList<Spatial> list, Page<Spatial, V> p) {
        if (p != null && !p.isLeaf()) {
            int keyCount = p.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                list.add(p.getKey(i));
                this.addNodeKeys(list, p.getChildPage(i));
            }
        }
    }

    public boolean isQuadraticSplit() {
        return this.quadraticSplit;
    }

    public void setQuadraticSplit(boolean quadraticSplit) {
        this.quadraticSplit = quadraticSplit;
    }

    @Override
    protected int getChildPageCount(Page<Spatial, V> p) {
        return p.getRawChildPageCount() - 1;
    }

    @Override
    public String getType() {
        return "rtree";
    }

    public static class Builder<V>
    extends MVMap.BasicBuilder<MVRTreeMap<V>, Spatial, V> {
        private int dimensions = 2;

        public Builder() {
            this.setKeyType(new SpatialDataType(this.dimensions));
        }

        public Builder<V> dimensions(int dimensions) {
            this.dimensions = dimensions;
            this.setKeyType(new SpatialDataType(dimensions));
            return this;
        }

        public Builder<V> valueType(DataType<? super V> valueType) {
            this.setValueType(valueType);
            return this;
        }

        @Override
        public MVRTreeMap<V> create(Map<String, Object> config) {
            return new MVRTreeMap(config, (SpatialDataType)this.getKeyType(), this.getValueType());
        }
    }

    private static final class ContainsRTreeCursor<V>
    extends RTreeCursor<V> {
        private final SpatialDataType keyType;

        public ContainsRTreeCursor(Page<Spatial, V> root, Spatial filter, SpatialDataType keyType) {
            super(root, filter);
            this.keyType = keyType;
        }

        @Override
        protected boolean check(boolean leaf, Spatial key, Spatial test) {
            return leaf ? this.keyType.isInside(key, test) : this.keyType.isOverlap(key, test);
        }
    }

    private static final class IntersectsRTreeCursor<V>
    extends RTreeCursor<V> {
        private final SpatialDataType keyType;

        public IntersectsRTreeCursor(Page<Spatial, V> root, Spatial filter, SpatialDataType keyType) {
            super(root, filter);
            this.keyType = keyType;
        }

        @Override
        protected boolean check(boolean leaf, Spatial key, Spatial test) {
            return this.keyType.isOverlap(key, test);
        }
    }

    public static abstract class RTreeCursor<V>
    implements Iterator<Spatial> {
        private final Spatial filter;
        private CursorPos<Spatial, V> pos;
        private Spatial current;
        private final Page<Spatial, V> root;
        private boolean initialized;

        protected RTreeCursor(Page<Spatial, V> root, Spatial filter) {
            this.root = root;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.pos = new CursorPos<Spatial, V>(this.root, 0, null);
                this.fetchNext();
                this.initialized = true;
            }
            return this.current != null;
        }

        public void skip(long n) {
            while (this.hasNext() && n-- > 0L) {
                this.fetchNext();
            }
        }

        @Override
        public Spatial next() {
            if (!this.hasNext()) {
                return null;
            }
            Spatial c = this.current;
            this.fetchNext();
            return c;
        }

        void fetchNext() {
            while (this.pos != null) {
                Page p = this.pos.page;
                if (p.isLeaf()) {
                    while (this.pos.index < p.getKeyCount()) {
                        Spatial c = (Spatial)p.getKey(this.pos.index++);
                        if (this.filter != null && !this.check(true, c, this.filter)) continue;
                        this.current = c;
                        return;
                    }
                } else {
                    boolean found = false;
                    while (this.pos.index < p.getKeyCount()) {
                        int index;
                        ++this.pos.index;
                        Spatial c = (Spatial)p.getKey(index);
                        if (this.filter != null && !this.check(false, c, this.filter)) continue;
                        Page child = this.pos.page.getChildPage(index);
                        this.pos = new CursorPos(child, 0, this.pos);
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                this.pos = this.pos.parent;
            }
            this.current = null;
        }

        protected abstract boolean check(boolean var1, Spatial var2, Spatial var3);
    }
}

