/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Database;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.db.ValueDataType;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.MetaType;
import org.h2.mvstore.type.StatefulDataType;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.store.DataHandler;
import org.h2.value.CompareMode;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

public final class RowDataType
extends BasicDataType<SearchRow>
implements StatefulDataType<Database> {
    private final ValueDataType valueDataType;
    private final int[] sortTypes;
    private final int[] indexes;
    private final int columnCount;
    private final boolean storeKeys;
    private static final Factory FACTORY = new Factory();

    public RowDataType(CastDataProvider provider, CompareMode compareMode, DataHandler handler, int[] sortTypes, int[] indexes, int columnCount, boolean storeKeys) {
        this.valueDataType = new ValueDataType(provider, compareMode, handler, sortTypes);
        this.sortTypes = sortTypes;
        this.indexes = indexes;
        this.columnCount = columnCount;
        this.storeKeys = storeKeys;
        assert (indexes == null || sortTypes.length == indexes.length);
    }

    public int[] getIndexes() {
        return this.indexes;
    }

    public RowFactory getRowFactory() {
        return this.valueDataType.getRowFactory();
    }

    public void setRowFactory(RowFactory rowFactory) {
        this.valueDataType.setRowFactory(rowFactory);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean isStoreKeys() {
        return this.storeKeys;
    }

    public SearchRow[] createStorage(int capacity) {
        return new SearchRow[capacity];
    }

    @Override
    public int compare(SearchRow a, SearchRow b) {
        if (a == b) {
            return 0;
        }
        if (this.indexes == null) {
            int len = a.getColumnCount();
            assert (len == b.getColumnCount()) : len + " != " + b.getColumnCount();
            for (int i = 0; i < len; ++i) {
                int comp = this.valueDataType.compareValues(a.getValue(i), b.getValue(i), this.sortTypes[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
        return this.compareSearchRows(a, b);
    }

    private int compareSearchRows(SearchRow a, SearchRow b) {
        for (int i = 0; i < this.indexes.length; ++i) {
            int index = this.indexes[i];
            Value v1 = a.getValue(index);
            Value v2 = b.getValue(index);
            if (v1 == null || v2 == null) break;
            int comp = this.valueDataType.compareValues(v1, v2, this.sortTypes[i]);
            if (comp == 0) continue;
            return comp;
        }
        long aKey = a.getKey();
        long bKey = b.getKey();
        return aKey == SearchRow.MATCH_ALL_ROW_KEY || bKey == SearchRow.MATCH_ALL_ROW_KEY ? 0 : Long.compare(aKey, bKey);
    }

    @Override
    public int binarySearch(SearchRow key, Object storage, int size, int initialGuess) {
        return this.binarySearch(key, (SearchRow[])storage, size, initialGuess);
    }

    public int binarySearch(SearchRow key, SearchRow[] keys, int size, int initialGuess) {
        int low = 0;
        int high = size - 1;
        int x = initialGuess - 1;
        if (x < 0 || x > high) {
            x = high >>> 1;
        }
        while (low <= high) {
            int compare = this.compareSearchRows(key, keys[x]);
            if (compare > 0) {
                low = x + 1;
            } else if (compare < 0) {
                high = x - 1;
            } else {
                return x;
            }
            x = low + high >>> 1;
        }
        return -(low + 1);
    }

    @Override
    public int getMemory(SearchRow row) {
        return row.getMemory();
    }

    @Override
    public SearchRow read(ByteBuffer buff) {
        RowFactory rowFactory = this.valueDataType.getRowFactory();
        SearchRow row = rowFactory.createRow();
        if (this.storeKeys) {
            row.setKey(DataUtils.readVarLong(buff));
        }
        TypeInfo[] columnTypes = rowFactory.getColumnTypes();
        if (this.indexes == null) {
            int columnCount = row.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                row.setValue(i, this.valueDataType.readValue(buff, columnTypes != null ? columnTypes[i] : null));
            }
        } else {
            for (int i : this.indexes) {
                row.setValue(i, this.valueDataType.readValue(buff, columnTypes != null ? columnTypes[i] : null));
            }
        }
        return row;
    }

    @Override
    public void write(WriteBuffer buff, SearchRow row) {
        if (this.storeKeys) {
            buff.putVarLong(row.getKey());
        }
        if (this.indexes == null) {
            int columnCount = row.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.valueDataType.write(buff, row.getValue(i));
            }
        } else {
            for (int i : this.indexes) {
                this.valueDataType.write(buff, row.getValue(i));
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != RowDataType.class) {
            return false;
        }
        RowDataType other = (RowDataType)obj;
        return this.columnCount == other.columnCount && Arrays.equals(this.indexes, other.indexes) && Arrays.equals(this.sortTypes, other.sortTypes) && this.valueDataType.equals(other.valueDataType);
    }

    @Override
    public int hashCode() {
        int res = super.hashCode();
        res = res * 31 + this.columnCount;
        res = res * 31 + Arrays.hashCode(this.indexes);
        res = res * 31 + Arrays.hashCode(this.sortTypes);
        res = res * 31 + this.valueDataType.hashCode();
        return res;
    }

    @Override
    public void save(WriteBuffer buff, MetaType<Database> metaType) {
        buff.putVarInt(this.columnCount);
        RowDataType.writeIntArray(buff, this.sortTypes);
        RowDataType.writeIntArray(buff, this.indexes);
        buff.put(this.storeKeys ? (byte)1 : 0);
    }

    private static void writeIntArray(WriteBuffer buff, int[] array) {
        if (array == null) {
            buff.putVarInt(0);
        } else {
            buff.putVarInt(array.length + 1);
            for (int i : array) {
                buff.putVarInt(i);
            }
        }
    }

    public Factory getFactory() {
        return FACTORY;
    }

    public static final class Factory
    implements StatefulDataType.Factory<Database> {
        public RowDataType create(ByteBuffer buff, MetaType<Database> metaDataType, Database database) {
            int columnCount = DataUtils.readVarInt(buff);
            int[] sortTypes = Factory.readIntArray(buff);
            int[] indexes = Factory.readIntArray(buff);
            boolean storeKeys = buff.get() != 0;
            CompareMode compareMode = database == null ? CompareMode.getInstance(null, 0) : database.getCompareMode();
            RowFactory rowFactory = RowFactory.getDefaultRowFactory().createRowFactory(database, compareMode, database, sortTypes, indexes, null, columnCount, storeKeys);
            return rowFactory.getRowDataType();
        }

        private static int[] readIntArray(ByteBuffer buff) {
            int len = DataUtils.readVarInt(buff) - 1;
            if (len < 0) {
                return null;
            }
            int[] res = new int[len];
            for (int i = 0; i < res.length; ++i) {
                res[i] = DataUtils.readVarInt(buff);
            }
            return res;
        }
    }
}

