/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.command.ddl.CreateTableData;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintReferential;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.mode.DefaultNullOrdering;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.db.MVDelegateIndex;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.mvstore.db.MVSecondaryIndex;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.mvstore.db.Store;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableType;
import org.h2.util.DebuggingThreadLocal;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;

public class MVTable
extends TableBase {
    public static final DebuggingThreadLocal<String> WAITING_FOR_LOCK;
    public static final DebuggingThreadLocal<ArrayList<String>> EXCLUSIVE_LOCKS;
    public static final DebuggingThreadLocal<ArrayList<String>> SHARED_LOCKS;
    private static final String NO_EXTRA_INFO = "";
    private final boolean containsLargeObject;
    private volatile SessionLocal lockExclusiveSession;
    private final ConcurrentHashMap<SessionLocal, SessionLocal> lockSharedSessions = new ConcurrentHashMap();
    private Column rowIdColumn;
    private final MVPrimaryIndex primaryIndex;
    private final ArrayList<Index> indexes = Utils.newSmallArrayList();
    private final AtomicLong lastModificationId = new AtomicLong();
    private final ArrayDeque<SessionLocal> waitingSessions = new ArrayDeque();
    private final Trace traceLock;
    private final AtomicInteger changesUntilAnalyze;
    private int nextAnalyze;
    private final Store store;
    private final TransactionStore transactionStore;

    public MVTable(CreateTableData data, Store store) {
        super(data);
        this.isHidden = data.isHidden;
        boolean b = false;
        for (Column col : this.getColumns()) {
            if (!DataType.isLargeObject(col.getType().getValueType())) continue;
            b = true;
            break;
        }
        this.containsLargeObject = b;
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.changesUntilAnalyze = this.nextAnalyze <= 0 ? null : new AtomicInteger(this.nextAnalyze);
        this.store = store;
        this.transactionStore = store.getTransactionStore();
        this.traceLock = this.database.getTrace(7);
        this.primaryIndex = new MVPrimaryIndex(this.database, this, this.getId(), IndexColumn.wrap(this.getColumns()), IndexType.createScan(true));
        this.indexes.add(this.primaryIndex);
    }

    public String getMapName() {
        return this.primaryIndex.getMapName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lock(SessionLocal session, int lockType) {
        if (this.database.getLockMode() == 0) {
            session.registerTableAsUpdated(this);
            return false;
        }
        if (lockType == 0 && this.lockExclusiveSession == null) {
            return false;
        }
        if (this.lockExclusiveSession == session) {
            return true;
        }
        if (lockType != 2 && this.lockSharedSessions.containsKey(session)) {
            return true;
        }
        MVTable mVTable = this;
        synchronized (mVTable) {
            if (lockType != 2 && this.lockSharedSessions.containsKey(session)) {
                return true;
            }
            session.setWaitForLock(this, Thread.currentThread());
            if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                WAITING_FOR_LOCK.set(this.getName());
            }
            this.waitingSessions.addLast(session);
            try {
                this.doLock1(session, lockType);
            }
            finally {
                session.setWaitForLock(null, null);
                if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
                    WAITING_FOR_LOCK.remove();
                }
                this.waitingSessions.remove(session);
            }
        }
        return false;
    }

    private void doLock1(SessionLocal session, int lockType) {
        this.traceLock(session, lockType, TraceLockEvent.TRACE_LOCK_REQUESTING_FOR, NO_EXTRA_INFO);
        long max = 0L;
        boolean checkDeadlock = false;
        while (this.waitingSessions.getFirst() != session || this.lockExclusiveSession != null || !this.doLock2(session, lockType)) {
            if (checkDeadlock) {
                ArrayList<SessionLocal> sessions = this.checkDeadlock(session, null, null);
                if (sessions != null) {
                    throw DbException.get(40001, MVTable.getDeadlockDetails(sessions, lockType));
                }
            } else {
                checkDeadlock = true;
            }
            long now = System.nanoTime();
            if (max == 0L) {
                max = Utils.nanoTimePlusMillis(now, session.getLockTimeout());
            } else if (now - max >= 0L) {
                this.traceLock(session, lockType, TraceLockEvent.TRACE_LOCK_TIMEOUT_AFTER, Integer.toString(session.getLockTimeout()));
                throw DbException.get(50200, this.getName());
            }
            try {
                this.traceLock(session, lockType, TraceLockEvent.TRACE_LOCK_WAITING_FOR, NO_EXTRA_INFO);
                long sleep = Math.min(100L, (max - now) / 1000000L);
                if (sleep == 0L) {
                    sleep = 1L;
                }
                this.wait(sleep);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private boolean doLock2(SessionLocal session, int lockType) {
        switch (lockType) {
            case 2: {
                int size = this.lockSharedSessions.size();
                if (size == 0) {
                    this.traceLock(session, lockType, TraceLockEvent.TRACE_LOCK_ADDED_FOR, NO_EXTRA_INFO);
                    session.registerTableAsLocked(this);
                } else if (size == 1 && this.lockSharedSessions.containsKey(session)) {
                    this.traceLock(session, lockType, TraceLockEvent.TRACE_LOCK_ADD_UPGRADED_FOR, NO_EXTRA_INFO);
                } else {
                    return false;
                }
                this.lockExclusiveSession = session;
                if (!SysProperties.THREAD_DEADLOCK_DETECTOR) break;
                this.addLockToDebugList(EXCLUSIVE_LOCKS);
                break;
            }
            case 1: {
                if (this.lockSharedSessions.putIfAbsent(session, session) != null) break;
                this.traceLock(session, lockType, TraceLockEvent.TRACE_LOCK_OK, NO_EXTRA_INFO);
                session.registerTableAsLocked(this);
                if (!SysProperties.THREAD_DEADLOCK_DETECTOR) break;
                this.addLockToDebugList(SHARED_LOCKS);
            }
        }
        return true;
    }

    private void addLockToDebugList(DebuggingThreadLocal<ArrayList<String>> locks) {
        ArrayList<String> list = locks.get();
        if (list == null) {
            list = new ArrayList();
            locks.set(list);
        }
        list.add(this.getName());
    }

    private void traceLock(SessionLocal session, int lockType, TraceLockEvent eventEnum, String extraInfo) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3} {4}", session.getId(), MVTable.lockTypeToString(lockType), eventEnum.getEventText(), this.getName(), extraInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(SessionLocal s) {
        if (this.database != null) {
            int lockType;
            if (this.lockExclusiveSession == s) {
                ArrayList<String> exclusiveLocks;
                lockType = 2;
                this.lockSharedSessions.remove(s);
                this.lockExclusiveSession = null;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && (exclusiveLocks = EXCLUSIVE_LOCKS.get()) != null) {
                    exclusiveLocks.remove(this.getName());
                }
            } else {
                ArrayList<String> sharedLocks;
                int n = lockType = this.lockSharedSessions.remove(s) != null ? 1 : 0;
                if (SysProperties.THREAD_DEADLOCK_DETECTOR && (sharedLocks = SHARED_LOCKS.get()) != null) {
                    sharedLocks.remove(this.getName());
                }
            }
            this.traceLock(s, lockType, TraceLockEvent.TRACE_LOCK_UNLOCK, NO_EXTRA_INFO);
            if (lockType != 0 && !this.waitingSessions.isEmpty()) {
                MVTable mVTable = this;
                synchronized (mVTable) {
                    this.notifyAll();
                }
            }
        }
    }

    @Override
    public void close(SessionLocal session) {
    }

    @Override
    public Row getRow(SessionLocal session, long key) {
        return this.primaryIndex.getRow(session, key);
    }

    @Override
    public Index addIndex(SessionLocal session, String indexName, int indexId, IndexColumn[] cols, int uniqueColumnCount, IndexType indexType, boolean create, String indexComment) {
        MVIndex index;
        int mainIndexColumn;
        boolean isSessionTemporary;
        cols = MVTable.prepareColumns(this.database, cols, indexType);
        boolean bl = isSessionTemporary = this.isTemporary() && !this.isGlobalTemporary();
        if (!isSessionTemporary) {
            this.database.lockMeta(session);
        }
        int n = mainIndexColumn = this.primaryIndex.getMainIndexColumn() != -1 ? -1 : MVTable.getMainIndexColumn(indexType, cols);
        if (this.database.isStarting()) {
            if (this.transactionStore.hasMap("index." + indexId)) {
                mainIndexColumn = -1;
            }
        } else if (this.primaryIndex.getRowCountMax() != 0L) {
            mainIndexColumn = -1;
        }
        if (mainIndexColumn != -1) {
            this.primaryIndex.setMainIndexColumn(mainIndexColumn);
            index = new MVDelegateIndex(this, indexId, indexName, this.primaryIndex, indexType);
        } else {
            index = indexType.isSpatial() ? new MVSpatialIndex(session.getDatabase(), this, indexId, indexName, cols, uniqueColumnCount, indexType) : new MVSecondaryIndex(session.getDatabase(), this, indexId, indexName, cols, uniqueColumnCount, indexType);
        }
        if (index.needRebuild()) {
            this.rebuildIndex(session, index, indexName);
        }
        index.setTemporary(this.isTemporary());
        if (index.getCreateSQL() != null) {
            index.setComment(indexComment);
            if (isSessionTemporary) {
                session.addLocalTempTableIndex(index);
            } else {
                this.database.addSchemaObject(session, index);
            }
        }
        this.indexes.add(index);
        this.setModified();
        return index;
    }

    private void rebuildIndex(SessionLocal session, MVIndex<?, ?> index, String indexName) {
        try {
            if (!session.getDatabase().isPersistent() || index instanceof MVSpatialIndex) {
                this.rebuildIndexBuffered(session, index);
            } else {
                this.rebuildIndexBlockMerge(session, index);
            }
        }
        catch (DbException e) {
            this.getSchema().freeUniqueName(indexName);
            try {
                index.remove(session);
            }
            catch (DbException e2) {
                this.trace.error(e2, "could not remove index");
                throw e2;
            }
            throw e;
        }
    }

    private void rebuildIndexBlockMerge(SessionLocal session, MVIndex<?, ?> index) {
        long remaining;
        Index scan = this.getScanIndex(session);
        long total = remaining = scan.getRowCount(session);
        Cursor cursor = scan.find(session, null, null);
        long i = 0L;
        Store store = session.getDatabase().getStore();
        int bufferSize = this.database.getMaxMemoryRows() / 2;
        ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
        String n = this.getName() + ':' + index.getName();
        ArrayList<String> bufferNames = Utils.newSmallArrayList();
        while (cursor.next()) {
            Row row = cursor.get();
            buffer.add(row);
            this.database.setProgress(1, n, i++, total);
            if (buffer.size() >= bufferSize) {
                MVTable.sortRows(buffer, index);
                String mapName = store.nextTemporaryMapName();
                index.addRowsToBuffer(buffer, mapName);
                bufferNames.add(mapName);
                buffer.clear();
            }
            --remaining;
        }
        MVTable.sortRows(buffer, index);
        if (!bufferNames.isEmpty()) {
            String mapName = store.nextTemporaryMapName();
            index.addRowsToBuffer(buffer, mapName);
            bufferNames.add(mapName);
            buffer.clear();
            index.addBufferedRows(bufferNames);
        } else {
            MVTable.addRowsToIndex(session, buffer, index);
        }
        if (remaining != 0L) {
            throw DbException.getInternalError("rowcount remaining=" + remaining + ' ' + this.getName());
        }
    }

    private void rebuildIndexBuffered(SessionLocal session, Index index) {
        long remaining;
        Index scan = this.getScanIndex(session);
        long total = remaining = scan.getRowCount(session);
        Cursor cursor = scan.find(session, null, null);
        long i = 0L;
        int bufferSize = (int)Math.min(total, (long)this.database.getMaxMemoryRows());
        ArrayList<Row> buffer = new ArrayList<Row>(bufferSize);
        String n = this.getName() + ':' + index.getName();
        while (cursor.next()) {
            Row row = cursor.get();
            buffer.add(row);
            this.database.setProgress(1, n, i++, total);
            if (buffer.size() >= bufferSize) {
                MVTable.addRowsToIndex(session, buffer, index);
            }
            --remaining;
        }
        MVTable.addRowsToIndex(session, buffer, index);
        if (remaining != 0L) {
            throw DbException.getInternalError("rowcount remaining=" + remaining + ' ' + this.getName());
        }
    }

    @Override
    public void removeRow(SessionLocal session, Row row) {
        this.syncLastModificationIdWithDatabase();
        Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session, row);
            }
        }
        catch (Throwable e) {
            try {
                t.rollbackToSavepoint(savepoint);
            }
            catch (Throwable nested) {
                e.addSuppressed(nested);
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public long truncate(SessionLocal session) {
        this.syncLastModificationIdWithDatabase();
        long result = this.getRowCountApproximation(session);
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        if (this.changesUntilAnalyze != null) {
            this.changesUntilAnalyze.set(this.nextAnalyze);
        }
        return result;
    }

    @Override
    public void addRow(SessionLocal session, Row row) {
        this.syncLastModificationIdWithDatabase();
        Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (Index index : this.indexes) {
                index.add(session, row);
            }
        }
        catch (Throwable e) {
            try {
                t.rollbackToSavepoint(savepoint);
            }
            catch (Throwable nested) {
                e.addSuppressed(nested);
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void updateRow(SessionLocal session, Row oldRow, Row newRow) {
        newRow.setKey(oldRow.getKey());
        this.syncLastModificationIdWithDatabase();
        Transaction t = session.getTransaction();
        long savepoint = t.setSavepoint();
        try {
            for (Index index : this.indexes) {
                index.update(session, oldRow, newRow);
            }
        }
        catch (Throwable e) {
            try {
                t.rollbackToSavepoint(savepoint);
            }
            catch (Throwable nested) {
                e.addSuppressed(nested);
            }
            throw DbException.convert(e);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public Row lockRow(SessionLocal session, Row row) {
        Row lockedRow = this.primaryIndex.lockRow(session, row);
        if (lockedRow == null || !row.hasSharedData(lockedRow)) {
            this.syncLastModificationIdWithDatabase();
        }
        return lockedRow;
    }

    private void analyzeIfRequired(SessionLocal session) {
        if (this.changesUntilAnalyze != null && this.changesUntilAnalyze.decrementAndGet() == 0) {
            if (this.nextAnalyze <= 0x3FFFFFFF) {
                this.nextAnalyze *= 2;
            }
            this.changesUntilAnalyze.set(this.nextAnalyze);
            session.markTableForAnalyze(this);
        }
    }

    @Override
    public Index getScanIndex(SessionLocal session) {
        return this.primaryIndex;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId.get();
    }

    @Override
    public void removeChildrenAndResources(SessionLocal session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        this.database.getStore().removeTable(this);
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            index.remove(session);
            if (index.getName() != null) {
                this.database.removeSchemaObject(session, index);
            }
            this.indexes.remove(index);
        }
        this.primaryIndex.remove(session);
        this.indexes.clear();
        this.close(session);
        this.invalidate();
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return this.primaryIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return this.primaryIndex.getRowCountApproximation(session);
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.primaryIndex.getDiskSpaceUsed();
    }

    Transaction getTransactionBegin() {
        return this.transactionStore.begin();
    }

    @Override
    public boolean isRowLockable() {
        return true;
    }

    public void commit() {
        if (this.database != null) {
            this.syncLastModificationIdWithDatabase();
        }
    }

    private void syncLastModificationIdWithDatabase() {
        long currentId;
        long nextModificationDataId = this.database.getNextModificationDataId();
        while (nextModificationDataId > (currentId = this.lastModificationId.get()) && !this.lastModificationId.compareAndSet(currentId, nextModificationDataId)) {
        }
    }

    DbException convertException(MVStoreException e) {
        int errorCode = e.getErrorCode();
        if (errorCode == 101) {
            throw DbException.get(90131, e, this.getName());
        }
        if (errorCode == 105) {
            throw DbException.get(40001, e, this.getName());
        }
        return this.store.convertMVStoreException(e);
    }

    @Override
    public int getMainIndexColumn() {
        return this.primaryIndex.getMainIndexColumn();
    }

    private static void addRowsToIndex(SessionLocal session, ArrayList<Row> list, Index index) {
        MVTable.sortRows(list, index);
        for (Row row : list) {
            index.add(session, row);
        }
        list.clear();
    }

    private static String getDeadlockDetails(ArrayList<SessionLocal> sessions, int lockType) {
        StringBuilder builder = new StringBuilder();
        for (SessionLocal s : sessions) {
            Table lock = s.getWaitForLock();
            Thread thread = s.getWaitForLockThread();
            builder.append("\nSession ").append(s).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(lock.toString()).append(" (").append(MVTable.lockTypeToString(lockType)).append(") while locking ");
            boolean addComma = false;
            for (Table t : s.getLocks()) {
                if (addComma) {
                    builder.append(", ");
                }
                addComma = true;
                builder.append(t.toString());
                if (!(t instanceof MVTable)) continue;
                if (((MVTable)t).lockExclusiveSession == s) {
                    builder.append(" (exclusive)");
                    continue;
                }
                builder.append(" (shared)");
            }
            builder.append('.');
        }
        return builder.toString();
    }

    private static String lockTypeToString(int lockType) {
        return lockType == 0 ? "shared read" : (lockType == 1 ? "shared write" : "exclusive");
    }

    private static void sortRows(ArrayList<? extends SearchRow> list, Index index) {
        list.sort(index::compareRows);
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public boolean canGetRowCount(SessionLocal session) {
        return true;
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> constraints;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (constraints = this.getConstraints()) != null) {
            for (Constraint c : constraints) {
                ConstraintReferential ref;
                if (c.getConstraintType() != Constraint.Type.REFERENTIAL || (ref = (ConstraintReferential)c).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<SessionLocal> checkDeadlock(SessionLocal session, SessionLocal clash, Set<SessionLocal> visited) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Table t;
            if (clash == null) {
                clash = session;
                visited = new HashSet<SessionLocal>();
            } else {
                if (clash == session) {
                    return new ArrayList<SessionLocal>(0);
                }
                if (visited.contains(session)) {
                    return null;
                }
            }
            visited.add(session);
            ArrayList<SessionLocal> error = null;
            for (SessionLocal s : this.lockSharedSessions.keySet()) {
                Table t2;
                if (s == session || (t2 = s.getWaitForLock()) == null || (error = t2.checkDeadlock(s, clash, visited)) == null) continue;
                error.add(session);
                break;
            }
            SessionLocal copyOfLockExclusiveSession = this.lockExclusiveSession;
            if (error == null && copyOfLockExclusiveSession != null && (t = copyOfLockExclusiveSession.getWaitForLock()) != null && (error = t.checkDeadlock(copyOfLockExclusiveSession, clash, visited)) != null) {
                error.add(session);
            }
            return error;
        }
    }

    @Override
    public void checkSupportAlter() {
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", TypeInfo.TYPE_BIGINT, this, -1);
            this.rowIdColumn.setRowId(true);
            this.rowIdColumn.setNullable(false);
        }
        return this.rowIdColumn;
    }

    @Override
    public TableType getTableType() {
        return TableType.TABLE;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusiveSession != null;
    }

    @Override
    public boolean isLockedExclusivelyBy(SessionLocal session) {
        return this.lockExclusiveSession == session;
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.lockExclusiveSession = null;
    }

    @Override
    public String toString() {
        return this.getTraceSQL();
    }

    private static IndexColumn[] prepareColumns(Database database, IndexColumn[] cols, IndexType indexType) {
        block7: {
            int i;
            block6: {
                if (!indexType.isPrimaryKey()) break block6;
                for (IndexColumn c : cols) {
                    Column column = c.column;
                    if (!column.isNullable()) continue;
                    throw DbException.get(90023, column.getName());
                }
                for (IndexColumn c : cols) {
                    c.column.setPrimaryKey(true);
                }
                break block7;
            }
            if (indexType.isSpatial()) break block7;
            int l = cols.length;
            for (i = 0; i < l && (cols[i].sortType & 6) != 0; ++i) {
            }
            if (i != l) {
                cols = (IndexColumn[])cols.clone();
                DefaultNullOrdering defaultNullOrdering = database.getDefaultNullOrdering();
                while (i < l) {
                    IndexColumn oldColumn = cols[i];
                    int sortTypeOld = oldColumn.sortType;
                    int sortTypeNew = defaultNullOrdering.addExplicitNullOrdering(sortTypeOld);
                    if (sortTypeNew != sortTypeOld) {
                        IndexColumn newColumn = new IndexColumn(oldColumn.columnName, sortTypeNew);
                        newColumn.column = oldColumn.column;
                        cols[i] = newColumn;
                    }
                    ++i;
                }
            }
        }
        return cols;
    }

    static {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            WAITING_FOR_LOCK = new DebuggingThreadLocal();
            EXCLUSIVE_LOCKS = new DebuggingThreadLocal();
            SHARED_LOCKS = new DebuggingThreadLocal();
        } else {
            WAITING_FOR_LOCK = null;
            EXCLUSIVE_LOCKS = null;
            SHARED_LOCKS = null;
        }
    }

    private static enum TraceLockEvent {
        TRACE_LOCK_OK("ok"),
        TRACE_LOCK_WAITING_FOR("waiting for"),
        TRACE_LOCK_REQUESTING_FOR("requesting for"),
        TRACE_LOCK_TIMEOUT_AFTER("timeout after "),
        TRACE_LOCK_UNLOCK("unlock"),
        TRACE_LOCK_ADDED_FOR("added for"),
        TRACE_LOCK_ADD_UPGRADED_FOR("add (upgraded) for ");

        private final String eventText;

        private TraceLockEvent(String eventText) {
            this.eventText = eventText;
        }

        public String getEventText() {
            return this.eventText;
        }
    }
}

