/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.RowDataType;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.type.LongDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.VersionedValue;

public class MVPrimaryIndex
extends MVIndex<Long, SearchRow> {
    private final MVTable mvTable;
    private final String mapName;
    private final TransactionMap<Long, SearchRow> dataMap;
    private final AtomicLong lastKey = new AtomicLong();
    private int mainIndexColumn = -1;

    public MVPrimaryIndex(Database db, MVTable table, int id, IndexColumn[] columns, IndexType indexType) {
        super(table, id, table.getName() + "_DATA", columns, 0, indexType);
        this.mvTable = table;
        RowDataType valueType = table.getRowFactory().getRowDataType();
        this.mapName = "table." + this.getId();
        Transaction t = this.mvTable.getTransactionBegin();
        this.dataMap = t.openMap(this.mapName, LongDataType.INSTANCE, valueType);
        this.dataMap.map.setVolatile(!table.isPersistData() || !indexType.isPersistent());
        if (!db.isStarting()) {
            this.dataMap.clear();
        }
        t.commit();
        Long k = (Long)this.dataMap.map.lastKey();
        this.lastKey.set(k == null ? 0L : k);
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), 3).append(".tableScan").toString();
    }

    public void setMainIndexColumn(int mainIndexColumn) {
        this.mainIndexColumn = mainIndexColumn;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public void close(SessionLocal session) {
    }

    @Override
    public void add(SessionLocal session, Row row) {
        long last;
        if (this.mainIndexColumn == -1) {
            if (row.getKey() == 0L) {
                row.setKey(this.lastKey.incrementAndGet());
            }
        } else {
            long c = row.getValue(this.mainIndexColumn).getLong();
            row.setKey(c);
        }
        if (this.mvTable.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                if (!(v instanceof ValueLob)) continue;
                ValueLob lob = ((ValueLob)v).copy(this.database, this.getId());
                session.removeAtCommitStop(lob);
                if (v == lob) continue;
                row.setValue(i, lob);
            }
        }
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        long rowKey = row.getKey();
        try {
            Row old = (Row)map.putIfAbsent(rowKey, row);
            if (old != null) {
                int errorCode = 90131;
                if (map.getImmediate(rowKey) != null || map.getFromSnapshot(rowKey) != null) {
                    errorCode = 23505;
                }
                DbException e = DbException.get(errorCode, this.getDuplicatePrimaryKeyMessage(this.mainIndexColumn).append(' ').append(old).toString());
                e.setSource(this);
                throw e;
            }
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
        while (rowKey > (last = this.lastKey.get()) && !this.lastKey.compareAndSet(last, rowKey)) {
        }
    }

    @Override
    public void remove(SessionLocal session, Row row) {
        if (this.mvTable.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                if (!(v instanceof ValueLob)) continue;
                session.removeAtCommit((ValueLob)v);
            }
        }
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        try {
            Row existing = (Row)map.remove(row.getKey());
            if (existing == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, 3).append(": ").append(row.getKey());
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public void update(SessionLocal session, Row oldRow, Row newRow) {
        if (this.mainIndexColumn != -1) {
            long c = newRow.getValue(this.mainIndexColumn).getLong();
            newRow.setKey(c);
        }
        long key = oldRow.getKey();
        assert (this.mainIndexColumn != -1 || key != 0L);
        assert (key == newRow.getKey()) : key + " != " + newRow.getKey();
        if (this.mvTable.getContainsLargeObject()) {
            int len = oldRow.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value newValue;
                Value oldValue = oldRow.getValue(i);
                if (oldValue == (newValue = newRow.getValue(i))) continue;
                if (oldValue instanceof ValueLob) {
                    session.removeAtCommit((ValueLob)oldValue);
                }
                if (!(newValue instanceof ValueLob)) continue;
                ValueLob lob = ((ValueLob)newValue).copy(this.database, this.getId());
                session.removeAtCommitStop(lob);
                if (newValue == lob) continue;
                newRow.setValue(i, lob);
            }
        }
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        try {
            Row existing = (Row)map.put(key, newRow);
            if (existing == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, 3).append(": ").append(key);
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (MVStoreException e) {
            throw this.mvTable.convertException(e);
        }
        if (newRow.getKey() > this.lastKey.get()) {
            this.lastKey.set(newRow.getKey());
        }
    }

    Row lockRow(SessionLocal session, Row row) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        long key = row.getKey();
        return this.lockRow(map, key);
    }

    private Row lockRow(TransactionMap<Long, SearchRow> map, long key) {
        try {
            return MVPrimaryIndex.setRowKey((Row)map.lock(key), key);
        }
        catch (MVStoreException ex) {
            throw this.mvTable.convertException(ex);
        }
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last) {
        long min = this.extractPKFromRow(first, Long.MIN_VALUE);
        long max = this.extractPKFromRow(last, Long.MAX_VALUE);
        return this.find(session, min, max);
    }

    private long extractPKFromRow(SearchRow row, long defaultValue) {
        Value v;
        long result = row == null ? defaultValue : (this.mainIndexColumn == -1 ? row.getKey() : ((v = row.getValue(this.mainIndexColumn)) == null ? row.getKey() : (v == ValueNull.INSTANCE ? 0L : v.getLong())));
        return result;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public Row getRow(SessionLocal session, long key) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        Row row = (Row)map.getFromSnapshot(key);
        if (row == null) {
            throw DbException.get(90143, this.getTraceSQL(), String.valueOf(key));
        }
        return MVPrimaryIndex.setRowKey(row, key);
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        try {
            return 10L * this.getCostRangeIndex(masks, this.dataMap.sizeAsLongMax(), filters, filter, sortOrder, true, allColumnsSet);
        }
        catch (MVStoreException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return false;
    }

    @Override
    public void remove(SessionLocal session) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        if (!map.isClosed()) {
            Transaction t = session.getTransaction();
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(SessionLocal session) {
        if (this.mvTable.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.getMap(session).clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(SessionLocal session, boolean first) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        Map.Entry<Long, SearchRow> entry = first ? map.firstEntry() : map.lastEntry();
        return new SingleRowCursor(entry != null ? MVPrimaryIndex.setRowKey((Row)entry.getValue(), entry.getKey()) : null);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return this.getMap(session).sizeAsLong();
    }

    public long getRowCountMax() {
        return this.dataMap.sizeAsLongMax();
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return this.getRowCountMax();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.dataMap.map.getRootPage().getDiskSpaceUsed();
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw new UnsupportedOperationException();
    }

    private Cursor find(SessionLocal session, Long first, Long last) {
        TransactionMap<Long, SearchRow> map = this.getMap(session);
        if (first != null && last != null && first.longValue() == last.longValue()) {
            return new SingleRowCursor(MVPrimaryIndex.setRowKey((Row)map.getFromSnapshot(first), first));
        }
        return new MVStoreCursor(map.entryIterator(first, last));
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    TransactionMap<Long, SearchRow> getMap(SessionLocal session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction t = session.getTransaction();
        return this.dataMap.getInstance(t);
    }

    @Override
    public MVMap<Long, VersionedValue<SearchRow>> getMVMap() {
        return this.dataMap.map;
    }

    private static Row setRowKey(Row row, long key) {
        if (row != null && row.getKey() == 0L) {
            row.setKey(key);
        }
        return row;
    }

    static final class MVStoreCursor
    implements Cursor {
        private final TransactionMap.TMIterator<Long, SearchRow, Map.Entry<Long, SearchRow>> it;
        private Map.Entry<Long, SearchRow> current;
        private Row row;

        public MVStoreCursor(TransactionMap.TMIterator<Long, SearchRow, Map.Entry<Long, SearchRow>> it) {
            this.it = it;
        }

        @Override
        public Row get() {
            if (this.row == null && this.current != null) {
                this.row = (Row)this.current.getValue();
                if (this.row.getKey() == 0L) {
                    this.row.setKey(this.current.getKey());
                }
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            return this.get();
        }

        @Override
        public boolean next() {
            this.current = this.it.fetchNext();
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

