/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.List;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVPrimaryIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.result.Row;
import org.h2.result.RowFactory;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.value.VersionedValue;

public class MVDelegateIndex
extends MVIndex<Long, SearchRow> {
    private final MVPrimaryIndex mainIndex;

    public MVDelegateIndex(MVTable table, int id, String name, MVPrimaryIndex mainIndex, IndexType indexType) {
        super(table, id, name, IndexColumn.wrap(new Column[]{table.getColumn(mainIndex.getMainIndexColumn())}), 1, indexType);
        this.mainIndex = mainIndex;
        if (id < 0) {
            throw DbException.getInternalError(name);
        }
    }

    @Override
    public RowFactory getRowFactory() {
        return this.mainIndex.getRowFactory();
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw DbException.getInternalError();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw DbException.getInternalError();
    }

    @Override
    public MVMap<Long, VersionedValue<SearchRow>> getMVMap() {
        return this.mainIndex.getMVMap();
    }

    @Override
    public void add(SessionLocal session, Row row) {
    }

    @Override
    public Row getRow(SessionLocal session, long key) {
        return this.mainIndex.getRow(session, key);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(SessionLocal session) {
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last) {
        return this.mainIndex.find(session, first, last);
    }

    @Override
    public Cursor findFirstOrLast(SessionLocal session, boolean first) {
        return this.mainIndex.findFirstOrLast(session, first);
    }

    @Override
    public int getColumnIndex(Column col) {
        if (col.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return this.getColumnIndex(column) == 0;
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 10L * this.getCostRangeIndex(masks, this.mainIndex.getRowCountApproximation(session), filters, filter, sortOrder, true, allColumnsSet);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(SessionLocal session, Row row) {
    }

    @Override
    public void update(SessionLocal session, Row oldRow, Row newRow) {
    }

    @Override
    public void remove(SessionLocal session) {
        this.mainIndex.setMainIndexColumn(-1);
    }

    @Override
    public void truncate(SessionLocal session) {
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return this.mainIndex.getRowCountApproximation(session);
    }
}

