/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation1;
import org.h2.expression.ValueExpression;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

public final class Regclass
extends Operation1 {
    public Regclass(Expression arg) {
        super(arg);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value value = this.arg.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int valueType = value.getValueType();
        if (valueType >= 9 && valueType <= 11) {
            return value.convertToInt(null);
        }
        if (valueType == 12) {
            return ValueInteger.get((int)value.getLong());
        }
        String name = value.getString();
        for (Schema schema : session.getDatabase().getAllSchemas()) {
            Table table = schema.findTableOrView(session, name);
            if (table != null && !table.isHidden()) {
                return ValueInteger.get(table.getId());
            }
            Index index = schema.findIndex(session, name);
            if (index == null || index.getCreateSQL() == null) continue;
            return ValueInteger.get(index.getId());
        }
        throw DbException.get(42102, name);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_INTEGER;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        if (this.arg.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.arg.getSQL(builder, sqlFlags, 0).append("::REGCLASS");
    }

    @Override
    public int getCost() {
        return this.arg.getCost() + 100;
    }
}

