/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.util.HashMap;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.DateTimeFunction;
import org.h2.message.DbException;
import org.h2.mode.FunctionInfo;
import org.h2.mode.ModeFunction;
import org.h2.mode.ToDateParser;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueUuid;

public final class FunctionsOracle
extends ModeFunction {
    private static final int ADD_MONTHS = 2001;
    private static final int SYS_GUID = 2002;
    private static final int TO_DATE = 2003;
    private static final int TO_TIMESTAMP = 2004;
    private static final int TO_TIMESTAMP_TZ = 2005;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();

    public static FunctionsOracle getFunction(String upperName) {
        FunctionInfo info = FUNCTIONS.get(upperName);
        return info != null ? new FunctionsOracle(info) : null;
    }

    private FunctionsOracle(FunctionInfo info) {
        super(info);
    }

    @Override
    protected void checkParameterCount(int len) {
        int min = 0;
        int max = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 2004: 
            case 2005: {
                min = 1;
                max = 2;
                break;
            }
            case 2003: {
                min = 1;
                max = 3;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.info.type);
            }
        }
        if (len < min || len > max) {
            throw DbException.get(7001, this.info.name, min + ".." + max);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session);
        switch (this.info.type) {
            case 2002: {
                this.type = TypeInfo.getTypeInfo(6, 16L, 0, null);
                break;
            }
            default: {
                this.type = TypeInfo.getTypeInfo(this.info.returnDataType);
            }
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value result;
        Value[] values = this.getArgumentsValues(session, this.args);
        if (values == null) {
            return ValueNull.INSTANCE;
        }
        Value v0 = FunctionsOracle.getNullOrValue(session, this.args, values, 0);
        Value v1 = FunctionsOracle.getNullOrValue(session, this.args, values, 1);
        switch (this.info.type) {
            case 2001: {
                result = DateTimeFunction.dateadd(session, 1, v1.getInt(), v0);
                break;
            }
            case 2002: {
                result = ValueUuid.getNewRandom().convertTo(TypeInfo.TYPE_VARBINARY);
                break;
            }
            case 2003: {
                result = ToDateParser.toDate(session, v0.getString(), v1 == null ? null : v1.getString());
                break;
            }
            case 2004: {
                result = ToDateParser.toTimestamp(session, v0.getString(), v1 == null ? null : v1.getString());
                break;
            }
            case 2005: {
                result = ToDateParser.toTimestampTz(session, v0.getString(), v1 == null ? null : v1.getString());
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.info.type);
            }
        }
        return result;
    }

    static {
        FUNCTIONS.put("ADD_MONTHS", new FunctionInfo("ADD_MONTHS", 2001, 2, 20, true, true));
        FUNCTIONS.put("SYS_GUID", new FunctionInfo("SYS_GUID", 2002, 0, 6, false, false));
        FUNCTIONS.put("TO_DATE", new FunctionInfo("TO_DATE", 2003, -1, 20, true, true));
        FUNCTIONS.put("TO_TIMESTAMP", new FunctionInfo("TO_TIMESTAMP", 2004, -1, 20, true, true));
        FUNCTIONS.put("TO_TIMESTAMP_TZ", new FunctionInfo("TO_TIMESTAMP_TZ", 2005, -1, 21, true, true));
    }
}

