/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.h2.api.ErrorCode;
import org.h2.jdbc.JdbcException;
import org.h2.jdbc.JdbcSQLDataException;
import org.h2.jdbc.JdbcSQLException;
import org.h2.jdbc.JdbcSQLFeatureNotSupportedException;
import org.h2.jdbc.JdbcSQLIntegrityConstraintViolationException;
import org.h2.jdbc.JdbcSQLInvalidAuthorizationSpecException;
import org.h2.jdbc.JdbcSQLNonTransientConnectionException;
import org.h2.jdbc.JdbcSQLNonTransientException;
import org.h2.jdbc.JdbcSQLSyntaxErrorException;
import org.h2.jdbc.JdbcSQLTimeoutException;
import org.h2.jdbc.JdbcSQLTransactionRollbackException;
import org.h2.jdbc.JdbcSQLTransientException;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final String HIDE_SQL = "--hide--";
    private static final Properties MESSAGES = new Properties();
    public static final SQLException SQL_OOME = new SQLException("OutOfMemoryError", "HY000", 90108, new OutOfMemoryError());
    private static final DbException OOME = new DbException(SQL_OOME);
    private Object source;

    private DbException(SQLException e) {
        super(e.getMessage(), e);
    }

    private static String translate(String key, String ... params) {
        String message = MESSAGES.getProperty(key);
        if (message == null) {
            message = "(Message " + key + " not found)";
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                String s = params[i];
                if (s == null || s.length() <= 0) continue;
                params[i] = DbException.quote(s);
            }
            message = MessageFormat.format(message, params);
        }
        return message;
    }

    private static String quote(String s) {
        int l = s.length();
        StringBuilder builder = new StringBuilder(l + 2).append('\"');
        int i = 0;
        while (i < l) {
            int cp = s.codePointAt(i);
            i += Character.charCount(cp);
            int t = Character.getType(cp);
            if (t == 0 || t >= 12 && t <= 19 && cp != 32) {
                if (cp <= 65535) {
                    StringUtils.appendHex(builder.append('\\'), cp, 2);
                    continue;
                }
                StringUtils.appendHex(builder.append("\\+"), cp, 3);
                continue;
            }
            if (cp == 34 || cp == 92) {
                builder.append((char)cp);
            }
            builder.appendCodePoint(cp);
        }
        return builder.append('\"').toString();
    }

    public SQLException getSQLException() {
        return (SQLException)this.getCause();
    }

    public int getErrorCode() {
        return this.getSQLException().getErrorCode();
    }

    public DbException addSQL(String sql) {
        SQLException e = this.getSQLException();
        if (e instanceof JdbcException) {
            JdbcException j = (JdbcException)((Object)e);
            if (j.getSQL() == null) {
                j.setSQL(DbException.filterSQL(sql));
            }
            return this;
        }
        e = DbException.getJdbcSQLException(e.getMessage(), sql, e.getSQLState(), e.getErrorCode(), e, null);
        return new DbException(e);
    }

    public static DbException get(int errorCode) {
        return DbException.get(errorCode, (String)null);
    }

    public static DbException get(int errorCode, String p1) {
        return DbException.get(errorCode, new String[]{p1});
    }

    public static DbException get(int errorCode, Throwable cause, String ... params) {
        return new DbException(DbException.getJdbcSQLException(errorCode, cause, params));
    }

    public static DbException get(int errorCode, String ... params) {
        return new DbException(DbException.getJdbcSQLException(errorCode, null, params));
    }

    public static DbException fromUser(String sqlstate, String message) {
        return new DbException(DbException.getJdbcSQLException(message, null, sqlstate, 0, null, null));
    }

    public static DbException getSyntaxError(String sql, int index) {
        sql = StringUtils.addAsterisk(sql, index);
        return DbException.get(42000, sql);
    }

    public static DbException getSyntaxError(String sql, int index, String message) {
        sql = StringUtils.addAsterisk(sql, index);
        return new DbException(DbException.getJdbcSQLException(42001, null, sql, message));
    }

    public static DbException getSyntaxError(int errorCode, String sql, int index, String ... params) {
        sql = StringUtils.addAsterisk(sql, index);
        String sqlstate = ErrorCode.getState(errorCode);
        String message = DbException.translate(sqlstate, params);
        return new DbException(DbException.getJdbcSQLException(message, sql, sqlstate, errorCode, null, null));
    }

    public static DbException getUnsupportedException(String message) {
        return DbException.get(50100, message);
    }

    public static DbException getInvalidValueException(String param, Object value) {
        return DbException.get(90008, value == null ? "null" : value.toString(), param);
    }

    public static DbException getValueTooLongException(String columnOrType, String value, long valueLength) {
        StringBuilder builder;
        int length = value.length();
        int m = valueLength >= 0L ? 22 : 0;
        StringBuilder stringBuilder = builder = length > 80 ? new StringBuilder(83 + m).append(value, 0, 80).append("...") : new StringBuilder(length + m).append(value);
        if (valueLength >= 0L) {
            builder.append(" (").append(valueLength).append(')');
        }
        return DbException.get(22001, columnOrType, builder.toString());
    }

    public static DbException getFileVersionError(String dataFileName) {
        return DbException.get(90048, "Old database: " + dataFileName + " - please convert the database to a SQL script and re-create it.");
    }

    public static RuntimeException getInternalError(String s) {
        RuntimeException e = new RuntimeException(s);
        DbException.traceThrowable(e);
        return e;
    }

    public static RuntimeException getInternalError() {
        return DbException.getInternalError("Unexpected code path");
    }

    public static SQLException toSQLException(Throwable e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        return DbException.convert(e).getSQLException();
    }

    public static DbException convert(Throwable e) {
        try {
            if (e instanceof DbException) {
                return (DbException)e;
            }
            if (e instanceof SQLException) {
                return new DbException((SQLException)e);
            }
            if (e instanceof InvocationTargetException) {
                return DbException.convertInvocation((InvocationTargetException)e, null);
            }
            if (e instanceof IOException) {
                return DbException.get(90028, e, e.toString());
            }
            if (e instanceof OutOfMemoryError) {
                return DbException.get(90108, e, new String[0]);
            }
            if (e instanceof StackOverflowError || e instanceof LinkageError) {
                return DbException.get(50000, e, e.toString());
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            return DbException.get(50000, e, e.toString());
        }
        catch (OutOfMemoryError ignore) {
            return OOME;
        }
        catch (Throwable ex) {
            try {
                DbException dbException = new DbException(new SQLException("GeneralError", "HY000", 50000, e));
                dbException.addSuppressed(ex);
                return dbException;
            }
            catch (OutOfMemoryError ignore) {
                return OOME;
            }
        }
    }

    public static DbException convertInvocation(InvocationTargetException te, String message) {
        Throwable t = te.getTargetException();
        if (t instanceof SQLException || t instanceof DbException) {
            return DbException.convert(t);
        }
        message = message == null ? t.getMessage() : message + ": " + t.getMessage();
        return DbException.get(90105, t, message);
    }

    public static DbException convertIOException(IOException e, String message) {
        if (message == null) {
            Throwable t = e.getCause();
            if (t instanceof DbException) {
                return (DbException)t;
            }
            return DbException.get(90028, e, e.toString());
        }
        return DbException.get(90031, e, e.toString(), message);
    }

    public static SQLException getJdbcSQLException(int errorCode) {
        return DbException.getJdbcSQLException(errorCode, (Throwable)null, new String[0]);
    }

    public static SQLException getJdbcSQLException(int errorCode, String p1) {
        return DbException.getJdbcSQLException(errorCode, null, p1);
    }

    public static SQLException getJdbcSQLException(int errorCode, Throwable cause, String ... params) {
        String sqlstate = ErrorCode.getState(errorCode);
        String message = DbException.translate(sqlstate, params);
        return DbException.getJdbcSQLException(message, null, sqlstate, errorCode, cause, null);
    }

    public static SQLException getJdbcSQLException(String message, String sql, String state, int errorCode, Throwable cause, String stackTrace) {
        sql = DbException.filterSQL(sql);
        switch (errorCode / 1000) {
            case 2: {
                return new JdbcSQLNonTransientException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 7: 
            case 21: 
            case 42: 
            case 54: {
                return new JdbcSQLSyntaxErrorException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 8: {
                return new JdbcSQLNonTransientConnectionException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 22: {
                return new JdbcSQLDataException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 23: {
                return new JdbcSQLIntegrityConstraintViolationException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 28: {
                return new JdbcSQLInvalidAuthorizationSpecException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 40: {
                return new JdbcSQLTransactionRollbackException(message, sql, state, errorCode, cause, stackTrace);
            }
        }
        switch (errorCode) {
            case 50000: 
            case 50004: 
            case 90001: 
            case 90002: 
            case 90006: 
            case 90007: 
            case 90019: 
            case 90021: 
            case 90024: 
            case 90025: 
            case 90028: 
            case 90029: 
            case 90031: 
            case 90034: 
            case 90040: 
            case 90044: 
            case 90058: 
            case 90062: 
            case 90063: 
            case 90064: 
            case 90065: 
            case 90096: 
            case 90097: 
            case 90101: 
            case 90102: 
            case 90103: 
            case 90104: 
            case 90105: 
            case 90111: 
            case 90124: 
            case 90125: 
            case 90126: 
            case 90127: 
            case 90128: 
            case 90130: 
            case 90134: 
            case 90140: 
            case 90148: {
                return new JdbcSQLNonTransientException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 50100: {
                return new JdbcSQLFeatureNotSupportedException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 50200: 
            case 57014: 
            case 90039: {
                return new JdbcSQLTimeoutException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 90000: 
            case 90005: 
            case 90015: 
            case 90016: 
            case 90017: 
            case 90022: 
            case 90023: 
            case 90032: 
            case 90033: 
            case 90035: 
            case 90036: 
            case 90037: 
            case 90038: 
            case 90041: 
            case 90042: 
            case 90043: 
            case 90045: 
            case 90052: 
            case 90054: 
            case 90057: 
            case 90059: 
            case 90068: 
            case 90069: 
            case 90070: 
            case 90071: 
            case 90072: 
            case 90073: 
            case 90074: 
            case 90075: 
            case 90076: 
            case 90077: 
            case 90078: 
            case 90079: 
            case 90080: 
            case 90081: 
            case 90082: 
            case 90083: 
            case 90084: 
            case 90085: 
            case 90086: 
            case 90087: 
            case 90089: 
            case 90090: 
            case 90091: 
            case 90106: 
            case 90107: 
            case 90109: 
            case 90110: 
            case 90114: 
            case 90115: 
            case 90116: 
            case 90118: 
            case 90119: 
            case 90120: 
            case 90122: 
            case 90123: 
            case 90129: 
            case 90132: 
            case 90136: 
            case 90137: 
            case 90139: 
            case 90141: 
            case 90145: 
            case 90150: 
            case 90151: 
            case 90152: 
            case 90153: 
            case 90154: 
            case 90155: 
            case 90156: 
            case 90157: {
                return new JdbcSQLSyntaxErrorException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 90003: 
            case 90004: 
            case 90008: 
            case 90009: 
            case 90010: 
            case 90012: 
            case 90014: 
            case 90026: 
            case 90027: 
            case 90053: 
            case 90056: 
            case 90095: 
            case 90142: {
                return new JdbcSQLDataException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 90011: 
            case 90013: 
            case 90018: 
            case 90020: 
            case 90030: 
            case 90046: 
            case 90047: 
            case 90048: 
            case 90049: 
            case 90050: 
            case 90055: 
            case 90060: 
            case 90061: 
            case 90066: 
            case 90067: 
            case 90088: 
            case 90093: 
            case 90094: 
            case 90098: 
            case 90099: 
            case 90108: 
            case 90113: 
            case 90117: 
            case 90121: 
            case 90133: 
            case 90135: 
            case 90138: 
            case 90144: 
            case 90146: 
            case 90147: 
            case 90149: {
                return new JdbcSQLNonTransientConnectionException(message, sql, state, errorCode, cause, stackTrace);
            }
            case 90112: 
            case 90131: 
            case 90143: {
                return new JdbcSQLTransientException(message, sql, state, errorCode, cause, stackTrace);
            }
        }
        return new JdbcSQLException(message, sql, state, errorCode, cause, stackTrace);
    }

    private static String filterSQL(String sql) {
        return sql == null || !sql.contains(HIDE_SQL) ? sql : "-";
    }

    public static String buildMessageForException(JdbcException e) {
        String s = e.getOriginalMessage();
        StringBuilder buff = new StringBuilder(s != null ? s : "- ");
        s = e.getSQL();
        if (s != null) {
            buff.append("; SQL statement:\n").append(s);
        }
        buff.append(" [").append(e.getErrorCode()).append('-').append(219).append(']');
        return buff.toString();
    }

    public static void printNextExceptions(SQLException e, PrintWriter s) {
        int i = 0;
        while ((e = e.getNextException()) != null) {
            if (i++ == 100) {
                s.println("(truncated)");
                return;
            }
            s.println(e.toString());
        }
    }

    public static void printNextExceptions(SQLException e, PrintStream s) {
        int i = 0;
        while ((e = e.getNextException()) != null) {
            if (i++ == 100) {
                s.println("(truncated)");
                return;
            }
            s.println(e.toString());
        }
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public static void traceThrowable(Throwable e) {
        PrintWriter writer = DriverManager.getLogWriter();
        if (writer != null) {
            e.printStackTrace(writer);
        }
    }

    static {
        try {
            byte[] translations;
            String language;
            byte[] messages = Utils.getResource("/org/h2/res/_messages_en.prop");
            if (messages != null) {
                MESSAGES.load(new ByteArrayInputStream(messages));
            }
            if (!"en".equals(language = Locale.getDefault().getLanguage()) && (translations = Utils.getResource("/org/h2/res/_messages_" + language + ".prop")) != null) {
                SortedProperties p = SortedProperties.fromLines(new String(translations, StandardCharsets.UTF_8));
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    String key = (String)e.getKey();
                    String translation = (String)e.getValue();
                    if (translation == null || translation.startsWith("#")) continue;
                    String original = MESSAGES.getProperty(key);
                    String message = translation + "\n" + original;
                    MESSAGES.put(key, message);
                }
            }
        }
        catch (IOException | OutOfMemoryError e) {
            DbException.traceThrowable(e);
        }
    }
}

