/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceBackwardsCompat;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXAConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.StringUtils;

public final class JdbcDataSource
extends TraceObject
implements XADataSource,
DataSource,
ConnectionPoolDataSource,
Serializable,
Referenceable,
JdbcDataSourceBackwardsCompat {
    private static final long serialVersionUID = 1288136338451857771L;
    private transient JdbcDataSourceFactory factory;
    private transient PrintWriter logWriter;
    private int loginTimeout;
    private String userName = "";
    private char[] passwordChars = new char[0];
    private String url = "";
    private String description;

    public JdbcDataSource() {
        this.initFactory();
        int id = JdbcDataSource.getNextId(12);
        this.setTrace(this.factory.getTrace(), 12, id);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initFactory();
        in.defaultReadObject();
    }

    private void initFactory() {
        this.factory = new JdbcDataSourceFactory();
    }

    @Override
    public int getLoginTimeout() {
        this.debugCodeCall("getLoginTimeout");
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int timeout) {
        this.debugCodeCall("setLoginTimeout", timeout);
        this.loginTimeout = timeout;
    }

    @Override
    public PrintWriter getLogWriter() {
        this.debugCodeCall("getLogWriter");
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
        this.debugCodeCall("setLogWriter(out)");
        this.logWriter = out;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        return new JdbcConnection(this.url, null, this.userName, StringUtils.cloneCharArray(this.passwordChars), false);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getConnection(" + JdbcDataSource.quote(user) + ", \"\")");
        }
        return new JdbcConnection(this.url, null, user, password, false);
    }

    public String getURL() {
        this.debugCodeCall("getURL");
        return this.url;
    }

    public void setURL(String url) {
        this.debugCodeCall("setURL", url);
        this.url = url;
    }

    public String getUrl() {
        this.debugCodeCall("getUrl");
        return this.url;
    }

    public void setUrl(String url) {
        this.debugCodeCall("setUrl", url);
        this.url = url;
    }

    public void setPassword(String password) {
        this.debugCodeCall("setPassword", "");
        this.passwordChars = password == null ? null : password.toCharArray();
    }

    public void setPasswordChars(char[] password) {
        if (this.isDebugEnabled()) {
            this.debugCode("setPasswordChars(new char[0])");
        }
        this.passwordChars = password;
    }

    private static String convertToString(char[] a) {
        return a == null ? null : new String(a);
    }

    public String getPassword() {
        this.debugCodeCall("getPassword");
        return JdbcDataSource.convertToString(this.passwordChars);
    }

    public String getUser() {
        this.debugCodeCall("getUser");
        return this.userName;
    }

    public void setUser(String user) {
        this.debugCodeCall("setUser", user);
        this.userName = user;
    }

    public String getDescription() {
        this.debugCodeCall("getDescription");
        return this.description;
    }

    public void setDescription(String description) {
        this.debugCodeCall("getDescription", description);
        this.description = description;
    }

    @Override
    public Reference getReference() {
        this.debugCodeCall("getReference");
        String factoryClassName = JdbcDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), factoryClassName, null);
        ref.add(new StringRefAddr("url", this.url));
        ref.add(new StringRefAddr("user", this.userName));
        ref.add(new StringRefAddr("password", JdbcDataSource.convertToString(this.passwordChars)));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        ref.add(new StringRefAddr("description", this.description));
        return ref;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        this.debugCodeCall("getXAConnection");
        return new JdbcXAConnection(this.factory, JdbcDataSource.getNextId(13), new JdbcConnection(this.url, null, this.userName, StringUtils.cloneCharArray(this.passwordChars), false));
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getXAConnection(" + JdbcDataSource.quote(user) + ", \"\")");
        }
        return new JdbcXAConnection(this.factory, JdbcDataSource.getNextId(13), new JdbcConnection(this.url, null, user, password, false));
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        this.debugCodeCall("getPooledConnection");
        return this.getXAConnection();
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        if (this.isDebugEnabled()) {
            this.debugCode("getPooledConnection(" + JdbcDataSource.quote(user) + ", \"\")");
        }
        return this.getXAConnection(user, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.userName;
    }
}

