/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcLob;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class JdbcSQLXML
extends JdbcLob
implements SQLXML {
    private static final Map<String, Boolean> secureFeatureMap = new HashMap<String, Boolean>();
    private static final EntityResolver NOOP_ENTITY_RESOLVER = (pubId, sysId) -> new InputSource(new StringReader(""));
    private static final URIResolver NOOP_URI_RESOLVER = (href, base) -> new StreamSource(new StringReader(""));
    private DOMResult domResult;
    private Closeable closable;

    public JdbcSQLXML(JdbcConnection conn, Value value, JdbcLob.State state, int id) {
        super(conn, value, state, 17, id);
    }

    @Override
    void checkReadable() throws SQLException, IOException {
        this.checkClosed();
        if (this.state == JdbcLob.State.SET_CALLED) {
            if (this.domResult != null) {
                Node node = this.domResult.getNode();
                this.domResult = null;
                TransformerFactory factory = TransformerFactory.newInstance();
                try {
                    Transformer transformer = factory.newTransformer();
                    DOMSource domSource = new DOMSource(node);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    transformer.transform(domSource, streamResult);
                    this.completeWrite(this.conn.createClob(new StringReader(stringWriter.toString()), -1L));
                }
                catch (Exception e) {
                    throw this.logAndConvert(e);
                }
                return;
            }
            if (this.closable != null) {
                this.closable.close();
                this.closable = null;
                return;
            }
            throw DbException.getUnsupportedException("Stream setter is not yet closed.");
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return super.getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return super.getCharacterStream();
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getSource(" + (sourceClass != null ? sourceClass.getSimpleName() + ".class" : "null") + ')');
            }
            this.checkReadable();
            if (sourceClass == null || sourceClass == DOMSource.class) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                for (Map.Entry<String, Boolean> entry : secureFeatureMap.entrySet()) {
                    try {
                        dbf.setFeature(entry.getKey(), entry.getValue());
                    }
                    catch (Exception exception) {}
                }
                dbf.setXIncludeAware(false);
                dbf.setExpandEntityReferences(false);
                dbf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                DocumentBuilder db = dbf.newDocumentBuilder();
                db.setEntityResolver(NOOP_ENTITY_RESOLVER);
                return (T)new DOMSource(db.parse(new InputSource(this.value.getInputStream())));
            }
            if (sourceClass == SAXSource.class) {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                for (Map.Entry<String, Boolean> entry : secureFeatureMap.entrySet()) {
                    try {
                        spf.setFeature(entry.getKey(), entry.getValue());
                    }
                    catch (Exception exception) {}
                }
                XMLReader reader = spf.newSAXParser().getXMLReader();
                reader.setEntityResolver(NOOP_ENTITY_RESOLVER);
                return (T)new SAXSource(reader, new InputSource(this.value.getInputStream()));
            }
            if (sourceClass == StAXSource.class) {
                XMLInputFactory xif = XMLInputFactory.newInstance();
                xif.setProperty("javax.xml.stream.supportDTD", false);
                xif.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                return (T)new StAXSource(xif.createXMLStreamReader(this.value.getInputStream()));
            }
            if (sourceClass == StreamSource.class) {
                TransformerFactory tf = TransformerFactory.newInstance();
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                tf.setURIResolver(NOOP_URI_RESOLVER);
                tf.newTransformer().transform(new StreamSource(this.value.getInputStream()), new SAXResult(new DefaultHandler()));
                return (T)new StreamSource(this.value.getInputStream());
            }
            throw this.unsupported(sourceClass.getName());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getString() throws SQLException {
        try {
            this.debugCodeCall("getString");
            this.checkReadable();
            return this.value.getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("setBinaryStream");
            this.checkEditable();
            this.state = JdbcLob.State.SET_CALLED;
            return new BufferedOutputStream(this.setClobOutputStreamImpl());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("setCharacterStream");
            this.checkEditable();
            this.state = JdbcLob.State.SET_CALLED;
            return this.setCharacterStreamImpl();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setResult(" + (resultClass != null ? resultClass.getSimpleName() + ".class" : "null") + ')');
            }
            this.checkEditable();
            if (resultClass == null || resultClass == DOMResult.class) {
                this.domResult = new DOMResult();
                this.state = JdbcLob.State.SET_CALLED;
                return (T)this.domResult;
            }
            if (resultClass == SAXResult.class) {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
                Writer writer = this.setCharacterStreamImpl();
                transformerHandler.setResult(new StreamResult(writer));
                SAXResult saxResult = new SAXResult(transformerHandler);
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)saxResult;
            }
            if (resultClass == StAXResult.class) {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                Writer writer = this.setCharacterStreamImpl();
                StAXResult staxResult = new StAXResult(xof.createXMLStreamWriter(writer));
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)staxResult;
            }
            if (StreamResult.class.equals(resultClass)) {
                Writer writer = this.setCharacterStreamImpl();
                StreamResult streamResult = new StreamResult(writer);
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)streamResult;
            }
            throw this.unsupported(resultClass.getName());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSource", value);
            }
            this.checkEditable();
            this.completeWrite(this.conn.createClob(new StringReader(value), -1L));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    static {
        secureFeatureMap.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        secureFeatureMap.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        secureFeatureMap.put("http://xml.org/sax/features/external-general-entities", false);
        secureFeatureMap.put("http://xml.org/sax/features/external-parameter-entities", false);
        secureFeatureMap.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }
}

