/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.MathUtils;
import org.h2.value.DataType;
import org.h2.value.ValueToObjectConverter;

public final class JdbcResultSetMetaData
extends TraceObject
implements ResultSetMetaData {
    private final String catalog;
    private final JdbcResultSet rs;
    private final JdbcPreparedStatement prep;
    private final ResultInterface result;
    private final int columnCount;

    JdbcResultSetMetaData(JdbcResultSet rs, JdbcPreparedStatement prep, ResultInterface result, String catalog, Trace trace, int id) {
        this.setTrace(trace, 5, id);
        this.catalog = catalog;
        this.rs = rs;
        this.prep = prep;
        this.result = result;
        this.columnCount = result.getVisibleColumnCount();
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            this.debugCodeCall("getColumnCount");
            this.checkClosed();
            return this.columnCount;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            return this.result.getAlias(this.getColumn("getColumnLabel", column));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        try {
            return this.result.getColumnName(this.getColumn("getColumnName", column));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            return DataType.convertTypeToSQLType(this.result.getColumnType(this.getColumn("getColumnType", column)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            return this.result.getColumnType(this.getColumn("getColumnTypeName", column)).getDeclaredTypeName();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        try {
            String schema = this.result.getSchemaName(this.getColumn("getSchemaName", column));
            return schema == null ? "" : schema;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getTableName(int column) throws SQLException {
        try {
            String table = this.result.getTableName(this.getColumn("getTableName", column));
            return table == null ? "" : table;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        try {
            this.getColumn("getCatalogName", column);
            return this.catalog == null ? "" : this.catalog;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        try {
            return this.result.isIdentity(this.getColumn("isAutoIncrement", column));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        try {
            this.getColumn("isCaseSensitive", column);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        try {
            this.getColumn("isSearchable", column);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        try {
            this.getColumn("isCurrency", column);
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        try {
            return this.result.getNullable(this.getColumn("isNullable", column));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        try {
            return DataType.isNumericType(this.result.getColumnType(this.getColumn("isSigned", column)).getValueType());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        try {
            this.getColumn("isReadOnly", column);
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        try {
            this.getColumn("isWritable", column);
            return true;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        try {
            this.getColumn("isDefinitelyWritable", column);
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        try {
            int type = this.result.getColumnType(this.getColumn("getColumnClassName", column)).getValueType();
            return ValueToObjectConverter.getDefaultClass(type, true).getName();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        try {
            return MathUtils.convertLongToInt(this.result.getColumnType(this.getColumn("getPrecision", column)).getPrecision());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        try {
            return this.result.getColumnType(this.getColumn("getScale", column)).getScale();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        try {
            return this.result.getColumnType(this.getColumn("getColumnDisplaySize", column)).getDisplaySize();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void checkClosed() {
        if (this.rs != null) {
            this.rs.checkClosed();
        }
        if (this.prep != null) {
            this.prep.checkClosed();
        }
    }

    private int getColumn(String methodName, int columnIndex) {
        this.debugCodeCall(methodName, columnIndex);
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw DbException.getInvalidValueException("columnIndex", columnIndex);
        }
        return columnIndex - 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": columns=" + this.columnCount;
    }
}

