/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.h2.command.CommandInterface;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcArray;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcLob;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcSQLXML;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.result.UpdatableRow;
import org.h2.util.IOUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueToObjectConverter;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

public final class JdbcResultSet
extends TraceObject
implements ResultSet {
    private final boolean scrollable;
    private final boolean updatable;
    private final boolean triggerUpdatable;
    ResultInterface result;
    private JdbcConnection conn;
    private JdbcStatement stat;
    private int columnCount;
    private boolean wasNull;
    private Value[] insertRow;
    private Value[] updateRow;
    private HashMap<String, Integer> columnLabelMap;
    private HashMap<Long, Value[]> patchedRows;
    private JdbcPreparedStatement preparedStatement;
    private final CommandInterface command;

    public JdbcResultSet(JdbcConnection conn, JdbcStatement stat, CommandInterface command, ResultInterface result, int id, boolean scrollable, boolean updatable, boolean triggerUpdatable) {
        this.setTrace(conn.getSession().getTrace(), 4, id);
        this.conn = conn;
        this.stat = stat;
        this.command = command;
        this.result = result;
        this.columnCount = result.getVisibleColumnCount();
        this.scrollable = scrollable;
        this.updatable = updatable;
        this.triggerUpdatable = triggerUpdatable;
    }

    JdbcResultSet(JdbcConnection conn, JdbcPreparedStatement preparedStatement, CommandInterface command, ResultInterface result, int id, boolean scrollable, boolean updatable, HashMap<String, Integer> columnLabelMap) {
        this(conn, (JdbcStatement)preparedStatement, command, result, id, scrollable, updatable, false);
        this.columnLabelMap = columnLabelMap;
        this.preparedStatement = preparedStatement;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.debugCodeCall("next");
            this.checkClosed();
            return this.nextRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(5);
            this.debugCodeAssign("ResultSetMetaData", 5, id, "getMetaData()");
            this.checkClosed();
            String catalog = this.conn.getCatalog();
            return new JdbcResultSetMetaData(this, null, this.result, catalog, this.conn.getSession().getTrace(), id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            this.debugCodeCall("wasNull");
            this.checkClosed();
            return this.wasNull;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("findColumn", columnLabel);
            return this.getColumnIndex(columnLabel);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            this.closeInternal(false);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    void closeInternal(boolean fromStatement) {
        if (this.result != null) {
            try {
                if (this.result.isLazy()) {
                    this.stat.onLazyResultSetClose(this.command, this.preparedStatement == null);
                }
                this.result.close();
            }
            finally {
                JdbcStatement s = this.stat;
                this.columnCount = 0;
                this.result = null;
                this.stat = null;
                this.conn = null;
                this.insertRow = null;
                this.updateRow = null;
                if (!fromStatement && s != null) {
                    s.closeIfCloseOnCompletion();
                }
            }
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            this.debugCodeCall("getStatement");
            this.checkClosed();
            return this.stat;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getString", columnIndex);
            return this.get(this.checkColumnIndex(columnIndex)).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getString", columnLabel);
            return this.get(this.getColumnIndex(columnLabel)).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getInt", columnIndex);
            return this.getIntInternal(this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getInt", columnLabel);
            return this.getIntInternal(this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private int getIntInternal(int columnIndex) {
        int result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = v.getInt();
        } else {
            this.wasNull = true;
            result = 0;
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", columnIndex);
            return this.get(this.checkColumnIndex(columnIndex)).getBigDecimal();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getDate", columnIndex);
            return LegacyDateTimeUtils.toDate(this.conn, null, this.get(this.checkColumnIndex(columnIndex)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getTime", columnIndex);
            return LegacyDateTimeUtils.toTime(this.conn, null, this.get(this.checkColumnIndex(columnIndex)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", columnIndex);
            return LegacyDateTimeUtils.toTimestamp(this.conn, null, this.get(this.checkColumnIndex(columnIndex)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBigDecimal", columnLabel);
            return this.get(this.getColumnIndex(columnLabel)).getBigDecimal();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getDate", columnLabel);
            return LegacyDateTimeUtils.toDate(this.conn, null, this.get(this.getColumnIndex(columnLabel)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getTime", columnLabel);
            return LegacyDateTimeUtils.toTime(this.conn, null, this.get(this.getColumnIndex(columnLabel)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getTimestamp", columnLabel);
            return LegacyDateTimeUtils.toTimestamp(this.conn, null, this.get(this.getColumnIndex(columnLabel)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getObject", columnIndex);
            return ValueToObjectConverter.valueToDefaultObject(this.get(this.checkColumnIndex(columnIndex)), this.conn, true);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getObject", columnLabel);
            return ValueToObjectConverter.valueToDefaultObject(this.get(this.getColumnIndex(columnLabel)), this.conn, true);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", columnIndex);
            return this.getBooleanInternal(this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBoolean", columnLabel);
            return this.getBooleanInternal(this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private boolean getBooleanInternal(int columnIndex) {
        boolean result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = v.getBoolean();
        } else {
            this.wasNull = true;
            result = false;
        }
        return result;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getByte", columnIndex);
            return this.getByteInternal(this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getByte", columnLabel);
            return this.getByteInternal(this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private byte getByteInternal(int columnIndex) {
        byte result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = v.getByte();
        } else {
            this.wasNull = true;
            result = 0;
        }
        return result;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getShort", columnIndex);
            return this.getShortInternal(this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getShort", columnLabel);
            return this.getShortInternal(this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private short getShortInternal(int columnIndex) {
        short result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = v.getShort();
        } else {
            this.wasNull = true;
            result = 0;
        }
        return result;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getLong", columnIndex);
            return this.getLongInternal(this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getLong", columnLabel);
            return this.getLongInternal(this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private long getLongInternal(int columnIndex) {
        long result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = v.getLong();
        } else {
            this.wasNull = true;
            result = 0L;
        }
        return result;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getFloat", columnIndex);
            return this.getFloatInternal(this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getFloat", columnLabel);
            return this.getFloatInternal(this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private float getFloatInternal(int columnIndex) {
        float result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = v.getFloat();
        } else {
            this.wasNull = true;
            result = 0.0f;
        }
        return result;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getDouble", columnIndex);
            return this.getDoubleInternal(this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getDouble", columnLabel);
            return this.getDoubleInternal(this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private double getDoubleInternal(int columnIndex) {
        double result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = v.getDouble();
        } else {
            this.wasNull = true;
            result = 0.0;
        }
        return result;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + JdbcResultSet.quote(columnLabel) + ", " + scale + ')');
            }
            if (scale < 0) {
                throw DbException.getInvalidValueException("scale", scale);
            }
            BigDecimal bd = this.get(this.getColumnIndex(columnLabel)).getBigDecimal();
            return bd == null ? null : ValueNumeric.setScale(bd, scale);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getBigDecimal(" + columnIndex + ", " + scale + ')');
            }
            if (scale < 0) {
                throw DbException.getInvalidValueException("scale", scale);
            }
            BigDecimal bd = this.get(this.checkColumnIndex(columnIndex)).getBigDecimal();
            return bd == null ? null : ValueNumeric.setScale(bd, scale);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw this.unsupported("map");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + columnIndex + ", calendar)");
            }
            return LegacyDateTimeUtils.toDate(this.conn, calendar != null ? calendar.getTimeZone() : null, this.get(this.checkColumnIndex(columnIndex)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getDate(" + JdbcResultSet.quote(columnLabel) + ", calendar)");
            }
            return LegacyDateTimeUtils.toDate(this.conn, calendar != null ? calendar.getTimeZone() : null, this.get(this.getColumnIndex(columnLabel)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + columnIndex + ", calendar)");
            }
            return LegacyDateTimeUtils.toTime(this.conn, calendar != null ? calendar.getTimeZone() : null, this.get(this.checkColumnIndex(columnIndex)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTime(" + JdbcResultSet.quote(columnLabel) + ", calendar)");
            }
            return LegacyDateTimeUtils.toTime(this.conn, calendar != null ? calendar.getTimeZone() : null, this.get(this.getColumnIndex(columnLabel)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + columnIndex + ", calendar)");
            }
            return LegacyDateTimeUtils.toTimestamp(this.conn, calendar != null ? calendar.getTimeZone() : null, this.get(this.checkColumnIndex(columnIndex)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getTimestamp(" + JdbcResultSet.quote(columnLabel) + ", calendar)");
            }
            return LegacyDateTimeUtils.toTimestamp(this.conn, calendar != null ? calendar.getTimeZone() : null, this.get(this.getColumnIndex(columnLabel)));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(9);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Blob", 9, id, "getBlob(" + columnIndex + ')');
            }
            return this.getBlob(id, this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(9);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Blob", 9, id, "getBlob(" + JdbcResultSet.quote(columnLabel) + ')');
            }
            return this.getBlob(id, this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private JdbcBlob getBlob(int id, int columnIndex) {
        JdbcBlob result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = new JdbcBlob(this.conn, v, JdbcLob.State.WITH_VALUE, id);
        } else {
            this.wasNull = true;
            result = null;
        }
        return result;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBytes", columnIndex);
            return this.get(this.checkColumnIndex(columnIndex)).getBytes();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBytes", columnLabel);
            return this.get(this.getColumnIndex(columnLabel)).getBytes();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", columnIndex);
            return this.get(this.checkColumnIndex(columnIndex)).getInputStream();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream", columnLabel);
            return this.get(this.getColumnIndex(columnLabel)).getInputStream();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Clob", 10, id, "getClob(" + columnIndex + ')');
            }
            return this.getClob(id, this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Clob", 10, id, "getClob(" + JdbcResultSet.quote(columnLabel) + ')');
            }
            return this.getClob(id, this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(16);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Array", 16, id, "getArray(" + columnIndex + ')');
            }
            return this.getArray(id, this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(16);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Array", 16, id, "getArray(" + JdbcResultSet.quote(columnLabel) + ')');
            }
            return this.getArray(id, this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private Array getArray(int id, int columnIndex) {
        JdbcArray result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = new JdbcArray(this.conn, v, id);
        } else {
            this.wasNull = true;
            result = null;
        }
        return result;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", columnIndex);
            String s = this.get(this.checkColumnIndex(columnIndex)).getString();
            return s == null ? null : IOUtils.getInputStreamFromString(s);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream", columnLabel);
            String s = this.get(this.getColumnIndex(columnLabel)).getString();
            return IOUtils.getInputStreamFromString(s);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", columnIndex);
            return this.get(this.checkColumnIndex(columnIndex)).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream", columnLabel);
            return this.get(this.getColumnIndex(columnLabel)).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("updateNull", columnIndex);
            this.update(this.checkColumnIndex(columnIndex), ValueNull.INSTANCE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("updateNull", columnLabel);
            this.update(this.getColumnIndex(columnLabel), ValueNull.INSTANCE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + columnIndex + ", " + x + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), ValueBoolean.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBoolean(" + JdbcResultSet.quote(columnLabel) + ", " + x + ')');
            }
            this.update(this.getColumnIndex(columnLabel), ValueBoolean.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + columnIndex + ", " + x + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), ValueTinyint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateByte(" + JdbcResultSet.quote(columnLabel) + ", " + x + ')');
            }
            this.update(this.getColumnIndex(columnLabel), ValueTinyint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + columnIndex + ", x)");
            }
            this.update(this.checkColumnIndex(columnIndex), x == null ? ValueNull.INSTANCE : ValueVarbinary.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBytes(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.update(this.getColumnIndex(columnLabel), x == null ? ValueNull.INSTANCE : ValueVarbinary.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + columnIndex + ", (short) " + x + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), ValueSmallint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateShort(" + JdbcResultSet.quote(columnLabel) + ", (short) " + x + ')');
            }
            this.update(this.getColumnIndex(columnLabel), ValueSmallint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + columnIndex + ", " + x + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), ValueInteger.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateInt(" + JdbcResultSet.quote(columnLabel) + ", " + x + ')');
            }
            this.update(this.getColumnIndex(columnLabel), ValueInteger.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + columnIndex + ", " + x + "L)");
            }
            this.update(this.checkColumnIndex(columnIndex), ValueBigint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateLong(" + JdbcResultSet.quote(columnLabel) + ", " + x + "L)");
            }
            this.update(this.getColumnIndex(columnLabel), ValueBigint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + columnIndex + ", " + x + "f)");
            }
            this.update(this.checkColumnIndex(columnIndex), ValueReal.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateFloat(" + JdbcResultSet.quote(columnLabel) + ", " + x + "f)");
            }
            this.update(this.getColumnIndex(columnLabel), ValueReal.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + columnIndex + ", " + x + "d)");
            }
            this.update(this.checkColumnIndex(columnIndex), ValueDouble.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDouble(" + JdbcResultSet.quote(columnLabel) + ", " + x + "d)");
            }
            this.update(this.getColumnIndex(columnLabel), ValueDouble.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + columnIndex + ", " + JdbcResultSet.quoteBigDecimal(x) + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), x == null ? ValueNull.INSTANCE : ValueNumeric.getAnyScale(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBigDecimal(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quoteBigDecimal(x) + ')');
            }
            this.update(this.getColumnIndex(columnLabel), x == null ? ValueNull.INSTANCE : ValueNumeric.getAnyScale(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + columnIndex + ", " + JdbcResultSet.quote(x) + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), x == null ? ValueNull.INSTANCE : ValueVarchar.get(x, this.conn));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateString(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quote(x) + ')');
            }
            this.update(this.getColumnIndex(columnLabel), x == null ? ValueNull.INSTANCE : ValueVarchar.get(x, this.conn));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + columnIndex + ", " + JdbcResultSet.quoteDate(x) + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromDate(this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateDate(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quoteDate(x) + ')');
            }
            this.update(this.getColumnIndex(columnLabel), x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromDate(this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + columnIndex + ", " + JdbcResultSet.quoteTime(x) + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTime(this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTime(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quoteTime(x) + ')');
            }
            this.update(this.getColumnIndex(columnLabel), x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTime(this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + columnIndex + ", " + JdbcResultSet.quoteTimestamp(x) + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTimestamp((CastDataProvider)this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateTimestamp(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quoteTimestamp(x) + ')');
            }
            this.update(this.getColumnIndex(columnLabel), x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTimestamp((CastDataProvider)this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + columnIndex + ", x, " + length + ')');
            }
            this.updateAscii(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + columnIndex + ", x)");
            }
            this.updateAscii(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + columnIndex + ", x, " + length + "L)");
            }
            this.updateAscii(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + ')');
            }
            this.updateAscii(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.updateAscii(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateAsciiStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L)");
            }
            this.updateAscii(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void updateAscii(int columnIndex, InputStream x, long length) {
        this.update(columnIndex, this.conn.createClob(IOUtils.getAsciiReader(x), length));
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + columnIndex + ", x, " + length + ')');
            }
            this.updateBlobImpl(this.checkColumnIndex(columnIndex), x, (long)length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + columnIndex + ", x)");
            }
            this.updateBlobImpl(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + columnIndex + ", x, " + length + "L)");
            }
            this.updateBlobImpl(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.updateBlobImpl(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + ')');
            }
            this.updateBlobImpl(this.getColumnIndex(columnLabel), x, (long)length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBinaryStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L)");
            }
            this.updateBlobImpl(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + columnIndex + ", x, " + length + "L)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + columnIndex + ", x, " + length + ')');
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + columnIndex + ", x)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + ')');
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateCharacterStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + columnIndex + ", x, " + scale + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(columnLabel) + ", x, " + scale + ')');
            }
            this.update(this.getColumnIndex(columnLabel), this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + columnIndex + ", x)");
            }
            this.update(this.checkColumnIndex(columnIndex), this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.update(this.getColumnIndex(columnLabel), this.convertToUnknownValue(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + columnIndex + ", x, " + DataType.sqlTypeToString(targetSqlType) + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), this.convertToValue(x, targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + columnIndex + ", x, " + DataType.sqlTypeToString(targetSqlType) + ", " + scaleOrLength + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), this.convertToValue(x, targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(columnLabel) + ", x, " + DataType.sqlTypeToString(targetSqlType) + ')');
            }
            this.update(this.getColumnIndex(columnLabel), this.convertToValue(x, targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateObject(" + JdbcResultSet.quote(columnLabel) + ", x, " + DataType.sqlTypeToString(targetSqlType) + ", " + scaleOrLength + ')');
            }
            this.update(this.getColumnIndex(columnLabel), this.convertToValue(x, targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + columnIndex + ", (InputStream) x)");
            }
            this.updateBlobImpl(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + columnIndex + ", (InputStream) x, " + length + "L)");
            }
            this.updateBlobImpl(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + columnIndex + ", (Blob) x)");
            }
            this.updateBlobImpl(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + JdbcResultSet.quote(columnLabel) + ", (Blob) x)");
            }
            this.updateBlobImpl(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void updateBlobImpl(int columnIndex, Blob x, long length) throws SQLException {
        this.update(columnIndex, x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), length));
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + JdbcResultSet.quote(columnLabel) + ", (InputStream) x)");
            }
            this.updateBlobImpl(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateBlob(" + JdbcResultSet.quote(columnLabel) + ", (InputStream) x, " + length + "L)");
            }
            this.updateBlobImpl(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void updateBlobImpl(int columnIndex, InputStream x, long length) {
        this.update(columnIndex, this.conn.createBlob(x, length));
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + columnIndex + ", (Clob) x)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + columnIndex + ", (Reader) x)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + columnIndex + ", (Reader) x, " + length + "L)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + JdbcResultSet.quote(columnLabel) + ", (Clob) x)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + JdbcResultSet.quote(columnLabel) + ", (Reader) x)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateClob(" + JdbcResultSet.quote(columnLabel) + ", (Reader) x, " + length + "L)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateArray(" + columnIndex + ", x)");
            }
            this.updateArrayImpl(this.checkColumnIndex(columnIndex), x);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateArray(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.updateArrayImpl(this.getColumnIndex(columnLabel), x);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void updateArrayImpl(int columnIndex, Array x) throws SQLException {
        this.update(columnIndex, x == null ? ValueNull.INSTANCE : ValueToObjectConverter.objectToValue(this.stat.session, x.getArray(), 40));
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.unsupported("cursorName");
    }

    @Override
    public int getRow() throws SQLException {
        try {
            this.debugCodeCall("getRow");
            this.checkClosed();
            if (this.result.isAfterLast()) {
                return 0;
            }
            long rowNumber = this.result.getRowId() + 1L;
            return rowNumber <= Integer.MAX_VALUE ? (int)rowNumber : -2;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getConcurrency");
            this.checkClosed();
            if (!this.updatable) {
                return 1007;
            }
            UpdatableRow row = new UpdatableRow(this.conn, this.result);
            return row.isUpdatable() ? 1008 : 1007;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.result.getFetchSize();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", rows);
            this.checkClosed();
            if (rows < 0) {
                throw DbException.getInvalidValueException("rows", rows);
            }
            if (rows > 0) {
                int maxRows;
                if (this.stat != null && (maxRows = this.stat.getMaxRows()) > 0 && rows > maxRows) {
                    throw DbException.getInvalidValueException("rows", rows);
                }
            } else {
                rows = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.result.setFetchSize(rows);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.debugCodeCall("setFetchDirection", direction);
        if (direction != 1000) {
            throw this.unsupported("setFetchDirection");
        }
    }

    @Override
    public int getType() throws SQLException {
        try {
            this.debugCodeCall("getType");
            this.checkClosed();
            return this.stat == null ? 1003 : this.stat.resultSetType;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            this.debugCodeCall("isBeforeFirst");
            this.checkClosed();
            return this.result.getRowId() < 0L && this.result.hasNext();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            this.debugCodeCall("isAfterLast");
            this.checkClosed();
            return this.result.getRowId() > 0L && this.result.isAfterLast();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            this.debugCodeCall("isFirst");
            this.checkClosed();
            return this.result.getRowId() == 0L && !this.result.isAfterLast();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            this.debugCodeCall("isLast");
            this.checkClosed();
            long rowId = this.result.getRowId();
            return rowId >= 0L && !this.result.isAfterLast() && !this.result.hasNext();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            this.debugCodeCall("beforeFirst");
            this.checkClosed();
            if (this.result.getRowId() >= 0L) {
                this.resetResult();
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            this.debugCodeCall("afterLast");
            this.checkClosed();
            while (this.nextRow()) {
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            this.debugCodeCall("first");
            this.checkClosed();
            if (this.result.getRowId() >= 0L) {
                this.resetResult();
            }
            return this.nextRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            this.debugCodeCall("last");
            this.checkClosed();
            if (this.result.isAfterLast()) {
                this.resetResult();
            }
            while (this.result.hasNext()) {
                this.nextRow();
            }
            return this.isOnValidRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean absolute(int rowNumber) throws SQLException {
        try {
            long longRowNumber;
            this.debugCodeCall("absolute", rowNumber);
            this.checkClosed();
            long l = longRowNumber = rowNumber >= 0 ? (long)rowNumber : this.result.getRowCount() + (long)rowNumber + 1L;
            if (--longRowNumber < this.result.getRowId()) {
                this.resetResult();
            }
            while (this.result.getRowId() < longRowNumber) {
                if (this.nextRow()) continue;
                return false;
            }
            return this.isOnValidRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean relative(int rowCount) throws SQLException {
        try {
            long longRowCount;
            this.debugCodeCall("relative", rowCount);
            this.checkClosed();
            if (rowCount < 0) {
                longRowCount = this.result.getRowId() + (long)rowCount + 1L;
                this.resetResult();
            } else {
                longRowCount = rowCount;
            }
            while (longRowCount-- > 0L) {
                if (this.nextRow()) continue;
                return false;
            }
            return this.isOnValidRow();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            this.debugCodeCall("previous");
            this.checkClosed();
            return this.relative(-1);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            this.debugCodeCall("moveToInsertRow");
            this.checkUpdatable();
            this.insertRow = new Value[this.columnCount];
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            this.debugCodeCall("moveToCurrentRow");
            this.checkUpdatable();
            this.insertRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            this.debugCodeCall("rowUpdated");
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            this.debugCodeCall("rowInserted");
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            this.debugCodeCall("rowDeleted");
            return false;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            this.debugCodeCall("insertRow");
            this.checkUpdatable();
            if (this.insertRow == null) {
                throw DbException.get(90029);
            }
            this.getUpdatableRow().insertRow(this.insertRow);
            this.insertRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            this.debugCodeCall("updateRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            if (this.updateRow != null) {
                int i;
                UpdatableRow row = this.getUpdatableRow();
                Value[] current = new Value[this.columnCount];
                for (i = 0; i < this.updateRow.length; ++i) {
                    current[i] = this.getInternal(this.checkColumnIndex(i + 1));
                }
                row.updateRow(current, this.updateRow);
                for (i = 0; i < this.updateRow.length; ++i) {
                    if (this.updateRow[i] != null) continue;
                    this.updateRow[i] = current[i];
                }
                Value[] patch = row.readRow(this.updateRow);
                this.patchCurrentRow(patch);
                this.updateRow = null;
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            this.debugCodeCall("deleteRow");
            this.checkUpdatable();
            if (this.insertRow != null) {
                throw DbException.get(90029);
            }
            this.checkOnValidRow();
            this.getUpdatableRow().deleteRow(this.result.currentRow());
            this.updateRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            this.debugCodeCall("refreshRow");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.checkOnValidRow();
            this.patchCurrentRow(this.getUpdatableRow().readRow(this.result.currentRow()));
            this.updateRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            this.debugCodeCall("cancelRowUpdates");
            this.checkClosed();
            if (this.insertRow != null) {
                throw DbException.get(2000);
            }
            this.updateRow = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private UpdatableRow getUpdatableRow() throws SQLException {
        UpdatableRow row = new UpdatableRow(this.conn, this.result);
        if (!row.isUpdatable()) {
            throw DbException.get(90127);
        }
        return row;
    }

    private int getColumnIndex(String columnLabel) {
        this.checkClosed();
        if (columnLabel == null) {
            throw DbException.getInvalidValueException("columnLabel", null);
        }
        if (this.columnCount >= 3) {
            Integer index;
            if (this.columnLabelMap == null) {
                int i;
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (i = 0; i < this.columnCount; ++i) {
                    String c = StringUtils.toUpperEnglish(this.result.getAlias(i));
                    map.putIfAbsent(c, i);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    String colName = this.result.getColumnName(i);
                    if (colName == null) continue;
                    colName = StringUtils.toUpperEnglish(colName);
                    map.putIfAbsent(colName, i);
                    String tabName = this.result.getTableName(i);
                    if (tabName == null) continue;
                    colName = StringUtils.toUpperEnglish(tabName) + '.' + colName;
                    map.putIfAbsent(colName, i);
                }
                this.columnLabelMap = map;
                if (this.preparedStatement != null) {
                    this.preparedStatement.setCachedColumnLabelMap(this.columnLabelMap);
                }
            }
            if ((index = this.columnLabelMap.get(StringUtils.toUpperEnglish(columnLabel))) == null) {
                throw DbException.get(42122, columnLabel);
            }
            return index + 1;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (!columnLabel.equalsIgnoreCase(this.result.getAlias(i))) continue;
            return i + 1;
        }
        int idx = columnLabel.indexOf(46);
        if (idx > 0) {
            String table = columnLabel.substring(0, idx);
            String col = columnLabel.substring(idx + 1);
            for (int i = 0; i < this.columnCount; ++i) {
                if (!table.equalsIgnoreCase(this.result.getTableName(i)) || !col.equalsIgnoreCase(this.result.getColumnName(i))) continue;
                return i + 1;
            }
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                if (!columnLabel.equalsIgnoreCase(this.result.getColumnName(i))) continue;
                return i + 1;
            }
        }
        throw DbException.get(42122, columnLabel);
    }

    private int checkColumnIndex(int columnIndex) {
        this.checkClosed();
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw DbException.getInvalidValueException("columnIndex", columnIndex);
        }
        return columnIndex;
    }

    void checkClosed() {
        if (this.result == null) {
            throw DbException.get(90007);
        }
        if (this.stat != null) {
            this.stat.checkClosed();
        }
        if (this.conn != null) {
            this.conn.checkClosed();
        }
    }

    private boolean isOnValidRow() {
        return this.result.getRowId() >= 0L && !this.result.isAfterLast();
    }

    private void checkOnValidRow() {
        if (!this.isOnValidRow()) {
            throw DbException.get(2000);
        }
    }

    private Value get(int columnIndex) {
        Value value = this.getInternal(columnIndex);
        this.wasNull = value == ValueNull.INSTANCE;
        return value;
    }

    public Value getInternal(int columnIndex) {
        Value[] list;
        this.checkOnValidRow();
        if (this.patchedRows == null || (list = this.patchedRows.get(this.result.getRowId())) == null) {
            list = this.result.currentRow();
        }
        return list[columnIndex - 1];
    }

    private void update(int columnIndex, Value v) {
        if (!this.triggerUpdatable) {
            this.checkUpdatable();
        }
        if (this.insertRow != null) {
            this.insertRow[columnIndex - 1] = v;
        } else {
            if (this.updateRow == null) {
                this.updateRow = new Value[this.columnCount];
            }
            this.updateRow[columnIndex - 1] = v;
        }
    }

    private boolean nextRow() {
        boolean next;
        boolean bl = next = this.result.isLazy() ? this.nextLazyRow() : this.result.next();
        if (!next && !this.scrollable) {
            this.result.close();
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nextLazyRow() {
        boolean next;
        Session session;
        if (this.stat.isCancelled() || this.conn == null || (session = this.conn.getSession()) == null) {
            throw DbException.get(57014);
        }
        Session oldSession = session.setThreadLocalSession();
        try {
            next = this.result.next();
        }
        finally {
            session.resetThreadLocalSession(oldSession);
        }
        return next;
    }

    private void resetResult() {
        if (!this.scrollable) {
            throw DbException.get(90128);
        }
        this.result.reset();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.conn.getHoldability();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.result == null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNString(" + columnIndex + ", " + JdbcResultSet.quote(x) + ')');
            }
            this.update(this.checkColumnIndex(columnIndex), x == null ? ValueNull.INSTANCE : ValueVarchar.get(x, this.conn));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNString(" + JdbcResultSet.quote(columnLabel) + ", " + JdbcResultSet.quote(x) + ')');
            }
            this.update(this.getColumnIndex(columnLabel), x == null ? ValueNull.INSTANCE : ValueVarchar.get(x, this.conn));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNClob(" + columnIndex + ", (NClob) x)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNClob(" + columnIndex + ", (Reader) x)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNClob(" + columnIndex + ", (Reader) x, " + length + "L)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNClob(" + JdbcResultSet.quote(columnLabel) + ", (Reader) x)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNClob(" + JdbcResultSet.quote(columnLabel) + ", (Reader) x, " + length + "L)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNClob(" + JdbcResultSet.quote(columnLabel) + ", (NClob) x)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void updateClobImpl(int columnIndex, Clob x) throws SQLException {
        this.update(columnIndex, x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("NClob", 10, id, "getNClob(" + columnIndex + ')');
            }
            return this.getClob(id, this.checkColumnIndex(columnIndex));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        try {
            int id = JdbcResultSet.getNextId(10);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("NClob", 10, id, "getNClob(" + JdbcResultSet.quote(columnLabel) + ')');
            }
            return this.getClob(id, this.getColumnIndex(columnLabel));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private JdbcClob getClob(int id, int columnIndex) {
        JdbcClob result;
        Value v = this.getInternal(columnIndex);
        if (v != ValueNull.INSTANCE) {
            this.wasNull = false;
            result = new JdbcClob(this.conn, v, JdbcLob.State.WITH_VALUE, id);
        } else {
            this.wasNull = true;
            result = null;
        }
        return result;
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(17);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("SQLXML", 17, id, "getSQLXML(" + columnIndex + ')');
            }
            return (v = this.get(this.checkColumnIndex(columnIndex))) == ValueNull.INSTANCE ? null : new JdbcSQLXML(this.conn, v, JdbcLob.State.WITH_VALUE, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        try {
            Value v;
            int id = JdbcResultSet.getNextId(17);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("SQLXML", 17, id, "getSQLXML(" + JdbcResultSet.quote(columnLabel) + ')');
            }
            return (v = this.get(this.getColumnIndex(columnLabel))) == ValueNull.INSTANCE ? null : new JdbcSQLXML(this.conn, v, JdbcLob.State.WITH_VALUE, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateSQLXML(" + columnIndex + ", x)");
            }
            this.updateSQLXMLImpl(this.checkColumnIndex(columnIndex), xmlObject);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateSQLXML(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.updateSQLXMLImpl(this.getColumnIndex(columnLabel), xmlObject);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void updateSQLXMLImpl(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.update(columnIndex, xmlObject == null ? ValueNull.INSTANCE : this.conn.createClob(xmlObject.getCharacterStream(), -1L));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getNString", columnIndex);
            return this.get(this.checkColumnIndex(columnIndex)).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getNString", columnLabel);
            return this.get(this.getColumnIndex(columnLabel)).getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", columnIndex);
            return this.get(this.checkColumnIndex(columnIndex)).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        try {
            this.debugCodeCall("getNCharacterStream", columnLabel);
            return this.get(this.getColumnIndex(columnLabel)).getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + columnIndex + ", x)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + columnIndex + ", x, " + length + "L)");
            }
            this.updateClobImpl(this.checkColumnIndex(columnIndex), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + JdbcResultSet.quote(columnLabel) + ", x)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, -1L);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("updateNCharacterStream(" + JdbcResultSet.quote(columnLabel) + ", x, " + length + "L)");
            }
            this.updateClobImpl(this.getColumnIndex(columnLabel), x, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void updateClobImpl(int columnIndex, Reader x, long length) {
        this.update(columnIndex, this.conn.createClob(x, length));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", iface);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            if (type == null) {
                throw DbException.getInvalidValueException("type", type);
            }
            this.debugCodeCall("getObject", columnIndex);
            return ValueToObjectConverter.valueToObject(type, this.get(this.checkColumnIndex(columnIndex)), this.conn);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        try {
            if (type == null) {
                throw DbException.getInvalidValueException("type", type);
            }
            this.debugCodeCall("getObject", columnName);
            return ValueToObjectConverter.valueToObject(type, this.get(this.getColumnIndex(columnName)), this.conn);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + this.result;
    }

    private void patchCurrentRow(Value[] row) {
        boolean changed = false;
        Value[] current = this.result.currentRow();
        CompareMode compareMode = this.conn.getCompareMode();
        for (int i = 0; i < row.length; ++i) {
            if (row[i].compareTo(current[i], this.conn, compareMode) == 0) continue;
            changed = true;
            break;
        }
        if (this.patchedRows == null) {
            this.patchedRows = new HashMap();
        }
        Long rowId = this.result.getRowId();
        if (!changed) {
            this.patchedRows.remove(rowId);
        } else {
            this.patchedRows.put(rowId, row);
        }
    }

    private Value convertToValue(Object x, SQLType targetSqlType) {
        if (x == null) {
            return ValueNull.INSTANCE;
        }
        int type = DataType.convertSQLTypeToValueType(targetSqlType);
        Value v = ValueToObjectConverter.objectToValue(this.conn.getSession(), x, type);
        return v.convertTo(type, (CastDataProvider)this.conn);
    }

    private Value convertToUnknownValue(Object x) {
        return ValueToObjectConverter.objectToValue(this.conn.getSession(), x, -1);
    }

    private void checkUpdatable() {
        this.checkClosed();
        if (!this.updatable) {
            throw DbException.get(90140);
        }
    }

    public Value[] getUpdateRow() {
        return this.updateRow;
    }

    public ResultInterface getResult() {
        return this.result;
    }
}

