/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcLob;
import org.h2.message.DbException;
import org.h2.store.RangeReader;
import org.h2.util.IOUtils;
import org.h2.value.Value;

public final class JdbcClob
extends JdbcLob
implements NClob {
    public JdbcClob(JdbcConnection conn, Value value, JdbcLob.State state, int id) {
        super(conn, value, state, 10, id);
    }

    @Override
    public long length() throws SQLException {
        try {
            long precision;
            this.debugCodeCall("length");
            this.checkReadable();
            if (this.value.getValueType() == 3 && (precision = this.value.getType().getPrecision()) > 0L) {
                return precision;
            }
            return IOUtils.copyAndCloseInput(this.value.getReader(), null, Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            this.debugCodeCall("getAsciiStream");
            this.checkReadable();
            String s = this.value.getString();
            return IOUtils.getInputStreamFromString(s);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw this.unsupported("LOB update");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return super.getCharacterStream();
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("setCharacterStream", pos);
            }
            this.checkEditable();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            this.state = JdbcLob.State.SET_CALLED;
            return this.setCharacterStreamImpl();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getSubString(" + pos + ", " + length + ')');
            }
            this.checkReadable();
            if (pos < 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (length < 0) {
                throw DbException.getInvalidValueException("length", length);
            }
            StringWriter writer = new StringWriter(Math.min(4096, length));
            try (Reader reader = this.value.getReader();){
                IOUtils.skipFully(reader, pos - 1L);
                IOUtils.copyAndCloseInput(reader, writer, length);
            }
            return writer.toString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + pos + ", " + JdbcClob.quote(str) + ')');
            }
            this.checkEditable();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (str == null) {
                throw DbException.getInvalidValueException("str", str);
            }
            this.completeWrite(this.conn.createClob(new StringReader(str), -1L));
            return str.length();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + pos + ", " + JdbcClob.quote(str) + ", " + offset + ", " + len + ')');
            }
            this.checkEditable();
            if (pos != 1L) {
                throw DbException.getInvalidValueException("pos", pos);
            }
            if (str == null) {
                throw DbException.getInvalidValueException("str", str);
            }
            this.completeWrite(this.conn.createClob(new RangeReader(new StringReader(str), offset, len), -1L));
            return (int)this.value.getType().getPrecision();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long position(String pattern, long start) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public long position(Clob clobPattern, long start) throws SQLException {
        throw this.unsupported("LOB search");
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getCharacterStream(" + pos + ", " + length + ')');
            }
            this.checkReadable();
            if (this.state == JdbcLob.State.NEW) {
                if (pos != 1L) {
                    throw DbException.getInvalidValueException("pos", pos);
                }
                if (length != 0L) {
                    throw DbException.getInvalidValueException("length", pos);
                }
            }
            return this.value.getReader(pos, length);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }
}

