/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.index.RangeCursor;
import org.h2.index.SingleRowCursor;
import org.h2.index.VirtualTableIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBigint;

public class RangeIndex
extends VirtualTableIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable table, IndexColumn[] columns) {
        super(table, "RANGE_INDEX", columns);
        this.rangeTable = table;
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last) {
        long v2;
        long min = this.rangeTable.getMin(session);
        long max = this.rangeTable.getMax(session);
        long step = this.rangeTable.getStep(session);
        if (step == 0L) {
            throw DbException.get(90142);
        }
        if (first != null) {
            try {
                v2 = first.getValue(0).getLong();
                if (step > 0L) {
                    if (v2 > min) {
                        min += (v2 - min + step - 1L) / step * step;
                    }
                } else if (v2 > max) {
                    max = v2;
                }
            }
            catch (DbException v2) {
                // empty catch block
            }
        }
        if (last != null) {
            try {
                v2 = last.getValue(0).getLong();
                if (step > 0L) {
                    if (v2 < max) {
                        max = v2;
                    }
                } else if (v2 < min) {
                    min -= (min - v2 - step - 1L) / step * step;
                }
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return new RangeCursor(min, max, step);
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(SessionLocal session, boolean first) {
        long min = this.rangeTable.getMin(session);
        long max = this.rangeTable.getMax(session);
        long step = this.rangeTable.getStep(session);
        if (step == 0L) {
            throw DbException.get(90142);
        }
        return new SingleRowCursor((step > 0L ? min <= max : min >= max) ? Row.get(new Value[]{ValueBigint.get(first ^ min >= max ? min : max)}, 1) : null);
    }

    @Override
    public String getPlanSQL() {
        return "range index";
    }
}

