/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.h2.command.Parser;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.command.query.Query;
import org.h2.command.query.SelectUnion;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.QueryExpressionCursor;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.QueryExpressionTable;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.value.Value;

public class QueryExpressionIndex
extends Index
implements SpatialIndex {
    private static final long MAX_AGE_NANOS = TimeUnit.MILLISECONDS.toNanos(10000L);
    private final QueryExpressionTable table;
    private final String querySQL;
    private final ArrayList<Parameter> originalParameters;
    private boolean recursive;
    private final int[] indexMasks;
    private Query query;
    private final SessionLocal createSession;
    private final long evaluatedAt;

    public QueryExpressionIndex(QueryExpressionTable table, String querySQL, ArrayList<Parameter> originalParameters, boolean recursive) {
        super(table, 0, null, null, 0, IndexType.createNonUnique(false));
        this.table = table;
        this.querySQL = querySQL;
        this.originalParameters = originalParameters;
        this.recursive = recursive;
        this.columns = new Column[0];
        this.createSession = null;
        this.indexMasks = null;
        this.evaluatedAt = Long.MIN_VALUE;
    }

    public QueryExpressionIndex(QueryExpressionTable table, QueryExpressionIndex index, SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder) {
        super(table, 0, null, null, 0, IndexType.createNonUnique(false));
        this.table = table;
        this.querySQL = index.querySQL;
        this.originalParameters = index.originalParameters;
        this.recursive = index.recursive;
        this.indexMasks = masks;
        this.createSession = session;
        this.columns = new Column[0];
        if (!this.recursive) {
            this.query = this.getQuery(session, masks);
        }
        if (this.recursive || table.getTopQuery() != null) {
            this.evaluatedAt = Long.MAX_VALUE;
        } else {
            long time = System.nanoTime();
            if (time == Long.MAX_VALUE) {
                ++time;
            }
            this.evaluatedAt = time;
        }
    }

    public SessionLocal getSession() {
        return this.createSession;
    }

    public boolean isExpired() {
        assert (this.evaluatedAt != Long.MIN_VALUE) : "must not be called for main index of TableView";
        return !this.recursive && this.table.getTopQuery() == null && System.nanoTime() - this.evaluatedAt > MAX_AGE_NANOS;
    }

    @Override
    public String getPlanSQL() {
        return this.query == null ? null : this.query.getPlanSQL(11);
    }

    @Override
    public void close(SessionLocal session) {
    }

    @Override
    public void add(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void remove(SessionLocal session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public double getCost(SessionLocal session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.recursive ? 1000.0 : this.query.getCost();
    }

    @Override
    public Cursor find(SessionLocal session, SearchRow first, SearchRow last) {
        return this.find(session, first, last, null);
    }

    @Override
    public Cursor findByGeometry(SessionLocal session, SearchRow first, SearchRow last, SearchRow intersection) {
        return this.find(session, first, last, intersection);
    }

    private Cursor findRecursive(SearchRow first, SearchRow last) {
        TableView view = (TableView)this.table;
        ResultInterface recursiveResult = view.getRecursiveResult();
        if (recursiveResult != null) {
            recursiveResult.reset();
            return new QueryExpressionCursor(this, recursiveResult, first, last);
        }
        if (this.query == null) {
            Parser parser = new Parser(this.createSession);
            parser.setRightsChecked(true);
            parser.setSuppliedParameters(this.originalParameters);
            this.query = (Query)parser.prepare(this.querySQL);
            this.query.setNeverLazy(true);
        }
        if (!this.query.isUnion()) {
            throw DbException.get(42001, "recursive queries without UNION");
        }
        SelectUnion union = (SelectUnion)this.query;
        Query left = union.getLeft();
        left.setNeverLazy(true);
        left.disableCache();
        ResultInterface resultInterface = left.query(0L);
        LocalResult localResult = union.getEmptyResult();
        localResult.setMaxMemoryRows(Integer.MAX_VALUE);
        while (resultInterface.next()) {
            Value[] cr = resultInterface.currentRow();
            localResult.addRow(cr);
        }
        Query right = union.getRight();
        right.setNeverLazy(true);
        resultInterface.reset();
        view.setRecursiveResult(resultInterface);
        right.disableCache();
        while ((resultInterface = right.query(0L)).hasNext()) {
            while (resultInterface.next()) {
                Value[] cr = resultInterface.currentRow();
                localResult.addRow(cr);
            }
            resultInterface.reset();
            view.setRecursiveResult(resultInterface);
        }
        view.setRecursiveResult(null);
        localResult.done();
        return new QueryExpressionCursor(this, localResult, first, last);
    }

    public void setupQueryParameters(SessionLocal session, SearchRow first, SearchRow last, SearchRow intersection) {
        ArrayList<Parameter> paramList = this.query.getParameters();
        if (this.originalParameters != null) {
            for (Parameter orig : this.originalParameters) {
                if (orig == null) continue;
                int idx = orig.getIndex();
                Value value = orig.getValue(session);
                QueryExpressionIndex.setParameter(paramList, idx, value);
            }
        }
        int len = first != null ? first.getColumnCount() : (last != null ? last.getColumnCount() : (intersection != null ? intersection.getColumnCount() : 0));
        int idx = this.table.getParameterOffset(this.originalParameters);
        for (int i = 0; i < len; ++i) {
            int mask = this.indexMasks[i];
            if ((mask & 1) != 0) {
                QueryExpressionIndex.setParameter(paramList, idx++, first.getValue(i));
            }
            if ((mask & 2) != 0) {
                QueryExpressionIndex.setParameter(paramList, idx++, first.getValue(i));
            }
            if ((mask & 4) != 0) {
                QueryExpressionIndex.setParameter(paramList, idx++, last.getValue(i));
            }
            if ((mask & 0x10) == 0) continue;
            QueryExpressionIndex.setParameter(paramList, idx++, intersection.getValue(i));
        }
    }

    private Cursor find(SessionLocal session, SearchRow first, SearchRow last, SearchRow intersection) {
        if (this.recursive) {
            return this.findRecursive(first, last);
        }
        this.setupQueryParameters(session, first, last, intersection);
        ResultInterface result = this.query.query(0L);
        return new QueryExpressionCursor(this, result, first, last);
    }

    private static void setParameter(ArrayList<Parameter> paramList, int x, Value v) {
        if (x >= paramList.size()) {
            return;
        }
        Parameter param = paramList.get(x);
        param.setValue(v);
    }

    public Query getQuery() {
        return this.query;
    }

    private Query getQuery(SessionLocal session, int[] masks) {
        Query q = session.prepareQueryExpression(this.querySQL);
        if (masks == null || !q.allowGlobalConditions()) {
            q.preparePlan();
            return q;
        }
        int firstIndexParam = this.table.getParameterOffset(this.originalParameters);
        IntArray paramColumnIndex = new IntArray();
        int indexColumnCount = 0;
        for (int i = 0; i < masks.length; ++i) {
            int mask = masks[i];
            if (mask == 0) continue;
            ++indexColumnCount;
            int bitCount = Integer.bitCount(mask);
            for (int j = 0; j < bitCount; ++j) {
                paramColumnIndex.add(i);
            }
        }
        int len = paramColumnIndex.size();
        ArrayList<Column> columnList = new ArrayList<Column>(len);
        int i = 0;
        while (i < len) {
            Parameter param;
            int idx = paramColumnIndex.get(i);
            columnList.add(this.table.getColumn(idx));
            int mask = masks[idx];
            if ((mask & 1) != 0) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 6);
                ++i;
            }
            if ((mask & 2) != 0) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 5);
                ++i;
            }
            if ((mask & 4) != 0) {
                param = new Parameter(firstIndexParam + i);
                q.addGlobalCondition(param, idx, 4);
                ++i;
            }
            if ((mask & 0x10) == 0) continue;
            param = new Parameter(firstIndexParam + i);
            q.addGlobalCondition(param, idx, 8);
            ++i;
        }
        this.columns = columnList.toArray(new Column[0]);
        this.indexColumns = new IndexColumn[indexColumnCount];
        this.columnIds = new int[indexColumnCount];
        int indexColumnId = 0;
        for (int type = 0; type < 2; ++type) {
            for (int i2 = 0; i2 < masks.length; ++i2) {
                int mask = masks[i2];
                if (mask == 0 || (type == 0 ? (mask & 1) == 0 : (mask & 1) != 0)) continue;
                Column column = this.table.getColumn(i2);
                this.indexColumns[indexColumnId] = new IndexColumn(column);
                this.columnIds[indexColumnId] = column.getColumnId();
                ++indexColumnId;
            }
        }
        String sql = q.getPlanSQL(0);
        if (!sql.equals(this.querySQL)) {
            q = session.prepareQueryExpression(sql);
        }
        q.preparePlan();
        return q;
    }

    @Override
    public void remove(SessionLocal session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(SessionLocal session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    public void setRecursive(boolean value) {
        this.recursive = value;
    }

    @Override
    public long getRowCount(SessionLocal session) {
        return 0L;
    }

    @Override
    public long getRowCountApproximation(SessionLocal session) {
        return 0L;
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

