/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.SessionLocal;
import org.h2.index.Cursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.TableLink;
import org.h2.value.ValueToObjectConverter2;

public class LinkedCursor
implements Cursor {
    private final TableLink tableLink;
    private final PreparedStatement prep;
    private final String sql;
    private final SessionLocal session;
    private final ResultSet rs;
    private Row current;

    LinkedCursor(TableLink tableLink, ResultSet rs, SessionLocal session, String sql, PreparedStatement prep) {
        this.session = session;
        this.tableLink = tableLink;
        this.rs = rs;
        this.sql = sql;
        this.prep = prep;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        try {
            boolean result = this.rs.next();
            if (!result) {
                this.rs.close();
                this.tableLink.reusePreparedStatement(this.prep, this.sql);
                this.current = null;
                return false;
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        this.current = this.tableLink.getTemplateRow();
        for (int i = 0; i < this.current.getColumnCount(); ++i) {
            this.current.setValue(i, ValueToObjectConverter2.readValue(this.session, this.rs, i + 1, this.tableLink.getColumn(i).getType().getValueType()));
        }
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.getInternalError(this.toString());
    }
}

