/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.fulltext.FullTextSettings;
import org.h2.fulltext.IndexInfo;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.tools.SimpleResultSet;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class FullText {
    private static final String FIELD_SCHEMA = "SCHEMA";
    private static final String FIELD_TABLE = "TABLE";
    private static final String FIELD_COLUMNS = "COLUMNS";
    private static final String FIELD_KEYS = "KEYS";
    private static final String FIELD_SCORE = "SCORE";
    private static final String TRIGGER_PREFIX = "FT_";
    private static final String SCHEMA = "FT";
    private static final String SELECT_MAP_BY_WORD_ID = "SELECT ROWID FROM FT.MAP WHERE WORDID=?";
    private static final String SELECT_ROW_BY_ID = "SELECT `KEY`, INDEXID FROM FT.ROWS WHERE ID=?";
    private static final String FIELD_QUERY = "QUERY";

    public static void init(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("CREATE SCHEMA IF NOT EXISTS FT");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.INDEXES(ID INT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, SCHEMA VARCHAR, `TABLE` VARCHAR, COLUMNS VARCHAR, UNIQUE(SCHEMA, `TABLE`))");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.WORDS(ID INT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, NAME VARCHAR, UNIQUE(NAME))");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.ROWS(ID BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY, HASH INT, INDEXID INT, `KEY` VARCHAR, UNIQUE(HASH, INDEXID, `KEY`))");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.MAP(ROWID INT, WORDID INT, PRIMARY KEY(WORDID, ROWID))");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.IGNORELIST(LIST VARCHAR)");
        stat.execute("CREATE TABLE IF NOT EXISTS FT.SETTINGS(`KEY` VARCHAR PRIMARY KEY, `VALUE` VARCHAR)");
        String className = FullText.class.getName();
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_CREATE_INDEX FOR '" + className + ".createIndex'");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_INDEX FOR '" + className + ".dropIndex'");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH FOR '" + className + ".search'");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_SEARCH_DATA FOR '" + className + ".searchData'");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_REINDEX FOR '" + className + ".reindex'");
        stat.execute("CREATE ALIAS IF NOT EXISTS FT_DROP_ALL FOR '" + className + ".dropAll'");
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        ResultSet rs = stat.executeQuery("SELECT * FROM FT.IGNORELIST");
        while (rs.next()) {
            String commaSeparatedList = rs.getString(1);
            FullText.setIgnoreList(setting, commaSeparatedList);
        }
        rs = stat.executeQuery("SELECT * FROM FT.SETTINGS");
        while (rs.next()) {
            String key = rs.getString(1);
            if (!"whitespaceChars".equals(key)) continue;
            String value = rs.getString(2);
            setting.setWhitespaceChars(value);
        }
        rs = stat.executeQuery("SELECT * FROM FT.WORDS");
        while (rs.next()) {
            String word = rs.getString("NAME");
            int id = rs.getInt("ID");
            if ((word = setting.convertWord(word)) == null) continue;
            setting.addWord(word, id);
        }
        setting.setInitialized(true);
    }

    public static void createIndex(Connection conn, String schema, String table, String columnList) throws SQLException {
        FullText.init(conn);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO FT.INDEXES(SCHEMA, `TABLE`, COLUMNS) VALUES(?, ?, ?)");
        prep.setString(1, schema);
        prep.setString(2, table);
        prep.setString(3, columnList);
        prep.execute();
        FullText.createTrigger(conn, schema, table);
        FullText.indexExistingRows(conn, schema, table);
    }

    public static void reindex(Connection conn) throws SQLException {
        FullText.init(conn);
        FullText.removeAllTriggers(conn, TRIGGER_PREFIX);
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        setting.clearWordList();
        Statement stat = conn.createStatement();
        stat.execute("TRUNCATE TABLE FT.WORDS");
        stat.execute("TRUNCATE TABLE FT.ROWS");
        stat.execute("TRUNCATE TABLE FT.MAP");
        ResultSet rs = stat.executeQuery("SELECT * FROM FT.INDEXES");
        while (rs.next()) {
            String schema = rs.getString(FIELD_SCHEMA);
            String table = rs.getString(FIELD_TABLE);
            FullText.createTrigger(conn, schema, table);
            FullText.indexExistingRows(conn, schema, table);
        }
    }

    public static void dropIndex(Connection conn, String schema, String table) throws SQLException {
        int deleted;
        FullText.init(conn);
        PreparedStatement prep = conn.prepareStatement("SELECT ID FROM FT.INDEXES WHERE SCHEMA=? AND `TABLE`=?");
        prep.setString(1, schema);
        prep.setString(2, table);
        ResultSet rs = prep.executeQuery();
        if (!rs.next()) {
            return;
        }
        int indexId = rs.getInt(1);
        prep = conn.prepareStatement("DELETE FROM FT.INDEXES WHERE ID=?");
        prep.setInt(1, indexId);
        prep.execute();
        FullText.createOrDropTrigger(conn, schema, table, false);
        prep = conn.prepareStatement("DELETE FROM FT.ROWS WHERE INDEXID=? AND ROWNUM<10000");
        do {
            prep.setInt(1, indexId);
        } while ((deleted = prep.executeUpdate()) != 0);
        prep = conn.prepareStatement("DELETE FROM FT.MAP WHERE NOT EXISTS (SELECT * FROM FT.ROWS R WHERE R.ID=ROWID) AND ROWID<10000");
        while ((deleted = prep.executeUpdate()) != 0) {
        }
    }

    public static void dropAll(Connection conn) throws SQLException {
        FullText.init(conn);
        Statement stat = conn.createStatement();
        stat.execute("DROP SCHEMA IF EXISTS FT CASCADE");
        FullText.removeAllTriggers(conn, TRIGGER_PREFIX);
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        setting.removeAllIndexes();
        setting.clearIgnored();
        setting.clearWordList();
    }

    public static ResultSet search(Connection conn, String text, int limit, int offset) throws SQLException {
        try {
            return FullText.search(conn, text, limit, offset, false);
        }
        catch (DbException e) {
            throw DbException.toSQLException(e);
        }
    }

    public static ResultSet searchData(Connection conn, String text, int limit, int offset) throws SQLException {
        try {
            return FullText.search(conn, text, limit, offset, true);
        }
        catch (DbException e) {
            throw DbException.toSQLException(e);
        }
    }

    public static void setIgnoreList(Connection conn, String commaSeparatedList) throws SQLException {
        try {
            FullText.init(conn);
            FullTextSettings setting = FullTextSettings.getInstance(conn);
            FullText.setIgnoreList(setting, commaSeparatedList);
            Statement stat = conn.createStatement();
            stat.execute("TRUNCATE TABLE FT.IGNORELIST");
            PreparedStatement prep = conn.prepareStatement("INSERT INTO FT.IGNORELIST VALUES(?)");
            prep.setString(1, commaSeparatedList);
            prep.execute();
        }
        catch (DbException e) {
            throw DbException.toSQLException(e);
        }
    }

    public static void setWhitespaceChars(Connection conn, String whitespaceChars) throws SQLException {
        try {
            FullText.init(conn);
            FullTextSettings setting = FullTextSettings.getInstance(conn);
            setting.setWhitespaceChars(whitespaceChars);
            PreparedStatement prep = conn.prepareStatement("MERGE INTO FT.SETTINGS VALUES(?, ?)");
            prep.setString(1, "whitespaceChars");
            prep.setString(2, whitespaceChars);
            prep.execute();
        }
        catch (DbException e) {
            throw DbException.toSQLException(e);
        }
    }

    protected static String asString(Object data, int type) throws SQLException {
        if (data == null) {
            return "NULL";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return data.toString();
            }
            case 2005: {
                try {
                    if (data instanceof Clob) {
                        data = ((Clob)data).getCharacterStream();
                    }
                    return IOUtils.readStringAndClose((Reader)data, -1);
                }
                catch (IOException e) {
                    throw DbException.toSQLException(e);
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2006: {
                throw FullText.throwException("Unsupported column data type: " + type);
            }
        }
        return "";
    }

    protected static SimpleResultSet createResultSet(boolean data) {
        SimpleResultSet result = new SimpleResultSet();
        if (data) {
            result.addColumn(FIELD_SCHEMA, 12, 0, 0);
            result.addColumn(FIELD_TABLE, 12, 0, 0);
            result.addColumn(FIELD_COLUMNS, 2003, "VARCHAR ARRAY", 0, 0);
            result.addColumn(FIELD_KEYS, 2003, "VARCHAR ARRAY", 0, 0);
        } else {
            result.addColumn(FIELD_QUERY, 12, 0, 0);
        }
        result.addColumn(FIELD_SCORE, 6, 0, 0);
        return result;
    }

    protected static String[][] parseKey(Connection conn, String key) {
        ArrayList<String> columns = Utils.newSmallArrayList();
        ArrayList<String> data = Utils.newSmallArrayList();
        JdbcConnection c = (JdbcConnection)conn;
        SessionLocal session = (SessionLocal)c.getSession();
        Parser p = new Parser(session);
        Expression expr = p.parseExpression(key);
        FullText.addColumnData(session, columns, data, expr);
        String[] col = columns.toArray(new String[0]);
        String[] dat = data.toArray(new String[0]);
        String[][] columnData = new String[][]{col, dat};
        return columnData;
    }

    protected static String quoteSQL(Object data, int type) throws SQLException {
        if (data == null) {
            return "NULL";
        }
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return data.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 91: 
            case 92: 
            case 93: {
                return FullText.quoteString(data.toString());
            }
            case -4: 
            case -3: 
            case -2: {
                if (data instanceof UUID) {
                    return "'" + data + "'";
                }
                byte[] bytes = (byte[])data;
                StringBuilder builder = new StringBuilder(bytes.length * 2 + 2).append('\'');
                StringUtils.convertBytesToHex(builder, bytes).append('\'');
                return builder.toString();
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw FullText.throwException("Unsupported key data type: " + type);
            }
        }
        return "";
    }

    protected static void removeAllTriggers(Connection conn, String prefix) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT DISTINCT TRIGGER_SCHEMA, TRIGGER_NAME FROM INFORMATION_SCHEMA.TRIGGERS");
        Statement stat2 = conn.createStatement();
        while (rs.next()) {
            String schema = rs.getString("TRIGGER_SCHEMA");
            String name = rs.getString("TRIGGER_NAME");
            if (!name.startsWith(prefix)) continue;
            name = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(name);
            stat2.execute("DROP TRIGGER " + name);
        }
    }

    protected static void setColumns(int[] index, ArrayList<String> keys, ArrayList<String> columns) throws SQLException {
        int keySize = keys.size();
        for (int i = 0; i < keySize; ++i) {
            String key = keys.get(i);
            int found = -1;
            int columnsSize = columns.size();
            for (int j = 0; found == -1 && j < columnsSize; ++j) {
                String column = columns.get(j);
                if (!column.equals(key)) continue;
                found = j;
            }
            if (found < 0) {
                throw FullText.throwException("Column not found: " + key);
            }
            index[i] = found;
        }
    }

    protected static ResultSet search(Connection conn, String text, int limit, int offset, boolean data) throws SQLException {
        SimpleResultSet result = FullText.createResultSet(data);
        if (conn.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        if (text == null || StringUtils.isWhitespaceOrEmpty(text)) {
            return result;
        }
        FullTextSettings setting = FullTextSettings.getInstance(conn);
        if (!setting.isInitialized()) {
            FullText.init(conn);
        }
        HashSet<String> words = new HashSet<String>();
        FullText.addWords(setting, words, text);
        HashSet<Integer> rIds = null;
        PreparedStatement prepSelectMapByWordId = setting.prepare(conn, SELECT_MAP_BY_WORD_ID);
        for (String word : words) {
            HashSet<Integer> lastRowIds = rIds;
            rIds = new HashSet<Integer>();
            Integer wId = setting.getWordId(word);
            if (wId == null) continue;
            prepSelectMapByWordId.setInt(1, wId);
            ResultSet rs = prepSelectMapByWordId.executeQuery();
            while (rs.next()) {
                Integer rId = rs.getInt(1);
                if (lastRowIds != null && !lastRowIds.contains(rId)) continue;
                rIds.add(rId);
            }
        }
        if (rIds == null || rIds.isEmpty()) {
            return result;
        }
        PreparedStatement prepSelectRowById = setting.prepare(conn, SELECT_ROW_BY_ID);
        int rowCount = 0;
        Iterator iterator = rIds.iterator();
        while (iterator.hasNext()) {
            int rowId = (Integer)iterator.next();
            prepSelectRowById.setInt(1, rowId);
            ResultSet rs = prepSelectRowById.executeQuery();
            if (!rs.next()) continue;
            if (offset > 0) {
                --offset;
                continue;
            }
            String key = rs.getString(1);
            int indexId = rs.getInt(2);
            IndexInfo index = setting.getIndexInfo(indexId);
            if (data) {
                String[][] columnData = FullText.parseKey(conn, key);
                result.addRow(index.schema, index.table, columnData[0], columnData[1], 1.0);
            } else {
                String query = StringUtils.quoteIdentifier(index.schema) + "." + StringUtils.quoteIdentifier(index.table) + " WHERE " + key;
                result.addRow(query, 1.0);
            }
            if (limit <= 0 || ++rowCount < limit) continue;
            break;
        }
        return result;
    }

    private static void addColumnData(SessionLocal session, ArrayList<String> columns, ArrayList<String> data, Expression expr) {
        if (expr instanceof ConditionAndOr) {
            ConditionAndOr and = (ConditionAndOr)expr;
            FullText.addColumnData(session, columns, data, and.getSubexpression(0));
            FullText.addColumnData(session, columns, data, and.getSubexpression(1));
        } else {
            Comparison comp = (Comparison)expr;
            ExpressionColumn ec = (ExpressionColumn)comp.getSubexpression(0);
            String columnName = ec.getColumnName(session, -1);
            columns.add(columnName);
            if (expr.getSubexpressionCount() == 1) {
                data.add(null);
            } else {
                ValueExpression ev = (ValueExpression)comp.getSubexpression(1);
                data.add(ev.getValue(null).getString());
            }
        }
    }

    protected static void addWords(FullTextSettings setting, Set<String> set, Reader reader) {
        char[] whitespaceChars;
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.resetSyntax();
        tokenizer.wordChars(33, 255);
        for (char ch : whitespaceChars = setting.getWhitespaceChars().toCharArray()) {
            tokenizer.whitespaceChars(ch, ch);
        }
        try {
            int token;
            while ((token = tokenizer.nextToken()) != -1) {
                if (token != -3) continue;
                String word = tokenizer.sval;
                if ((word = setting.convertWord(word)) == null) continue;
                set.add(word);
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "Tokenizer error");
        }
    }

    protected static void addWords(FullTextSettings setting, Set<String> set, String text) {
        String whitespaceChars = setting.getWhitespaceChars();
        StringTokenizer tokenizer = new StringTokenizer(text, whitespaceChars);
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if ((word = setting.convertWord(word)) == null) continue;
            set.add(word);
        }
    }

    private static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        FullText.createOrDropTrigger(conn, schema, table, true);
    }

    private static void createOrDropTrigger(Connection conn, String schema, String table, boolean create) throws SQLException {
        try (Statement stat = conn.createStatement();){
            String trigger = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + table);
            stat.execute("DROP TRIGGER IF EXISTS " + trigger);
            if (create) {
                StringBuilder buff = new StringBuilder("CREATE TRIGGER IF NOT EXISTS ");
                buff.append(trigger).append(" AFTER INSERT, UPDATE, DELETE");
                buff.append(" ON ");
                StringUtils.quoteIdentifier(buff, schema).append('.');
                StringUtils.quoteIdentifier(buff, table).append(" FOR EACH ROW CALL \"").append(FullTextTrigger.class.getName()).append('\"');
                stat.execute(buff.toString());
            }
        }
    }

    private static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        FullTextTrigger existing = new FullTextTrigger();
        existing.init(conn, schema, null, table, false, 1);
        String sql = "SELECT * FROM " + StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(table);
        ResultSet rs = conn.createStatement().executeQuery(sql);
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = rs.getObject(i + 1);
            }
            existing.fire(conn, null, row);
        }
    }

    private static String quoteString(String data) {
        if (data.indexOf(39) < 0) {
            return "'" + data + "'";
        }
        int len = data.length();
        StringBuilder buff = new StringBuilder(len + 2);
        buff.append('\'');
        for (int i = 0; i < len; ++i) {
            char ch = data.charAt(i);
            if (ch == '\'') {
                buff.append(ch);
            }
            buff.append(ch);
        }
        buff.append('\'');
        return buff.toString();
    }

    private static void setIgnoreList(FullTextSettings setting, String commaSeparatedList) {
        String[] list = StringUtils.arraySplit(commaSeparatedList, ',', true);
        setting.addIgnored(Arrays.asList(list));
    }

    protected static boolean hasChanged(Object[] oldRow, Object[] newRow, int[] indexColumns) {
        for (int c : indexColumns) {
            Object o = oldRow[c];
            Object n = newRow[c];
            if (!(o == null ? n != null : !o.equals(n))) continue;
            return true;
        }
        return false;
    }

    public static void closeAll() {
        FullTextSettings.closeAll();
    }

    protected static SQLException throwException(String message) throws SQLException {
        throw new SQLException(message, "FULLTEXT");
    }

    public static final class FullTextTrigger
    implements Trigger {
        private FullTextSettings setting;
        private IndexInfo index;
        private int[] columnTypes;
        private static final int INSERT_WORD = 0;
        private static final int INSERT_ROW = 1;
        private static final int INSERT_MAP = 2;
        private static final int DELETE_ROW = 3;
        private static final int DELETE_MAP = 4;
        private static final int SELECT_ROW = 5;
        private static final String[] SQL = new String[]{"MERGE INTO FT.WORDS(NAME) KEY(NAME) VALUES(?)", "INSERT INTO FT.ROWS(HASH, INDEXID, `KEY`) VALUES(?, ?, ?)", "INSERT INTO FT.MAP(ROWID, WORDID) VALUES(?, ?)", "DELETE FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND `KEY`=?", "DELETE FROM FT.MAP WHERE ROWID=? AND WORDID=?", "SELECT ID FROM FT.ROWS WHERE HASH=? AND INDEXID=? AND `KEY`=?"};

        @Override
        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            this.setting = FullTextSettings.getInstance(conn);
            if (!this.setting.isInitialized()) {
                FullText.init(conn);
            }
            ArrayList<String> keyList = Utils.newSmallArrayList();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, StringUtils.escapeMetaDataPattern(schemaName), StringUtils.escapeMetaDataPattern(tableName), null);
            ArrayList<String> columnList = Utils.newSmallArrayList();
            while (rs.next()) {
                columnList.add(rs.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[columnList.size()];
            this.index = new IndexInfo();
            this.index.schema = schemaName;
            this.index.table = tableName;
            this.index.columns = columnList.toArray(new String[0]);
            rs = meta.getColumns(null, StringUtils.escapeMetaDataPattern(schemaName), StringUtils.escapeMetaDataPattern(tableName), null);
            int i = 0;
            while (rs.next()) {
                this.columnTypes[i] = rs.getInt("DATA_TYPE");
                ++i;
            }
            if (keyList.isEmpty()) {
                rs = meta.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(schemaName), tableName);
                while (rs.next()) {
                    keyList.add(rs.getString("COLUMN_NAME"));
                }
            }
            if (keyList.isEmpty()) {
                throw FullText.throwException("No primary key for table " + tableName);
            }
            ArrayList<String> indexList = Utils.newSmallArrayList();
            PreparedStatement prep = conn.prepareStatement("SELECT ID, COLUMNS FROM FT.INDEXES WHERE SCHEMA=? AND `TABLE`=?");
            prep.setString(1, schemaName);
            prep.setString(2, tableName);
            rs = prep.executeQuery();
            if (rs.next()) {
                this.index.id = rs.getInt(1);
                String columns = rs.getString(2);
                if (columns != null) {
                    Collections.addAll(indexList, StringUtils.arraySplit(columns, ',', true));
                }
            }
            if (indexList.isEmpty()) {
                indexList.addAll(columnList);
            }
            this.index.keys = new int[keyList.size()];
            FullText.setColumns(this.index.keys, keyList, columnList);
            this.index.indexColumns = new int[indexList.size()];
            FullText.setColumns(this.index.indexColumns, indexList, columnList);
            this.setting.addIndexInfo(this.index);
        }

        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (oldRow != null) {
                if (newRow != null) {
                    if (FullText.hasChanged(oldRow, newRow, this.index.indexColumns)) {
                        this.delete(conn, oldRow);
                        this.insert(conn, newRow);
                    }
                } else {
                    this.delete(conn, oldRow);
                }
            } else if (newRow != null) {
                this.insert(conn, newRow);
            }
        }

        @Override
        public void close() {
            this.setting.removeIndexInfo(this.index);
        }

        @Override
        public void remove() {
            this.setting.removeIndexInfo(this.index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insert(Connection conn, Object[] row) throws SQLException {
            PreparedStatement prepInsertRow = null;
            PreparedStatement prepInsertMap = null;
            try {
                int[] wordIds;
                String key = this.getKey(row);
                int hash = key.hashCode();
                prepInsertRow = FullTextTrigger.getStatement(conn, 1);
                prepInsertRow.setInt(1, hash);
                prepInsertRow.setInt(2, this.index.id);
                prepInsertRow.setString(3, key);
                prepInsertRow.execute();
                ResultSet rs = prepInsertRow.getGeneratedKeys();
                rs.next();
                int rowId = rs.getInt(1);
                prepInsertMap = FullTextTrigger.getStatement(conn, 2);
                prepInsertMap.setInt(1, rowId);
                for (int id : wordIds = this.getWordIds(conn, row)) {
                    prepInsertMap.setInt(2, id);
                    prepInsertMap.execute();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(prepInsertRow);
                IOUtils.closeSilently(prepInsertMap);
                throw throwable;
            }
            IOUtils.closeSilently(prepInsertRow);
            IOUtils.closeSilently(prepInsertMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delete(Connection conn, Object[] row) throws SQLException {
            PreparedStatement prepSelectRow = null;
            PreparedStatement prepDeleteMap = null;
            PreparedStatement prepDeleteRow = null;
            try {
                String key = this.getKey(row);
                int hash = key.hashCode();
                prepSelectRow = FullTextTrigger.getStatement(conn, 5);
                prepSelectRow.setInt(1, hash);
                prepSelectRow.setInt(2, this.index.id);
                prepSelectRow.setString(3, key);
                ResultSet rs = prepSelectRow.executeQuery();
                prepDeleteMap = FullTextTrigger.getStatement(conn, 4);
                prepDeleteRow = FullTextTrigger.getStatement(conn, 3);
                if (rs.next()) {
                    int[] wordIds;
                    int rowId = rs.getInt(1);
                    prepDeleteMap.setInt(1, rowId);
                    for (int id : wordIds = this.getWordIds(conn, row)) {
                        prepDeleteMap.setInt(2, id);
                        prepDeleteMap.executeUpdate();
                    }
                    prepDeleteRow.setInt(1, hash);
                    prepDeleteRow.setInt(2, this.index.id);
                    prepDeleteRow.setString(3, key);
                    prepDeleteRow.executeUpdate();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(prepSelectRow);
                IOUtils.closeSilently(prepDeleteMap);
                IOUtils.closeSilently(prepDeleteRow);
                throw throwable;
            }
            IOUtils.closeSilently(prepSelectRow);
            IOUtils.closeSilently(prepDeleteMap);
            IOUtils.closeSilently(prepDeleteRow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[] getWordIds(Connection conn, Object[] row) throws SQLException {
            HashSet<String> words = new HashSet<String>();
            for (int idx : this.index.indexColumns) {
                int type = this.columnTypes[idx];
                Object data = row[idx];
                if (type == 2005 && data != null) {
                    Reader reader = data instanceof Reader ? (Reader)data : ((Clob)data).getCharacterStream();
                    FullText.addWords(this.setting, words, reader);
                    continue;
                }
                String string = FullText.asString(data, type);
                FullText.addWords(this.setting, words, string);
            }
            PreparedStatement prepInsertWord = null;
            try {
                prepInsertWord = FullTextTrigger.getStatement(conn, 0);
                int[] wordIds = new int[words.size()];
                int i = 0;
                for (String word : words) {
                    Integer wId;
                    while ((wId = this.setting.getWordId(word)) == null) {
                        int wordId;
                        prepInsertWord.setString(1, word);
                        prepInsertWord.execute();
                        ResultSet rs = prepInsertWord.getGeneratedKeys();
                        if (!rs.next() || (wordId = rs.getInt(1)) == 0) continue;
                        this.setting.addWord(word, wordId);
                        wId = wordId;
                        break;
                    }
                    wordIds[i++] = wId;
                }
                Arrays.sort(wordIds);
                Object object = wordIds;
                return object;
            }
            finally {
                IOUtils.closeSilently(prepInsertWord);
            }
        }

        private String getKey(Object[] row) throws SQLException {
            StringBuilder builder = new StringBuilder();
            int[] keys = this.index.keys;
            int l = keys.length;
            for (int i = 0; i < l; ++i) {
                if (i > 0) {
                    builder.append(" AND ");
                }
                int columnIndex = keys[i];
                StringUtils.quoteIdentifier(builder, this.index.columns[columnIndex]);
                Object o = row[columnIndex];
                if (o == null) {
                    builder.append(" IS NULL");
                    continue;
                }
                builder.append('=').append(FullText.quoteSQL(o, this.columnTypes[columnIndex]));
            }
            return builder.toString();
        }

        private static PreparedStatement getStatement(Connection conn, int index) throws SQLException {
            return conn.prepareStatement(SQL[index], 1);
        }
    }
}

