/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.function.table.TableFunction;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.ValueVarchar;

public final class LinkSchemaFunction
extends TableFunction {
    public LinkSchemaFunction() {
        super(new Expression[6]);
    }

    @Override
    public ResultInterface getValue(SessionLocal session) {
        session.getUser().checkAdmin();
        String targetSchema = this.getValue(session, 0);
        String driver = this.getValue(session, 1);
        String url = this.getValue(session, 2);
        String user = this.getValue(session, 3);
        String password = this.getValue(session, 4);
        String sourceSchema = this.getValue(session, 5);
        if (targetSchema == null || driver == null || url == null || user == null || password == null || sourceSchema == null) {
            return this.getValueTemplate(session);
        }
        JdbcConnection conn = session.createConnection(false);
        Connection c2 = null;
        Statement stat = null;
        ResultSet rs = null;
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        try {
            c2 = JdbcUtils.getConnection(driver, url, user, password);
            stat = conn.createStatement();
            stat.execute(StringUtils.quoteIdentifier(new StringBuilder("CREATE SCHEMA IF NOT EXISTS "), targetSchema).toString());
            rs = url.startsWith("jdbc:postgresql:") ? c2.getMetaData().getTables(null, sourceSchema, null, new String[]{"TABLE", "LINKED TABLE", "VIEW", "EXTERNAL"}) : c2.getMetaData().getTables(null, sourceSchema, null, null);
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                StringBuilder buff = new StringBuilder();
                buff.append("DROP TABLE IF EXISTS ");
                StringUtils.quoteIdentifier(buff, targetSchema).append('.');
                StringUtils.quoteIdentifier(buff, table);
                stat.execute(buff.toString());
                buff.setLength(0);
                buff.append("CREATE LINKED TABLE ");
                StringUtils.quoteIdentifier(buff, targetSchema).append('.');
                StringUtils.quoteIdentifier(buff, table).append('(');
                StringUtils.quoteStringSQL(buff, driver).append(", ");
                StringUtils.quoteStringSQL(buff, url).append(", ");
                StringUtils.quoteStringSQL(buff, user).append(", ");
                StringUtils.quoteStringSQL(buff, password).append(", ");
                StringUtils.quoteStringSQL(buff, sourceSchema).append(", ");
                StringUtils.quoteStringSQL(buff, table).append(')');
                stat.execute(buff.toString());
                result.addRow(ValueVarchar.get(table, session));
            }
        }
        catch (SQLException e) {
            try {
                result.close();
                throw DbException.convert(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(rs);
                JdbcUtils.closeSilently(c2);
                JdbcUtils.closeSilently(stat);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(rs);
        JdbcUtils.closeSilently(c2);
        JdbcUtils.closeSilently(stat);
        return result;
    }

    private String getValue(SessionLocal session, int index) {
        return this.args[index].getValue(session).getString();
    }

    @Override
    public void optimize(SessionLocal session) {
        super.optimize(session);
        int len = this.args.length;
        if (len != 6) {
            throw DbException.get(7001, this.getName(), "6");
        }
    }

    @Override
    public ResultInterface getValueTemplate(SessionLocal session) {
        SimpleResult result = new SimpleResult();
        result.addColumn("TABLE_NAME", TypeInfo.TYPE_VARCHAR);
        return result;
    }

    @Override
    public String getName() {
        return "LINK_SCHEMA";
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }
}

