/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.ArrayList;
import org.h2.command.Parser;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.Function1_2;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;

public final class TableInfoFunction
extends Function1_2 {
    public static final int DISK_SPACE_USED = 0;
    public static final int ESTIMATED_ENVELOPE = 1;
    private static final String[] NAMES = new String[]{"DISK_SPACE_USED", "ESTIMATED_ENVELOPE"};
    private final int function;

    public TableInfoFunction(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        Table table = new Parser(session).parseTableName(v1.getString());
        block0 : switch (this.function) {
            case 0: {
                v1 = ValueBigint.get(table.getDiskSpaceUsed());
                break;
            }
            case 1: {
                Column column = table.getColumn(v2.getString());
                ArrayList<Index> indexes = table.getIndexes();
                if (indexes != null) {
                    int size = indexes.size();
                    for (int i = 1; i < size; ++i) {
                        Index index = indexes.get(i);
                        if (!(index instanceof MVSpatialIndex) || !index.isFirstColumn(column)) continue;
                        v1 = ((MVSpatialIndex)index).getEstimatedBounds(session);
                        break block0;
                    }
                }
                v1 = ValueNull.INSTANCE;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            case 1: {
                this.type = TypeInfo.TYPE_GEOMETRY;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                return false;
            }
        }
        return super.isEverything(visitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

