/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

public final class SubstringFunction
extends FunctionN {
    public SubstringFunction() {
        super(new Expression[3]);
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        if (this.type.getValueType() == 6) {
            byte[] s = v1.getBytesNoCopy();
            int sl = s.length;
            int start = v2.getInt();
            if (start == 0) {
                start = 1;
            } else if (start < 0) {
                start = sl + start + 1;
            }
            int end = v3 == null ? Math.max(sl + 1, start) : start + v3.getInt();
            start = Math.max(start, 1);
            end = Math.min(end, sl + 1);
            if (start > sl || end <= start) {
                return ValueVarbinary.EMPTY;
            }
            if (--start == 0 && --end == s.length) {
                return v1.convertTo(TypeInfo.TYPE_VARBINARY);
            }
            return ValueVarbinary.getNoCopy(Arrays.copyOfRange(s, start, end));
        }
        String s = v1.getString();
        int sl = s.length();
        int start = v2.getInt();
        if (start == 0) {
            start = 1;
        } else if (start < 0) {
            start = sl + start + 1;
        }
        int end = v3 == null ? Math.max(sl + 1, start) : start + v3.getInt();
        start = Math.max(start, 1);
        end = Math.min(end, sl + 1);
        if (start > sl || end <= start) {
            return session.getMode().treatEmptyStringsAsNull ? ValueNull.INSTANCE : ValueVarchar.EMPTY;
        }
        return ValueVarchar.get(s.substring(start - 1, end - 1), null);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        Value v;
        boolean allConst = this.optimizeArguments(session, true);
        int len = this.args.length;
        if (len < 2 || len > 3) {
            throw DbException.get(7001, this.getName(), "2..3");
        }
        TypeInfo argType = this.args[0].getType();
        long p = argType.getPrecision();
        Expression arg = this.args[1];
        if (arg.isConstant() && (v = arg.getValue(session)) != ValueNull.INSTANCE) {
            p -= v.getLong() - 1L;
        }
        if (this.args.length == 3 && (arg = this.args[2]).isConstant() && (v = arg.getValue(session)) != ValueNull.INSTANCE) {
            p = Math.min(p, v.getLong());
        }
        p = Math.max(0L, p);
        this.type = TypeInfo.getTypeInfo(DataType.isBinaryStringType(argType.getValueType()) ? 6 : 2, p, 0, null);
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.args[0].getUnenclosedSQL(builder.append(this.getName()).append('('), sqlFlags);
        this.args[1].getUnenclosedSQL(builder.append(" FROM "), sqlFlags);
        if (this.args.length > 2) {
            this.args[2].getUnenclosedSQL(builder.append(" FOR "), sqlFlags);
        }
        return builder.append(')');
    }

    @Override
    public String getName() {
        return "SUBSTRING";
    }
}

