/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function1;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

public final class StringFunction1
extends Function1 {
    public static final int UPPER = 0;
    public static final int LOWER = 1;
    public static final int ASCII = 2;
    public static final int CHAR = 3;
    public static final int STRINGENCODE = 4;
    public static final int STRINGDECODE = 5;
    public static final int STRINGTOUTF8 = 6;
    public static final int UTF8TOSTRING = 7;
    public static final int HEXTORAW = 8;
    public static final int RAWTOHEX = 9;
    public static final int SPACE = 10;
    public static final int QUOTE_IDENT = 11;
    private static final String[] NAMES = new String[]{"UPPER", "LOWER", "ASCII", "CHAR", "STRINGENCODE", "STRINGDECODE", "STRINGTOUTF8", "UTF8TOSTRING", "HEXTORAW", "RAWTOHEX", "SPACE", "QUOTE_IDENT"};
    private final int function;

    public StringFunction1(Expression arg, int function) {
        super(arg);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v = this.arg.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        switch (this.function) {
            case 0: {
                v = ValueVarchar.get(v.getString().toUpperCase(), session);
                break;
            }
            case 1: {
                v = ValueVarchar.get(v.getString().toLowerCase(), session);
                break;
            }
            case 2: {
                String s = v.getString();
                v = s.isEmpty() ? ValueNull.INSTANCE : ValueInteger.get(s.charAt(0));
                break;
            }
            case 3: {
                v = ValueVarchar.get(String.valueOf((char)v.getInt()), session);
                break;
            }
            case 4: {
                v = ValueVarchar.get(StringUtils.javaEncode(v.getString()), session);
                break;
            }
            case 5: {
                v = ValueVarchar.get(StringUtils.javaDecode(v.getString()), session);
                break;
            }
            case 6: {
                v = ValueVarbinary.getNoCopy(v.getString().getBytes(StandardCharsets.UTF_8));
                break;
            }
            case 7: {
                v = ValueVarchar.get(new String(v.getBytesNoCopy(), StandardCharsets.UTF_8), session);
                break;
            }
            case 8: {
                v = StringFunction1.hexToRaw(v.getString(), session);
                break;
            }
            case 9: {
                v = ValueVarchar.get(StringFunction1.rawToHex(v, session.getMode()), session);
                break;
            }
            case 10: {
                byte[] chars = new byte[Math.max(0, v.getInt())];
                Arrays.fill(chars, (byte)32);
                v = ValueVarchar.get(new String(chars, StandardCharsets.ISO_8859_1), session);
                break;
            }
            case 11: {
                v = ValueVarchar.get(StringUtils.quoteIdentifier(v.getString()), session);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v;
    }

    private static Value hexToRaw(String s, SessionLocal session) {
        if (session.getMode().getEnum() == Mode.ModeEnum.Oracle) {
            return ValueVarbinary.get(StringUtils.convertHexToBytes(s));
        }
        int len = s.length();
        if (len % 4 != 0) {
            throw DbException.get(22018, s);
        }
        StringBuilder builder = new StringBuilder(len / 4);
        for (int i = 0; i < len; i += 4) {
            try {
                builder.append((char)Integer.parseInt(s.substring(i, i + 4), 16));
                continue;
            }
            catch (NumberFormatException e) {
                throw DbException.get(22018, s);
            }
        }
        return ValueVarchar.get(builder.toString(), session);
    }

    private static String rawToHex(Value v, Mode mode) {
        if (DataType.isBinaryStringOrSpecialBinaryType(v.getValueType())) {
            return StringUtils.convertBytesToHex(v.getBytesNoCopy());
        }
        String s = v.getString();
        if (mode.getEnum() == Mode.ModeEnum.Oracle) {
            return StringUtils.convertBytesToHex(s.getBytes(StandardCharsets.UTF_8));
        }
        int length = s.length();
        StringBuilder buff = new StringBuilder(4 * length);
        for (int i = 0; i < length; ++i) {
            String hex = Integer.toHexString(s.charAt(i) & 0xFFFF);
            for (int j = hex.length(); j < 4; ++j) {
                buff.append('0');
            }
            buff.append(hex);
        }
        return buff.toString();
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        switch (this.function) {
            case 0: 
            case 1: 
            case 4: 
            case 10: 
            case 11: {
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            case 2: {
                this.type = TypeInfo.TYPE_INTEGER;
                break;
            }
            case 3: {
                this.type = TypeInfo.getTypeInfo(2, 1L, 0, null);
                break;
            }
            case 5: {
                TypeInfo t = this.arg.getType();
                this.type = DataType.isCharacterStringType(t.getValueType()) ? TypeInfo.getTypeInfo(2, t.getPrecision(), 0, null) : TypeInfo.TYPE_VARCHAR;
                break;
            }
            case 6: {
                this.type = TypeInfo.TYPE_VARBINARY;
                break;
            }
            case 7: {
                TypeInfo t = this.arg.getType();
                this.type = DataType.isBinaryStringType(t.getValueType()) ? TypeInfo.getTypeInfo(2, t.getPrecision(), 0, null) : TypeInfo.TYPE_VARCHAR;
                break;
            }
            case 8: {
                TypeInfo t = this.arg.getType();
                if (session.getMode().getEnum() == Mode.ModeEnum.Oracle) {
                    if (DataType.isCharacterStringType(t.getValueType())) {
                        this.type = TypeInfo.getTypeInfo(6, t.getPrecision() / 2L, 0, null);
                        break;
                    }
                    this.type = TypeInfo.TYPE_VARBINARY;
                    break;
                }
                if (DataType.isCharacterStringType(t.getValueType())) {
                    this.type = TypeInfo.getTypeInfo(2, t.getPrecision() / 4L, 0, null);
                    break;
                }
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            case 9: {
                TypeInfo t = this.arg.getType();
                long precision = t.getPrecision();
                int mul = DataType.isBinaryStringOrSpecialBinaryType(t.getValueType()) ? 2 : (session.getMode().getEnum() == Mode.ModeEnum.Oracle ? 6 : 4);
                this.type = TypeInfo.getTypeInfo(2, precision <= Long.MAX_VALUE / (long)mul ? precision * (long)mul : Long.MAX_VALUE, 0, null);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (this.arg.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

