/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.text.DateFormatSymbols;
import java.util.Locale;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function1;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

public final class DayMonthNameFunction
extends Function1 {
    public static final int DAYNAME = 0;
    public static final int MONTHNAME = 1;
    private static final String[] NAMES = new String[]{"DAYNAME", "MONTHNAME"};
    private static volatile String[][] MONTHS_AND_WEEKS;
    private final int function;

    public DayMonthNameFunction(Expression arg, int function) {
        super(arg);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        String result;
        Value v = this.arg.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        long dateValue = DateTimeUtils.dateAndTimeFromValue(v, session)[0];
        switch (this.function) {
            case 0: {
                result = DayMonthNameFunction.getMonthsAndWeeks(1)[DateTimeUtils.getDayOfWeek(dateValue, 0)];
                break;
            }
            case 1: {
                result = DayMonthNameFunction.getMonthsAndWeeks(0)[DateTimeUtils.monthFromDateValue(dateValue) - 1];
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return ValueVarchar.get(result, session);
    }

    private static String[] getMonthsAndWeeks(int field) {
        String[][] result = MONTHS_AND_WEEKS;
        if (result == null) {
            result = new String[2][];
            DateFormatSymbols dfs = DateFormatSymbols.getInstance(Locale.ENGLISH);
            result[0] = dfs.getMonths();
            result[1] = dfs.getWeekdays();
            MONTHS_AND_WEEKS = result;
        }
        return result[field];
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        this.type = TypeInfo.getTypeInfo(2, 20L, 0, null);
        if (this.arg.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

