/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.WeekFields;
import java.util.Locale;
import org.h2.api.IntervalQualifier;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.util.DateTimeUtils;
import org.h2.util.IntervalUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDate;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public final class DateTimeFunction
extends Function1_2 {
    public static final int EXTRACT = 0;
    public static final int DATE_TRUNC = 1;
    public static final int DATEADD = 2;
    public static final int DATEDIFF = 3;
    private static final String[] NAMES = new String[]{"EXTRACT", "DATE_TRUNC", "DATEADD", "DATEDIFF"};
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int TIMEZONE_HOUR = 6;
    public static final int TIMEZONE_MINUTE = 7;
    public static final int TIMEZONE_SECOND = 8;
    public static final int MILLENNIUM = 9;
    public static final int CENTURY = 10;
    public static final int DECADE = 11;
    public static final int QUARTER = 12;
    public static final int MILLISECOND = 13;
    public static final int MICROSECOND = 14;
    public static final int NANOSECOND = 15;
    public static final int DAY_OF_YEAR = 16;
    public static final int ISO_DAY_OF_WEEK = 17;
    public static final int ISO_WEEK = 18;
    public static final int ISO_WEEK_YEAR = 19;
    public static final int DAY_OF_WEEK = 20;
    public static final int WEEK = 21;
    public static final int WEEK_YEAR = 22;
    public static final int EPOCH = 23;
    public static final int DOW = 24;
    private static final int FIELDS_COUNT = 25;
    private static final String[] FIELD_NAMES = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TIMEZONE_SECOND", "MILLENNIUM", "CENTURY", "DECADE", "QUARTER", "MILLISECOND", "MICROSECOND", "NANOSECOND", "DAY_OF_YEAR", "ISO_DAY_OF_WEEK", "ISO_WEEK", "ISO_WEEK_YEAR", "DAY_OF_WEEK", "WEEK", "WEEK_YEAR", "EPOCH", "DOW"};
    private static final BigDecimal BD_SECONDS_PER_DAY = new BigDecimal(86400L);
    private static final BigInteger BI_SECONDS_PER_DAY = BigInteger.valueOf(86400L);
    private static final BigDecimal BD_NANOS_PER_SECOND = new BigDecimal(1000000000L);
    private static volatile WeekFields WEEK_FIELDS;
    private final int function;
    private final int field;

    public static int getField(String name) {
        switch (StringUtils.toUpperEnglish(name)) {
            case "YEAR": 
            case "YY": 
            case "YYYY": 
            case "SQL_TSI_YEAR": {
                return 0;
            }
            case "MONTH": 
            case "M": 
            case "MM": 
            case "SQL_TSI_MONTH": {
                return 1;
            }
            case "DAY": 
            case "D": 
            case "DD": 
            case "SQL_TSI_DAY": {
                return 2;
            }
            case "HOUR": 
            case "HH": 
            case "SQL_TSI_HOUR": {
                return 3;
            }
            case "MINUTE": 
            case "MI": 
            case "N": 
            case "SQL_TSI_MINUTE": {
                return 4;
            }
            case "SECOND": 
            case "S": 
            case "SS": 
            case "SQL_TSI_SECOND": {
                return 5;
            }
            case "TIMEZONE_HOUR": {
                return 6;
            }
            case "TIMEZONE_MINUTE": {
                return 7;
            }
            case "TIMEZONE_SECOND": {
                return 8;
            }
            case "MILLENNIUM": {
                return 9;
            }
            case "CENTURY": {
                return 10;
            }
            case "DECADE": {
                return 11;
            }
            case "QUARTER": {
                return 12;
            }
            case "MILLISECOND": 
            case "MILLISECONDS": 
            case "MS": {
                return 13;
            }
            case "MICROSECOND": 
            case "MICROSECONDS": 
            case "MCS": {
                return 14;
            }
            case "NANOSECOND": 
            case "NS": {
                return 15;
            }
            case "DAY_OF_YEAR": 
            case "DAYOFYEAR": 
            case "DY": 
            case "DOY": {
                return 16;
            }
            case "ISO_DAY_OF_WEEK": 
            case "ISODOW": {
                return 17;
            }
            case "ISO_WEEK": {
                return 18;
            }
            case "ISO_WEEK_YEAR": 
            case "ISO_YEAR": 
            case "ISOYEAR": {
                return 19;
            }
            case "DAY_OF_WEEK": 
            case "DAYOFWEEK": {
                return 20;
            }
            case "WEEK": 
            case "WK": 
            case "WW": 
            case "SQL_TSI_WEEK": {
                return 21;
            }
            case "WEEK_YEAR": {
                return 22;
            }
            case "EPOCH": {
                return 23;
            }
            case "DOW": {
                return 24;
            }
        }
        throw DbException.getInvalidValueException("date-time field", name);
    }

    public static String getFieldName(int field) {
        if (field < 0 || field >= 25) {
            throw DbException.getUnsupportedException("datetime field " + field);
        }
        return FIELD_NAMES[field];
    }

    public DateTimeFunction(int function, int field, Expression arg1, Expression arg2) {
        super(arg1, arg2);
        this.function = function;
        this.field = field;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        switch (this.function) {
            case 0: {
                v1 = this.field == 23 ? DateTimeFunction.extractEpoch(session, v1) : ValueInteger.get(DateTimeFunction.extractInteger(session, v1, this.field));
                break;
            }
            case 1: {
                v1 = DateTimeFunction.truncateDate(session, this.field, v1);
                break;
            }
            case 2: {
                v1 = DateTimeFunction.dateadd(session, this.field, v1.getLong(), v2);
                break;
            }
            case 3: {
                v1 = ValueBigint.get(DateTimeFunction.datediff(session, this.field, v1, v2));
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    private static int extractInteger(SessionLocal session, Value date, int field) {
        return date instanceof ValueInterval ? DateTimeFunction.extractInterval(date, field) : DateTimeFunction.extractDateTime(session, date, field);
    }

    private static int extractInterval(Value date, int field) {
        long v;
        ValueInterval interval = (ValueInterval)date;
        IntervalQualifier qualifier = interval.getQualifier();
        boolean negative = interval.isNegative();
        long leading = interval.getLeading();
        long remaining = interval.getRemaining();
        switch (field) {
            case 0: {
                v = IntervalUtils.yearsFromInterval(qualifier, negative, leading, remaining);
                break;
            }
            case 1: {
                v = IntervalUtils.monthsFromInterval(qualifier, negative, leading, remaining);
                break;
            }
            case 2: 
            case 16: {
                v = IntervalUtils.daysFromInterval(qualifier, negative, leading, remaining);
                break;
            }
            case 3: {
                v = IntervalUtils.hoursFromInterval(qualifier, negative, leading, remaining);
                break;
            }
            case 4: {
                v = IntervalUtils.minutesFromInterval(qualifier, negative, leading, remaining);
                break;
            }
            case 5: {
                v = IntervalUtils.nanosFromInterval(qualifier, negative, leading, remaining) / 1000000000L;
                break;
            }
            case 13: {
                v = IntervalUtils.nanosFromInterval(qualifier, negative, leading, remaining) / 1000000L % 1000L;
                break;
            }
            case 14: {
                v = IntervalUtils.nanosFromInterval(qualifier, negative, leading, remaining) / 1000L % 1000000L;
                break;
            }
            case 15: {
                v = IntervalUtils.nanosFromInterval(qualifier, negative, leading, remaining) % 1000000000L;
                break;
            }
            default: {
                throw DbException.getUnsupportedException("getDatePart(" + date + ", " + field + ')');
            }
        }
        return (int)v;
    }

    static int extractDateTime(SessionLocal session, Value date, int field) {
        long[] a = DateTimeUtils.dateAndTimeFromValue(date, session);
        long dateValue = a[0];
        long timeNanos = a[1];
        switch (field) {
            case 0: {
                return DateTimeUtils.yearFromDateValue(dateValue);
            }
            case 1: {
                return DateTimeUtils.monthFromDateValue(dateValue);
            }
            case 2: {
                return DateTimeUtils.dayFromDateValue(dateValue);
            }
            case 3: {
                return (int)(timeNanos / 3600000000000L % 24L);
            }
            case 4: {
                return (int)(timeNanos / 60000000000L % 60L);
            }
            case 5: {
                return (int)(timeNanos / 1000000000L % 60L);
            }
            case 13: {
                return (int)(timeNanos / 1000000L % 1000L);
            }
            case 14: {
                return (int)(timeNanos / 1000L % 1000000L);
            }
            case 15: {
                return (int)(timeNanos % 1000000000L);
            }
            case 9: {
                return DateTimeFunction.millennium(DateTimeUtils.yearFromDateValue(dateValue));
            }
            case 10: {
                return DateTimeFunction.century(DateTimeUtils.yearFromDateValue(dateValue));
            }
            case 11: {
                return DateTimeFunction.decade(DateTimeUtils.yearFromDateValue(dateValue));
            }
            case 16: {
                return DateTimeUtils.getDayOfYear(dateValue);
            }
            case 24: {
                if (session.getMode().getEnum() == Mode.ModeEnum.PostgreSQL) {
                    return DateTimeUtils.getSundayDayOfWeek(dateValue) - 1;
                }
            }
            case 20: {
                return DateTimeFunction.getLocalDayOfWeek(dateValue);
            }
            case 21: {
                return DateTimeFunction.getLocalWeekOfYear(dateValue);
            }
            case 22: {
                WeekFields wf = DateTimeFunction.getWeekFields();
                return DateTimeUtils.getWeekYear(dateValue, wf.getFirstDayOfWeek().getValue(), wf.getMinimalDaysInFirstWeek());
            }
            case 12: {
                return (DateTimeUtils.monthFromDateValue(dateValue) - 1) / 3 + 1;
            }
            case 19: {
                return DateTimeUtils.getIsoWeekYear(dateValue);
            }
            case 18: {
                return DateTimeUtils.getIsoWeekOfYear(dateValue);
            }
            case 17: {
                return DateTimeUtils.getIsoDayOfWeek(dateValue);
            }
            case 6: 
            case 7: 
            case 8: {
                int offsetSeconds = date instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)date).getTimeZoneOffsetSeconds() : (date instanceof ValueTimeTimeZone ? ((ValueTimeTimeZone)date).getTimeZoneOffsetSeconds() : session.currentTimeZone().getTimeZoneOffsetLocal(dateValue, timeNanos));
                if (field == 6) {
                    return offsetSeconds / 3600;
                }
                if (field == 7) {
                    return offsetSeconds % 3600 / 60;
                }
                return offsetSeconds % 60;
            }
        }
        throw DbException.getUnsupportedException("EXTRACT(" + DateTimeFunction.getFieldName(field) + " FROM " + date + ')');
    }

    private static Value truncateDate(SessionLocal session, int field, Value value) {
        long[] fieldDateAndTime = DateTimeUtils.dateAndTimeFromValue(value, session);
        long dateValue = fieldDateAndTime[0];
        long timeNanos = fieldDateAndTime[1];
        switch (field) {
            case 14: {
                timeNanos = timeNanos / 1000L * 1000L;
                break;
            }
            case 13: {
                timeNanos = timeNanos / 1000000L * 1000000L;
                break;
            }
            case 5: {
                timeNanos = timeNanos / 1000000000L * 1000000000L;
                break;
            }
            case 4: {
                timeNanos = timeNanos / 60000000000L * 60000000000L;
                break;
            }
            case 3: {
                timeNanos = timeNanos / 3600000000000L * 3600000000000L;
                break;
            }
            case 2: {
                timeNanos = 0L;
                break;
            }
            case 18: {
                dateValue = DateTimeFunction.truncateToWeek(dateValue, 1);
                timeNanos = 0L;
                break;
            }
            case 21: {
                dateValue = DateTimeFunction.truncateToWeek(dateValue, DateTimeFunction.getWeekFields().getFirstDayOfWeek().getValue());
                timeNanos = 0L;
                break;
            }
            case 19: {
                dateValue = DateTimeFunction.truncateToWeekYear(dateValue, 1, 4);
                timeNanos = 0L;
                break;
            }
            case 22: {
                WeekFields weekFields = DateTimeFunction.getWeekFields();
                dateValue = DateTimeFunction.truncateToWeekYear(dateValue, weekFields.getFirstDayOfWeek().getValue(), weekFields.getMinimalDaysInFirstWeek());
                break;
            }
            case 1: {
                dateValue = dateValue & 0xFFFFFFFFFFFFFFE0L | 1L;
                timeNanos = 0L;
                break;
            }
            case 12: {
                dateValue = DateTimeUtils.dateValue(DateTimeUtils.yearFromDateValue(dateValue), (DateTimeUtils.monthFromDateValue(dateValue) - 1) / 3 * 3 + 1, 1);
                timeNanos = 0L;
                break;
            }
            case 0: {
                dateValue = dateValue & 0xFFFFFFFFFFFFFE00L | 0x21L;
                timeNanos = 0L;
                break;
            }
            case 11: {
                int year = DateTimeUtils.yearFromDateValue(dateValue);
                year = year >= 0 ? year / 10 * 10 : (year - 9) / 10 * 10;
                dateValue = DateTimeUtils.dateValue(year, 1, 1);
                timeNanos = 0L;
                break;
            }
            case 10: {
                int year = DateTimeUtils.yearFromDateValue(dateValue);
                year = year > 0 ? (year - 1) / 100 * 100 + 1 : year / 100 * 100 - 99;
                dateValue = DateTimeUtils.dateValue(year, 1, 1);
                timeNanos = 0L;
                break;
            }
            case 9: {
                int year = DateTimeUtils.yearFromDateValue(dateValue);
                year = year > 0 ? (year - 1) / 1000 * 1000 + 1 : year / 1000 * 1000 - 999;
                dateValue = DateTimeUtils.dateValue(year, 1, 1);
                timeNanos = 0L;
                break;
            }
            default: {
                throw DbException.getUnsupportedException("DATE_TRUNC " + DateTimeFunction.getFieldName(field));
            }
        }
        Value result = DateTimeUtils.dateTimeToValue(value, dateValue, timeNanos);
        if (session.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && result.getValueType() == 17) {
            result = result.convertTo(21, (CastDataProvider)session);
        }
        return result;
    }

    private static long truncateToWeek(long dateValue, int firstDayOfWeek) {
        long absoluteDay = DateTimeUtils.absoluteDayFromDateValue(dateValue);
        int dayOfWeek = DateTimeUtils.getDayOfWeekFromAbsolute(absoluteDay, firstDayOfWeek);
        if (dayOfWeek != 1) {
            dateValue = DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay - (long)dayOfWeek + 1L);
        }
        return dateValue;
    }

    private static long truncateToWeekYear(long dateValue, int firstDayOfWeek, int minimalDaysInFirstWeek) {
        long next;
        int year;
        long base;
        long abs = DateTimeUtils.absoluteDayFromDateValue(dateValue);
        if (abs < (base = DateTimeUtils.getWeekYearAbsoluteStart(year = DateTimeUtils.yearFromDateValue(dateValue), firstDayOfWeek, minimalDaysInFirstWeek))) {
            base = DateTimeUtils.getWeekYearAbsoluteStart(year - 1, firstDayOfWeek, minimalDaysInFirstWeek);
        } else if (DateTimeUtils.monthFromDateValue(dateValue) == 12 && 24 + minimalDaysInFirstWeek < DateTimeUtils.dayFromDateValue(dateValue) && abs >= (next = DateTimeUtils.getWeekYearAbsoluteStart(year + 1, firstDayOfWeek, minimalDaysInFirstWeek))) {
            base = next;
        }
        return DateTimeUtils.dateValueFromAbsoluteDay(base);
    }

    public static Value dateadd(SessionLocal session, int field, long count, Value v) {
        if (field != 13 && field != 14 && field != 15 && (count > Integer.MAX_VALUE || count < Integer.MIN_VALUE)) {
            throw DbException.getInvalidValueException("DATEADD count", count);
        }
        long[] a = DateTimeUtils.dateAndTimeFromValue(v, session);
        long dateValue = a[0];
        long timeNanos = a[1];
        int type = v.getValueType();
        switch (field) {
            case 9: {
                return DateTimeFunction.addYearsMonths(field, true, count * 1000L, v, type, dateValue, timeNanos);
            }
            case 10: {
                return DateTimeFunction.addYearsMonths(field, true, count * 100L, v, type, dateValue, timeNanos);
            }
            case 11: {
                return DateTimeFunction.addYearsMonths(field, true, count * 10L, v, type, dateValue, timeNanos);
            }
            case 0: {
                return DateTimeFunction.addYearsMonths(field, true, count, v, type, dateValue, timeNanos);
            }
            case 12: {
                return DateTimeFunction.addYearsMonths(field, false, count *= 3L, v, type, dateValue, timeNanos);
            }
            case 1: {
                return DateTimeFunction.addYearsMonths(field, false, count, v, type, dateValue, timeNanos);
            }
            case 18: 
            case 21: {
                count *= 7L;
            }
            case 2: 
            case 16: 
            case 17: 
            case 20: 
            case 24: {
                if (type == 18 || type == 19) {
                    throw DbException.getInvalidValueException("DATEADD time part", DateTimeFunction.getFieldName(field));
                }
                dateValue = DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(dateValue) + count);
                return DateTimeUtils.dateTimeToValue(v, dateValue, timeNanos);
            }
            case 3: {
                count *= 3600000000000L;
                break;
            }
            case 4: {
                count *= 60000000000L;
                break;
            }
            case 5: 
            case 23: {
                count *= 1000000000L;
                break;
            }
            case 13: {
                count *= 1000000L;
                break;
            }
            case 14: {
                count *= 1000L;
                break;
            }
            case 15: {
                break;
            }
            case 6: {
                return DateTimeFunction.addToTimeZone(field, count * 3600L, v, type, dateValue, timeNanos);
            }
            case 7: {
                return DateTimeFunction.addToTimeZone(field, count * 60L, v, type, dateValue, timeNanos);
            }
            case 8: {
                return DateTimeFunction.addToTimeZone(field, count, v, type, dateValue, timeNanos);
            }
            default: {
                throw DbException.getUnsupportedException("DATEADD " + DateTimeFunction.getFieldName(field));
            }
        }
        if ((timeNanos += count) >= 86400000000000L || timeNanos < 0L) {
            long d = timeNanos >= 86400000000000L ? timeNanos / 86400000000000L : (timeNanos - 86400000000000L + 1L) / 86400000000000L;
            dateValue = DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromDateValue(dateValue) + d);
            timeNanos -= d * 86400000000000L;
        }
        if (type == 17) {
            return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
        }
        return DateTimeUtils.dateTimeToValue(v, dateValue, timeNanos);
    }

    private static Value addYearsMonths(int field, boolean years, long count, Value v, int type, long dateValue, long timeNanos) {
        if (type == 18 || type == 19) {
            throw DbException.getInvalidValueException("DATEADD time part", DateTimeFunction.getFieldName(field));
        }
        long year = DateTimeUtils.yearFromDateValue(dateValue);
        long month = DateTimeUtils.monthFromDateValue(dateValue);
        if (years) {
            year += count;
        } else {
            month += count;
        }
        return DateTimeUtils.dateTimeToValue(v, DateTimeUtils.dateValueFromDenormalizedDate(year, month, DateTimeUtils.dayFromDateValue(dateValue)), timeNanos);
    }

    private static Value addToTimeZone(int field, long count, Value v, int type, long dateValue, long timeNanos) {
        if (type == 21) {
            return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, MathUtils.convertLongToInt(count + (long)((ValueTimestampTimeZone)v).getTimeZoneOffsetSeconds()));
        }
        if (type == 19) {
            return ValueTimeTimeZone.fromNanos(timeNanos, MathUtils.convertLongToInt(count + (long)((ValueTimeTimeZone)v).getTimeZoneOffsetSeconds()));
        }
        throw DbException.getUnsupportedException("DATEADD " + DateTimeFunction.getFieldName(field));
    }

    private static long datediff(SessionLocal session, int field, Value v1, Value v2) {
        long[] a1 = DateTimeUtils.dateAndTimeFromValue(v1, session);
        long dateValue1 = a1[0];
        long absolute1 = DateTimeUtils.absoluteDayFromDateValue(dateValue1);
        long[] a2 = DateTimeUtils.dateAndTimeFromValue(v2, session);
        long dateValue2 = a2[0];
        long absolute2 = DateTimeUtils.absoluteDayFromDateValue(dateValue2);
        switch (field) {
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 23: {
                long timeNanos1 = a1[1];
                long timeNanos2 = a2[1];
                switch (field) {
                    case 15: {
                        return (absolute2 - absolute1) * 86400000000000L + (timeNanos2 - timeNanos1);
                    }
                    case 14: {
                        return (absolute2 - absolute1) * 86400000000L + (timeNanos2 / 1000L - timeNanos1 / 1000L);
                    }
                    case 13: {
                        return (absolute2 - absolute1) * 86400000L + (timeNanos2 / 1000000L - timeNanos1 / 1000000L);
                    }
                    case 5: 
                    case 23: {
                        return (absolute2 - absolute1) * 86400L + (timeNanos2 / 1000000000L - timeNanos1 / 1000000000L);
                    }
                    case 4: {
                        return (absolute2 - absolute1) * 1440L + (timeNanos2 / 60000000000L - timeNanos1 / 60000000000L);
                    }
                    case 3: {
                        return (absolute2 - absolute1) * 24L + (timeNanos2 / 3600000000000L - timeNanos1 / 3600000000000L);
                    }
                }
            }
            case 2: 
            case 16: 
            case 17: 
            case 20: 
            case 24: {
                return absolute2 - absolute1;
            }
            case 21: {
                return DateTimeFunction.weekdiff(absolute1, absolute2, DateTimeFunction.getWeekFields().getFirstDayOfWeek().getValue());
            }
            case 18: {
                return DateTimeFunction.weekdiff(absolute1, absolute2, 1);
            }
            case 1: {
                return (DateTimeUtils.yearFromDateValue(dateValue2) - DateTimeUtils.yearFromDateValue(dateValue1)) * 12 + DateTimeUtils.monthFromDateValue(dateValue2) - DateTimeUtils.monthFromDateValue(dateValue1);
            }
            case 12: {
                return (DateTimeUtils.yearFromDateValue(dateValue2) - DateTimeUtils.yearFromDateValue(dateValue1)) * 4 + (DateTimeUtils.monthFromDateValue(dateValue2) - 1) / 3 - (DateTimeUtils.monthFromDateValue(dateValue1) - 1) / 3;
            }
            case 9: {
                return DateTimeFunction.millennium(DateTimeUtils.yearFromDateValue(dateValue2)) - DateTimeFunction.millennium(DateTimeUtils.yearFromDateValue(dateValue1));
            }
            case 10: {
                return DateTimeFunction.century(DateTimeUtils.yearFromDateValue(dateValue2)) - DateTimeFunction.century(DateTimeUtils.yearFromDateValue(dateValue1));
            }
            case 11: {
                return DateTimeFunction.decade(DateTimeUtils.yearFromDateValue(dateValue2)) - DateTimeFunction.decade(DateTimeUtils.yearFromDateValue(dateValue1));
            }
            case 0: {
                return DateTimeUtils.yearFromDateValue(dateValue2) - DateTimeUtils.yearFromDateValue(dateValue1);
            }
            case 6: 
            case 7: 
            case 8: {
                int offsetSeconds1 = v1 instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)v1).getTimeZoneOffsetSeconds() : (v1 instanceof ValueTimeTimeZone ? ((ValueTimeTimeZone)v1).getTimeZoneOffsetSeconds() : session.currentTimeZone().getTimeZoneOffsetLocal(dateValue1, a1[1]));
                int offsetSeconds2 = v2 instanceof ValueTimestampTimeZone ? ((ValueTimestampTimeZone)v2).getTimeZoneOffsetSeconds() : (v2 instanceof ValueTimeTimeZone ? ((ValueTimeTimeZone)v2).getTimeZoneOffsetSeconds() : session.currentTimeZone().getTimeZoneOffsetLocal(dateValue2, a2[1]));
                if (field == 6) {
                    return offsetSeconds2 / 3600 - offsetSeconds1 / 3600;
                }
                if (field == 7) {
                    return offsetSeconds2 / 60 - offsetSeconds1 / 60;
                }
                return offsetSeconds2 - offsetSeconds1;
            }
        }
        throw DbException.getUnsupportedException("DATEDIFF " + DateTimeFunction.getFieldName(field));
    }

    private static long weekdiff(long absolute1, long absolute2, int firstDayOfWeek) {
        long r1 = (absolute1 += (long)(4 - firstDayOfWeek)) / 7L;
        if (absolute1 < 0L && r1 * 7L != absolute1) {
            --r1;
        }
        long r2 = (absolute2 += (long)(4 - firstDayOfWeek)) / 7L;
        if (absolute2 < 0L && r2 * 7L != absolute2) {
            --r2;
        }
        return r2 - r1;
    }

    private static int millennium(int year) {
        return year > 0 ? (year + 999) / 1000 : year / 1000;
    }

    private static int century(int year) {
        return year > 0 ? (year + 99) / 100 : year / 100;
    }

    private static int decade(int year) {
        return year >= 0 ? year / 10 : (year - 9) / 10;
    }

    private static int getLocalDayOfWeek(long dateValue) {
        return DateTimeUtils.getDayOfWeek(dateValue, DateTimeFunction.getWeekFields().getFirstDayOfWeek().getValue());
    }

    private static int getLocalWeekOfYear(long dateValue) {
        WeekFields weekFields = DateTimeFunction.getWeekFields();
        return DateTimeUtils.getWeekOfYear(dateValue, weekFields.getFirstDayOfWeek().getValue(), weekFields.getMinimalDaysInFirstWeek());
    }

    private static WeekFields getWeekFields() {
        WeekFields weekFields = WEEK_FIELDS;
        if (weekFields == null) {
            WEEK_FIELDS = weekFields = WeekFields.of(Locale.getDefault());
        }
        return weekFields;
    }

    private static ValueNumeric extractEpoch(SessionLocal session, Value value) {
        ValueNumeric result;
        if (value instanceof ValueInterval) {
            ValueInterval interval = (ValueInterval)value;
            if (interval.getQualifier().isYearMonth()) {
                interval = (ValueInterval)interval.convertTo(TypeInfo.TYPE_INTERVAL_YEAR_TO_MONTH);
                long leading = interval.getLeading();
                long remaining = interval.getRemaining();
                BigInteger bi = BigInteger.valueOf(leading).multiply(BigInteger.valueOf(31557600L)).add(BigInteger.valueOf(remaining * 2592000L));
                if (interval.isNegative()) {
                    bi = bi.negate();
                }
                return ValueNumeric.get(bi);
            }
            return ValueNumeric.get(new BigDecimal(IntervalUtils.intervalToAbsolute(interval)).divide(BD_NANOS_PER_SECOND));
        }
        long[] a = DateTimeUtils.dateAndTimeFromValue(value, session);
        long dateValue = a[0];
        long timeNanos = a[1];
        if (value instanceof ValueTime) {
            result = ValueNumeric.get(BigDecimal.valueOf(timeNanos).divide(BD_NANOS_PER_SECOND));
        } else if (value instanceof ValueDate) {
            result = ValueNumeric.get(BigInteger.valueOf(DateTimeUtils.absoluteDayFromDateValue(dateValue)).multiply(BI_SECONDS_PER_DAY));
        } else {
            BigDecimal bd = BigDecimal.valueOf(timeNanos).divide(BD_NANOS_PER_SECOND).add(BigDecimal.valueOf(DateTimeUtils.absoluteDayFromDateValue(dateValue)).multiply(BD_SECONDS_PER_DAY));
            result = value instanceof ValueTimestampTimeZone ? ValueNumeric.get(bd.subtract(BigDecimal.valueOf(((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds()))) : (value instanceof ValueTimeTimeZone ? ValueNumeric.get(bd.subtract(BigDecimal.valueOf(((ValueTimeTimeZone)value).getTimeZoneOffsetSeconds()))) : ValueNumeric.get(bd));
        }
        return result;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        switch (this.function) {
            case 0: {
                this.type = this.field == 23 ? TypeInfo.getTypeInfo(13, 28L, 9, null) : TypeInfo.TYPE_INTEGER;
                break;
            }
            case 1: {
                this.type = this.left.getType();
                int valueType = this.type.getValueType();
                if (!DataType.isDateTimeType(valueType)) {
                    throw Store.getInvalidExpressionTypeException("DATE_TRUNC datetime argument", this.left);
                }
                if (session.getMode().getEnum() != Mode.ModeEnum.PostgreSQL || valueType != 17) break;
                this.type = TypeInfo.TYPE_TIMESTAMP_TZ;
                break;
            }
            case 2: {
                int valueType = this.right.getType().getValueType();
                if (valueType == 17) {
                    switch (this.field) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 23: {
                            valueType = 20;
                        }
                    }
                }
                this.type = TypeInfo.getTypeInfo(valueType);
                break;
            }
            case 3: {
                this.type = TypeInfo.TYPE_BIGINT;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append(this.getName()).append('(').append(DateTimeFunction.getFieldName(this.field));
        switch (this.function) {
            case 0: {
                this.left.getUnenclosedSQL(builder.append(" FROM "), sqlFlags);
                break;
            }
            case 1: {
                this.left.getUnenclosedSQL(builder.append(", "), sqlFlags);
                break;
            }
            case 2: 
            case 3: {
                this.left.getUnenclosedSQL(builder.append(", "), sqlFlags).append(", ");
                this.right.getUnenclosedSQL(builder, sqlFlags);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return builder.append(')');
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

