/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

public final class DBObjectFunction
extends FunctionN {
    public static final int DB_OBJECT_ID = 0;
    public static final int DB_OBJECT_SQL = 1;
    private static final String[] NAMES = new String[]{"DB_OBJECT_ID", "DB_OBJECT_SQL"};
    private final int function;

    public DBObjectFunction(Expression objectType, Expression arg1, Expression arg2, int function) {
        Expression[] expressionArray;
        if (arg2 == null) {
            Expression[] expressionArray2 = new Expression[2];
            expressionArray2[0] = objectType;
            expressionArray = expressionArray2;
            expressionArray2[1] = arg1;
        } else {
            Expression[] expressionArray3 = new Expression[3];
            expressionArray3[0] = objectType;
            expressionArray3[1] = arg1;
            expressionArray = expressionArray3;
            expressionArray3[2] = arg2;
        }
        super(expressionArray);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        DbObject object;
        session.getUser().checkAdmin();
        String objectType = v1.getString();
        if (v3 != null) {
            Schema schema = session.getDatabase().findSchema(v2.getString());
            if (schema == null) {
                return ValueNull.INSTANCE;
            }
            String objectName = v3.getString();
            switch (objectType) {
                case "CONSTANT": {
                    object = schema.findConstant(objectName);
                    break;
                }
                case "CONSTRAINT": {
                    object = schema.findConstraint(session, objectName);
                    break;
                }
                case "DOMAIN": {
                    object = schema.findDomain(objectName);
                    break;
                }
                case "INDEX": {
                    object = schema.findIndex(session, objectName);
                    break;
                }
                case "ROUTINE": {
                    object = schema.findFunctionOrAggregate(objectName);
                    break;
                }
                case "SEQUENCE": {
                    object = schema.findSequence(objectName);
                    break;
                }
                case "SYNONYM": {
                    object = schema.getSynonym(objectName);
                    break;
                }
                case "TABLE": {
                    object = schema.findTableOrView(session, objectName);
                    break;
                }
                case "TRIGGER": {
                    object = schema.findTrigger(objectName);
                    break;
                }
                default: {
                    return ValueNull.INSTANCE;
                }
            }
        } else {
            String objectName = v2.getString();
            Database database = session.getDatabase();
            switch (objectType) {
                case "ROLE": {
                    object = database.findRole(objectName);
                    break;
                }
                case "SETTING": {
                    object = database.findSetting(objectName);
                    break;
                }
                case "SCHEMA": {
                    object = database.findSchema(objectName);
                    break;
                }
                case "USER": {
                    object = database.findUser(objectName);
                    break;
                }
                default: {
                    return ValueNull.INSTANCE;
                }
            }
        }
        if (object == null) {
            return ValueNull.INSTANCE;
        }
        switch (this.function) {
            case 0: {
                return ValueInteger.get(object.getId());
            }
            case 1: {
                String sql = object.getCreateSQLForMeta();
                return sql != null ? ValueVarchar.get(sql, session) : ValueNull.INSTANCE;
            }
        }
        throw DbException.getInternalError("function=" + this.function);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.optimizeArguments(session, false);
        this.type = this.function == 0 ? TypeInfo.TYPE_INTEGER : TypeInfo.TYPE_VARCHAR;
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                return false;
            }
        }
        return super.isEverything(visitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

