/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.Function1;
import org.h2.schema.Domain;
import org.h2.table.Column;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public final class CastSpecification
extends Function1 {
    private Domain domain;

    public CastSpecification(Expression arg, Column column) {
        super(arg);
        this.type = column.getType();
        this.domain = column.getDomain();
    }

    public CastSpecification(Expression arg, TypeInfo type) {
        super(arg);
        this.type = type;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v = this.arg.getValue(session).castTo(this.type, session);
        if (this.domain != null) {
            this.domain.checkConstraints(session, v);
        }
        return v;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        Value v;
        this.arg = this.arg.optimize(session);
        if (this.arg.isConstant() && ((v = this.getValue(session)) == ValueNull.INSTANCE || CastSpecification.canOptimizeCast(this.arg.getType().getValueType(), this.type.getValueType()))) {
            return TypedValueExpression.get(v, this.type);
        }
        return this;
    }

    @Override
    public boolean isConstant() {
        return this.arg instanceof ValueExpression && CastSpecification.canOptimizeCast(this.arg.getType().getValueType(), this.type.getValueType());
    }

    private static boolean canOptimizeCast(int src, int dst) {
        switch (src) {
            case 18: {
                switch (dst) {
                    case 19: 
                    case 20: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 19: {
                switch (dst) {
                    case 18: 
                    case 20: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 17: {
                if (dst != 21) break;
                return false;
            }
            case 20: {
                switch (dst) {
                    case 19: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 21: {
                switch (dst) {
                    case 17: 
                    case 18: 
                    case 20: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append("CAST(");
        this.arg.getUnenclosedSQL(builder, this.arg instanceof ValueExpression ? sqlFlags | 4 : sqlFlags).append(" AS ");
        return (this.domain != null ? this.domain : this.type).getSQL(builder, sqlFlags).append(')');
    }

    @Override
    public String getName() {
        return "CAST";
    }
}

