/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function1;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

public final class CardinalityExpression
extends Function1 {
    private final boolean max;

    public CardinalityExpression(Expression arg, boolean max) {
        super(arg);
        this.max = max;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value getValue(SessionLocal session) {
        int result;
        if (this.max) {
            TypeInfo t = this.arg.getType();
            if (t.getValueType() != 40) throw DbException.getInvalidValueException("array", this.arg.getValue(session).getTraceSQL());
            result = MathUtils.convertLongToInt(t.getPrecision());
            return ValueInteger.get(result);
        } else {
            Value v = this.arg.getValue(session);
            if (v == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            if (v.getValueType() != 40) {
                throw DbException.getInvalidValueException("array", v.getTraceSQL());
            }
            result = ((ValueArray)v).getList().length;
        }
        return ValueInteger.get(result);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        this.type = TypeInfo.TYPE_INTEGER;
        if (this.arg.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return this.max ? "ARRAY_MAX_CARDINALITY" : "CARDINALITY";
    }
}

