/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.sql.SQLException;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.FunctionN;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.tools.Csv;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;

public final class CSVWriteFunction
extends FunctionN {
    public CSVWriteFunction() {
        super(new Expression[4]);
    }

    @Override
    public Value getValue(SessionLocal session) {
        session.getUser().checkAdmin();
        JdbcConnection conn = session.createConnection(false);
        Csv csv = new Csv();
        String options = this.getValue(session, 2);
        String charset = null;
        if (options != null && options.indexOf(61) >= 0) {
            charset = csv.setOptions(options);
        } else {
            charset = options;
            String fieldSeparatorWrite = this.getValue(session, 3);
            String fieldDelimiter = this.getValue(session, 4);
            String escapeCharacter = this.getValue(session, 5);
            String nullString = this.getValue(session, 6);
            String lineSeparator = this.getValue(session, 7);
            CSVWriteFunction.setCsvDelimiterEscape(csv, fieldSeparatorWrite, fieldDelimiter, escapeCharacter);
            csv.setNullString(nullString);
            if (lineSeparator != null) {
                csv.setLineSeparator(lineSeparator);
            }
        }
        try {
            return ValueInteger.get(csv.write(conn, this.args[0].getValue(session).getString(), this.args[1].getValue(session).getString(), charset));
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    private String getValue(SessionLocal session, int index) {
        return index < this.args.length ? this.args[index].getValue(session).getString() : null;
    }

    public static void setCsvDelimiterEscape(Csv csv, String fieldSeparator, String fieldDelimiter, String escapeCharacter) {
        if (fieldSeparator != null) {
            csv.setFieldSeparatorWrite(fieldSeparator);
            if (!fieldSeparator.isEmpty()) {
                char fs = fieldSeparator.charAt(0);
                csv.setFieldSeparatorRead(fs);
            }
        }
        if (fieldDelimiter != null) {
            char fd = fieldDelimiter.isEmpty() ? (char)'\u0000' : fieldDelimiter.charAt(0);
            csv.setFieldDelimiter(fd);
        }
        if (escapeCharacter != null) {
            char ec = escapeCharacter.isEmpty() ? (char)'\u0000' : escapeCharacter.charAt(0);
            csv.setEscapeCharacter(ec);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.optimizeArguments(session, false);
        int len = this.args.length;
        if (len < 2 || len > 8) {
            throw DbException.get(7001, this.getName(), "2..8");
        }
        this.type = TypeInfo.TYPE_INTEGER;
        return this;
    }

    @Override
    public String getName() {
        return "CSVWRITE";
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!super.isEverything(visitor)) {
            return false;
        }
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return false;
            }
        }
        return true;
    }
}

