/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.ArrayList;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.SimplePredicate;
import org.h2.index.IndexCondition;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

public final class NullPredicate
extends SimplePredicate {
    private boolean optimized;

    public NullPredicate(Expression left, boolean not, boolean whenOperand) {
        super(left, not, whenOperand);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        return builder.append(this.not ? " IS NOT NULL" : " IS NULL");
    }

    @Override
    public Expression optimize(SessionLocal session) {
        ExpressionList list;
        if (this.optimized) {
            return this;
        }
        Expression o = super.optimize(session);
        if (o != this) {
            return o;
        }
        this.optimized = true;
        if (!this.whenOperand && this.left instanceof ExpressionList && !(list = (ExpressionList)this.left).isArray()) {
            int count = list.getSubexpressionCount();
            for (int i = 0; i < count; ++i) {
                int j;
                if (!list.getSubexpression(i).isNullConstant()) continue;
                if (this.not) {
                    return ValueExpression.FALSE;
                }
                ArrayList<Expression> newList = new ArrayList<Expression>(count - 1);
                for (j = 0; j < i; ++j) {
                    newList.add(list.getSubexpression(j));
                }
                for (j = i + 1; j < count; ++j) {
                    Expression e = list.getSubexpression(j);
                    if (e.isNullConstant()) continue;
                    newList.add(e);
                }
                this.left = newList.size() == 1 ? (Expression)newList.get(0) : new ExpressionList(newList.toArray(new Expression[0]), false);
                break;
            }
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return ValueBoolean.get(this.getValue(this.left.getValue(session)));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        return this.getValue(left);
    }

    private boolean getValue(Value left) {
        if (left.getType().getValueType() == 41) {
            for (Value v : ((ValueRow)left).getList()) {
                if (!(v != ValueNull.INSTANCE ^ this.not)) continue;
                return false;
            }
            return true;
        }
        return left == ValueNull.INSTANCE ^ this.not;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        Expression o = this.optimize(session);
        if (o != this) {
            return o.getNotIfPossible(session);
        }
        switch (this.left.getType().getValueType()) {
            case -1: 
            case 41: {
                return null;
            }
        }
        return new NullPredicate(this.left, !this.not, false);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        ExpressionList list;
        if (this.not || this.whenOperand || !filter.getTable().isQueryComparable()) {
            return;
        }
        if (this.left instanceof ExpressionColumn) {
            NullPredicate.createNullIndexCondition(filter, (ExpressionColumn)this.left);
        } else if (this.left instanceof ExpressionList && !(list = (ExpressionList)this.left).isArray()) {
            int count = list.getSubexpressionCount();
            for (int i = 0; i < count; ++i) {
                Expression e = list.getSubexpression(i);
                if (!(e instanceof ExpressionColumn)) continue;
                NullPredicate.createNullIndexCondition(filter, (ExpressionColumn)e);
            }
        }
    }

    private static void createNullIndexCondition(TableFilter filter, ExpressionColumn c) {
        if (filter == c.getTableFilter() && c.getType().getValueType() != 41) {
            filter.addIndexCondition(IndexCondition.get(6, c, ValueExpression.NULL));
        }
    }
}

