/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Condition;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.json.JSONBytesSource;
import org.h2.util.json.JSONItemType;
import org.h2.util.json.JSONStringSource;
import org.h2.util.json.JSONValidationTarget;
import org.h2.util.json.JSONValidationTargetWithUniqueKeys;
import org.h2.util.json.JSONValidationTargetWithoutUniqueKeys;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;

public final class IsJsonPredicate
extends Condition {
    private Expression left;
    private final boolean not;
    private final boolean whenOperand;
    private final boolean withUniqueKeys;
    private final JSONItemType itemType;

    public IsJsonPredicate(Expression left, boolean not, boolean whenOperand, boolean withUniqueKeys, JSONItemType itemType) {
        this.left = left;
        this.whenOperand = whenOperand;
        this.not = not;
        this.withUniqueKeys = withUniqueKeys;
        this.itemType = itemType;
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        builder.append(" IS");
        if (this.not) {
            builder.append(" NOT");
        }
        builder.append(" JSON");
        switch (this.itemType) {
            case VALUE: {
                break;
            }
            case ARRAY: {
                builder.append(" ARRAY");
                break;
            }
            case OBJECT: {
                builder.append(" OBJECT");
                break;
            }
            case SCALAR: {
                builder.append(" SCALAR");
                break;
            }
            default: {
                throw DbException.getInternalError("itemType=" + (Object)((Object)this.itemType));
            }
        }
        if (this.withUniqueKeys) {
            builder.append(" WITH UNIQUE KEYS");
        }
        return builder;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (!this.whenOperand && this.left.isConstant()) {
            return ValueExpression.getBoolean(this.getValue(session));
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.getValue(l));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        if (left == ValueNull.INSTANCE) {
            return false;
        }
        return this.getValue(left);
    }

    private boolean getValue(Value left) {
        boolean result;
        switch (left.getValueType()) {
            case 5: 
            case 6: 
            case 7: {
                byte[] bytes = left.getBytesNoCopy();
                JSONValidationTarget target = this.withUniqueKeys ? new JSONValidationTargetWithUniqueKeys() : new JSONValidationTargetWithoutUniqueKeys();
                try {
                    result = this.itemType.includes(JSONBytesSource.parse(bytes, target)) ^ this.not;
                }
                catch (RuntimeException ex) {
                    result = this.not;
                }
                break;
            }
            case 38: {
                JSONItemType valueItemType = ((ValueJson)left).getItemType();
                if (!this.itemType.includes(valueItemType)) {
                    result = this.not;
                    break;
                }
                if (!this.withUniqueKeys || valueItemType == JSONItemType.SCALAR) {
                    result = !this.not;
                    break;
                }
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                String string = left.getString();
                JSONValidationTarget target = this.withUniqueKeys ? new JSONValidationTargetWithUniqueKeys() : new JSONValidationTargetWithoutUniqueKeys();
                try {
                    result = this.itemType.includes(JSONStringSource.parse(string, target)) ^ this.not;
                }
                catch (RuntimeException ex) {
                    result = this.not;
                }
                break;
            }
            default: {
                result = this.not;
            }
        }
        return result;
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new IsJsonPredicate(this.left, !this.not, false, this.withUniqueKeys, this.itemType);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor);
    }

    @Override
    public int getCost() {
        int cost = this.left.getCost();
        cost = !(this.left.getType().getValueType() != 38 || this.withUniqueKeys && this.itemType != JSONItemType.SCALAR) ? ++cost : (cost += 10);
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        throw new IndexOutOfBoundsException();
    }
}

