/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.AbstractList;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.index.IndexCondition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public final class ConditionInParameter
extends Condition {
    private Expression left;
    private boolean not;
    private boolean whenOperand;
    private final Parameter parameter;

    static Value getValue(SessionLocal session, Value l, boolean not, Value value) {
        boolean hasNull = false;
        if (value.containsNull()) {
            hasNull = true;
        } else {
            for (Value r : value.convertToAnyArray(session).getList()) {
                Value cmp = Comparison.compare(session, l, r, 0);
                if (cmp == ValueNull.INSTANCE) {
                    hasNull = true;
                    continue;
                }
                if (cmp != ValueBoolean.TRUE) continue;
                return ValueBoolean.get(!not);
            }
        }
        if (hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(not);
    }

    public ConditionInParameter(Expression left, boolean not, boolean whenOperand, Parameter parameter) {
        this.left = left;
        this.not = not;
        this.whenOperand = whenOperand;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ConditionInParameter.getValue(session, l, this.not, this.parameter.getValue(session));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        if (left == ValueNull.INSTANCE) {
            return false;
        }
        return ConditionInParameter.getValue(session, left, this.not, this.parameter.getValue(session)).isTrue();
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (!this.whenOperand && this.left.isNullConstant()) {
            return TypedValueExpression.UNKNOWN;
        }
        return this;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new ConditionInParameter(this.left, !this.not, false, this.parameter);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (this.not || this.whenOperand || !(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        filter.addIndexCondition(IndexCondition.getInList(l, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        if (this.not) {
            builder.append("NOT (");
        }
        this.left.getSQL(builder, sqlFlags, 0);
        this.parameter.getSQL(builder.append(" = ANY("), sqlFlags, 0).append(')');
        if (this.not) {
            builder.append(')');
        }
        return builder;
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        if (this.not) {
            builder.append(" NOT IN(UNNEST(");
            this.parameter.getSQL(builder, sqlFlags, 0).append("))");
        } else {
            builder.append(" = ANY(");
            this.parameter.getSQL(builder, sqlFlags, 0).append(')');
        }
        return builder;
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.parameter.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int index) {
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value).getList()[index]);
            }
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ((ValueArray)value).getList().length;
            }
            return 1;
        }
    }
}

